/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.client.location;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.Set;
import org.opennms.features.poller.remote.gwt.client.GWTBounds;
import org.opennms.features.poller.remote.gwt.client.GWTLatLng;
import org.opennms.features.poller.remote.gwt.client.GWTMarkerState;
import org.opennms.features.poller.remote.gwt.client.StatusDetails;
import org.opennms.features.poller.remote.gwt.client.utils.CompareToBuilder;
import org.opennms.features.poller.remote.gwt.client.utils.EqualsUtil;
import org.opennms.features.poller.remote.gwt.client.utils.HashCodeBuilder;
import org.opennms.features.poller.remote.gwt.client.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationInfo
implements IsSerializable,
Serializable,
Comparable<LocationInfo> {
    private static final long serialVersionUID = 1L;
    private String m_name;
    private String m_pollingPackage;
    private String m_area;
    private String m_geolocation;
    private String m_coordinates;
    private Long m_priority = 100L;
    private GWTMarkerState m_markerState;
    private StatusDetails m_statusDetails;
    private Set<String> m_tags;

    public LocationInfo() {
    }

    public LocationInfo(LocationInfo info) {
        this(info.getName(), info.getPollingPackageName(), info.getArea(), info.getGeolocation(), info.getCoordinates(), info.getPriority(), info.getMarkerState(), info.getStatusDetails(), info.getTags());
    }

    public LocationInfo(String name, String pollingPackageName, String area, String geolocation, String coordinates, Long priority, GWTMarkerState marker, StatusDetails statusDetails, Set<String> tags) {
        this.setName(name);
        this.setPollingPackageName(pollingPackageName);
        this.setArea(area);
        this.setGeolocation(geolocation);
        this.setCoordinates(coordinates);
        this.setPriority(priority);
        this.setTags(tags);
        this.setMarkerState(marker);
        this.setStatusDetails(statusDetails);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getPollingPackageName() {
        return this.m_pollingPackage;
    }

    public void setPollingPackageName(String pollingPackageName) {
        this.m_pollingPackage = pollingPackageName;
    }

    public String getArea() {
        return this.m_area;
    }

    public void setArea(String area) {
        this.m_area = area;
    }

    public String getGeolocation() {
        return this.m_geolocation;
    }

    public void setGeolocation(String geolocation) {
        this.m_geolocation = geolocation;
    }

    public String getCoordinates() {
        return this.m_coordinates;
    }

    public void setCoordinates(String coordinates) {
        this.m_coordinates = coordinates;
    }

    public Long getPriority() {
        return this.m_priority;
    }

    public void setPriority(Long priority) {
        this.m_priority = priority;
    }

    public Set<String> getTags() {
        return this.m_tags;
    }

    public void setTags(Set<String> tags) {
        this.m_tags = tags;
    }

    public StatusDetails getStatusDetails() {
        if (this.m_statusDetails == null) {
            return StatusDetails.uninitialized();
        }
        return this.m_statusDetails;
    }

    public void setStatusDetails(StatusDetails status) {
        this.m_statusDetails = status;
        if (this.m_markerState != null && status != null) {
            this.m_markerState.setStatus(status.getStatus());
        }
    }

    public GWTMarkerState getMarkerState() {
        return this.m_markerState;
    }

    public void setMarkerState(GWTMarkerState markerState) {
        this.m_markerState = markerState;
    }

    public GWTLatLng getLatLng() {
        return GWTLatLng.fromCoordinates(this.getCoordinates());
    }

    public boolean isVisible(GWTBounds bounds) {
        return bounds.contains(this.getLatLng());
    }

    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof LocationInfo)) {
            return false;
        }
        LocationInfo that = (LocationInfo)aThat;
        return EqualsUtil.areEqual(this.getName(), that.getName());
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getName()).toHashcode();
    }

    @Override
    public int compareTo(LocationInfo that) {
        return new CompareToBuilder().append(this.getStatusDetails(), that.getStatusDetails()).append(this.getPriority(), that.getPriority()).append(this.getName(), that.getName()).toComparison();
    }

    public String toString() {
        return "LocationInfo[name=" + this.m_name + ",polling package=" + this.m_pollingPackage + ",area=" + this.m_area + ",geolocation=" + this.m_geolocation + ",coordinates=" + this.m_coordinates + ",priority=" + this.m_priority + ",status=" + this.m_statusDetails.toString() + ",marker=" + this.m_markerState + ",tags=[" + StringUtils.join(this.m_tags, ",") + "]";
    }

    public String getMarkerImageURL() {
        return this.m_markerState.getImageURL();
    }
}

