/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.InlineHTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagPanel
extends Composite
implements Collection<String> {
    private final List<String> m_delegate = new ArrayList<String>();
    private static final Binder BINDER = (Binder)GWT.create(Binder.class);
    private transient HandlerManager m_eventBus;
    @UiField
    FlowPanel tagPanel;
    @UiField
    TagStyles tagStyles;
    @UiField
    Hyperlink clearTags;

    public TagPanel() {
        this.initWidget((Widget)BINDER.createAndBindUi(this));
    }

    public void setEventBus(HandlerManager eventBus) {
        this.m_eventBus = eventBus;
    }

    @UiHandler(value={"clearTags"})
    public void onClearTagsClick(ClickEvent event) {
        for (int i = 0; i < this.tagPanel.getWidgetCount(); ++i) {
            this.tagPanel.getWidget(i).removeStyleName(this.tagStyles.selectedTag());
        }
        this.m_eventBus.fireEvent((GwtEvent)new TagClearedEvent());
    }

    @Override
    public boolean add(String e) {
        boolean retval = this.m_delegate.add(e);
        this.updatePanel();
        return retval;
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        boolean retval = this.m_delegate.addAll(c);
        this.updatePanel();
        this.m_eventBus.fireEvent((GwtEvent)new TagResizeEvent());
        return retval;
    }

    @Override
    public void clear() {
        this.m_delegate.clear();
        this.updatePanel();
    }

    @Override
    public boolean contains(Object o) {
        return this.m_delegate.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.m_delegate.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.m_delegate.isEmpty();
    }

    @Override
    public Iterator<String> iterator() {
        return this.m_delegate.iterator();
    }

    @Override
    public boolean remove(Object o) {
        boolean retval = this.m_delegate.remove(o);
        this.updatePanel();
        return retval;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean retval = this.m_delegate.removeAll(c);
        this.updatePanel();
        return retval;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean retval = this.m_delegate.retainAll(c);
        this.updatePanel();
        return retval;
    }

    @Override
    public int size() {
        return this.m_delegate.size();
    }

    @Override
    public Object[] toArray() {
        return this.m_delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.m_delegate.toArray(a);
    }

    public void selectTag(String tag) {
        for (Widget widget : this.tagPanel) {
            if (!(widget instanceof Anchor)) continue;
            Anchor anchor = (Anchor)widget;
            if (tag != null && tag.replaceAll(" ", "&nbsp;").equals(anchor.getHTML())) {
                anchor.addStyleName(this.tagStyles.selectedTag());
                continue;
            }
            anchor.removeStyleName(this.tagStyles.selectedTag());
        }
    }

    private void updatePanel() {
        int minCount = Integer.MAX_VALUE;
        int maxCount = Integer.MIN_VALUE;
        TreeMap<String, Integer> tagCounts = new TreeMap<String, Integer>();
        for (String string : this.m_delegate) {
            if (tagCounts.containsKey(string)) {
                tagCounts.put(string, (Integer)tagCounts.get(string) + 1);
                continue;
            }
            tagCounts.put(string, 1);
        }
        Iterator<Object> i$ = tagCounts.values().iterator();
        while (i$.hasNext()) {
            int n = (Integer)((Object)i$.next());
            if (n < minCount) {
                minCount = n;
            }
            if (n <= maxCount) continue;
            maxCount = n;
        }
        this.tagPanel.clear();
        for (Map.Entry entry : tagCounts.entrySet()) {
            final String tagText = (String)entry.getKey();
            Anchor tagLabel = new Anchor();
            double rawValue = (double)((Integer)entry.getValue() - minCount) * 10.0 / (double)(maxCount - minCount);
            tagLabel.setHTML(tagText.replace(" ", "&nbsp;"));
            tagLabel.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    TagPanel.this.selectTag(tagText);
                    TagPanel.this.m_eventBus.fireEvent((GwtEvent)new TagSelectedEvent(tagText));
                }
            });
            switch ((int)Math.round(rawValue)) {
                case 0: {
                    tagLabel.addStyleName(this.tagStyles.tag0());
                    break;
                }
                case 1: {
                    tagLabel.addStyleName(this.tagStyles.tag1());
                    break;
                }
                case 2: {
                    tagLabel.addStyleName(this.tagStyles.tag2());
                    break;
                }
                case 3: {
                    tagLabel.addStyleName(this.tagStyles.tag3());
                    break;
                }
                case 4: {
                    tagLabel.addStyleName(this.tagStyles.tag4());
                    break;
                }
                case 5: {
                    tagLabel.addStyleName(this.tagStyles.tag5());
                    break;
                }
                case 6: {
                    tagLabel.addStyleName(this.tagStyles.tag6());
                    break;
                }
                case 7: {
                    tagLabel.addStyleName(this.tagStyles.tag7());
                    break;
                }
                case 8: {
                    tagLabel.addStyleName(this.tagStyles.tag8());
                    break;
                }
                case 9: {
                    tagLabel.addStyleName(this.tagStyles.tag9());
                    break;
                }
                default: {
                    tagLabel.addStyleName(this.tagStyles.tag9());
                }
            }
            this.tagPanel.add((Widget)tagLabel);
            this.tagPanel.add((Widget)new InlineHTML(" "));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TagResizeEvent
    extends GwtEvent<TagResizeEventHandler> {
        public static GwtEvent.Type<TagResizeEventHandler> TYPE = new GwtEvent.Type();

        protected void dispatch(TagResizeEventHandler handler) {
            handler.onTagPanelResize();
        }

        public GwtEvent.Type<TagResizeEventHandler> getAssociatedType() {
            return TYPE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TagClearedEvent
    extends GwtEvent<TagClearedEventHandler> {
        public static GwtEvent.Type<TagClearedEventHandler> TYPE = new GwtEvent.Type();

        protected void dispatch(TagClearedEventHandler handler) {
            handler.onTagCleared();
        }

        public GwtEvent.Type<TagClearedEventHandler> getAssociatedType() {
            return TYPE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TagSelectedEvent
    extends GwtEvent<TagSelectedEventHandler> {
        public static GwtEvent.Type<TagSelectedEventHandler> TYPE = new GwtEvent.Type();
        private final String m_tagName;

        public TagSelectedEvent(String tagName) {
            this.m_tagName = tagName;
        }

        protected void dispatch(TagSelectedEventHandler handler) {
            handler.onTagSelected(this.m_tagName);
        }

        public GwtEvent.Type<TagSelectedEventHandler> getAssociatedType() {
            return TYPE;
        }
    }

    public static interface TagResizeEventHandler
    extends EventHandler {
        public void onTagPanelResize();
    }

    public static interface TagClearedEventHandler
    extends EventHandler {
        public void onTagCleared();
    }

    public static interface TagSelectedEventHandler
    extends EventHandler {
        public void onTagSelected(String var1);
    }

    static interface TagStyles
    extends CssResource {
        public static final double COUNT = 10.0;

        public String selectedTag();

        public String tag0();

        public String tag1();

        public String tag2();

        public String tag3();

        public String tag4();

        public String tag5();

        public String tag6();

        public String tag7();

        public String tag8();

        public String tag9();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Binder
    extends UiBinder<Widget, TagPanel> {
    }
}

