/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.client;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.opennms.features.poller.remote.gwt.client.PageableList;
import org.opennms.features.poller.remote.gwt.client.events.LocationPanelSelectEvent;
import org.opennms.features.poller.remote.gwt.client.location.LocationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageableLocationList
extends PageableList {
    private ArrayList<? extends LocationInfo> m_locations;

    @Override
    protected Widget getListItemWidget(int rowIndex) {
        return new LocationInfoDisplay(this.getLocations().get(rowIndex));
    }

    public void updateList(ArrayList<? extends LocationInfo> locations) {
        this.setLocations(locations);
        this.refresh();
    }

    private ArrayList<? extends LocationInfo> getLocations() {
        return this.m_locations;
    }

    private void setLocations(ArrayList<? extends LocationInfo> locations) {
        this.m_locations = locations;
    }

    @Override
    protected int getListSize() {
        if (this.getLocations() == null) {
            return 0;
        }
        return this.getLocations().size();
    }

    @Override
    public void onItemClickHandler(ClickEvent event) {
        HTMLTable.Cell cell = this.getCellForEvent(event);
        LocationInfo location = this.m_locations.get(cell.getRowIndex() + this.getCurrentPageIndex() * this.getTotalListItemsPerPage());
        this.fireEvent(new LocationPanelSelectEvent(location.getName()));
    }

    public void refreshLocationListResize() {
        for (int i = 0; i < this.getDataList().getRowCount(); ++i) {
            LocationInfoDisplay locInfo = (LocationInfoDisplay)this.getDataList().getWidget(i, 0);
            locInfo.resizeToFit();
        }
        this.refresh();
    }

    private class LocationInfoDisplay
    extends Widget {
        Image m_icon = new Image();
        Label m_nameLabel = new Label();
        Label m_areaLabel = new Label();
        Label m_statusLabel = new Label();

        protected void doAttachChildren() {
            super.doAttachChildren();
            DOM.appendChild((Element)this.getElement(), (Element)this.m_icon.getElement());
            DOM.appendChild((Element)this.getElement(), (Element)this.m_nameLabel.getElement());
            DOM.appendChild((Element)this.getElement(), (Element)this.m_areaLabel.getElement());
            DOM.appendChild((Element)this.getElement(), (Element)this.m_statusLabel.getElement());
        }

        protected void onLoad() {
            this.resizeToFit();
        }

        protected void resizeToFit() {
            int calculatedHeight = this.m_nameLabel.getOffsetHeight() + this.m_statusLabel.getOffsetHeight();
            int newHeight = calculatedHeight > 60 ? calculatedHeight : 60;
            this.setHeight(Integer.toString(newHeight + 2));
        }

        public LocationInfoDisplay(LocationInfo locationInfo) {
            this.setElement(DOM.createDiv());
            this.setStyles();
            this.m_icon.setUrl(locationInfo.getMarkerImageURL());
            this.m_nameLabel.setText(locationInfo.getName());
            this.m_areaLabel.setText(locationInfo.getArea());
            this.m_statusLabel.setText(locationInfo.getStatusDetails().getReason());
        }

        private void setStyles() {
            this.setStyleName(PageableLocationList.this.locationDetailStyle.detailContainerStyle());
            this.m_icon.addStyleName(PageableLocationList.this.locationDetailStyle.iconStyle());
            this.m_nameLabel.addStyleName(PageableLocationList.this.locationDetailStyle.nameStyle());
            this.m_areaLabel.addStyleName(PageableLocationList.this.locationDetailStyle.areaStyle());
            this.m_statusLabel.addStyleName(PageableLocationList.this.locationDetailStyle.statusStyle());
        }
    }
}

