/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import org.opennms.features.poller.remote.gwt.client.events.LocationPanelSelectEvent;
import org.opennms.features.poller.remote.gwt.client.events.LocationPanelSelectEventHandler;

public abstract class PageableList
extends Composite {
    private static PageableListUiBinder uiBinder = (PageableListUiBinder)GWT.create(PageableListUiBinder.class);
    private static final int TOTAL_LOCATIONS = 10;
    @UiField
    FlexTable dataList;
    @UiField
    Panel pagingControls;
    @UiField
    Hyperlink nextBtn;
    @UiField
    Label pageStatsLabel;
    @UiField
    Hyperlink prevBtn;
    @UiField
    LocationDetailStyle locationDetailStyle;
    private volatile boolean m_needsRefresh = true;
    private int m_currentPageIndex = 0;
    private int m_totalPages = 0;

    public PageableList() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    protected void onLoad() {
        super.onLoad();
        new Timer(){

            public void run() {
                if (PageableList.this.isVisible() && PageableList.this.m_needsRefresh) {
                    PageableList.this.m_needsRefresh = false;
                    PageableList.this.updateListDisplay(PageableList.this.getCurrentPageIndex());
                }
            }
        }.scheduleRepeating(500);
    }

    public void refresh() {
        this.m_needsRefresh = true;
    }

    protected void showFirstPage() {
        this.setCurrentPageIndex(0);
        this.refresh();
    }

    protected void updateListDisplay(int currentPageIndex) {
        int startIndex;
        this.getDataList().removeAllRows();
        int rowCount = 0;
        int size = this.getListSize();
        int showableLocations = (currentPageIndex + 1) * this.getTotalListItemsPerPage() > size ? size : (currentPageIndex + 1) * this.getTotalListItemsPerPage();
        for (int i = startIndex = currentPageIndex * this.getTotalListItemsPerPage(); i < showableLocations; ++i) {
            this.getDataList().setWidget(rowCount, 0, this.getListItemWidget(i));
            if (rowCount % 2 == 0) {
                this.getDataList().getRowFormatter().addStyleName(rowCount, this.getAlternateRowStyle());
            }
            ++rowCount;
        }
        if (size > this.getTotalListItemsPerPage()) {
            int totalPages = (int)Math.ceil(size / this.getTotalListItemsPerPage());
            if (totalPages == 0) {
                totalPages = 1;
            }
            this.setTotalPages(totalPages);
        }
        this.updatePageStatsDisplay(startIndex + 1, showableLocations, this.getListSize());
    }

    protected String getAlternateRowStyle() {
        return this.locationDetailStyle.alternateRowStyle();
    }

    protected abstract int getListSize();

    protected abstract Widget getListItemWidget(int var1);

    @UiHandler(value={"dataList"})
    public abstract void onItemClickHandler(ClickEvent var1);

    @UiHandler(value={"prevBtn"})
    public void onPrevBtnClick(ClickEvent event) {
        int newIndex = this.getCurrentPageIndex() - 1;
        this.setCurrentPageIndex(newIndex);
        this.updateListDisplay(newIndex);
    }

    @UiHandler(value={"nextBtn"})
    public void onNextBtnClick(ClickEvent event) {
        int newIndex = this.getCurrentPageIndex() + 1;
        this.setCurrentPageIndex(newIndex);
        this.updateListDisplay(newIndex);
    }

    public void addLocationPanelSelectEventHandler(LocationPanelSelectEventHandler handler) {
        this.addHandler(handler, LocationPanelSelectEvent.TYPE);
    }

    private void setCurrentPageIndex(int currentPageIndex) {
        if (currentPageIndex == 0) {
            this.m_currentPageIndex = currentPageIndex;
        } else if (currentPageIndex > 0 && currentPageIndex <= this.getTotalPages()) {
            this.m_currentPageIndex = currentPageIndex;
        }
    }

    protected int getCurrentPageIndex() {
        return this.m_currentPageIndex;
    }

    private void setTotalPages(int totalPages) {
        this.m_totalPages = totalPages;
    }

    private void updatePageStatsDisplay(int startIndex, int endIndex, int total) {
        if (endIndex > 0) {
            this.pageStatsLabel.setText(startIndex + "-" + endIndex + " of " + total);
        } else {
            this.pageStatsLabel.setText("No matching items");
        }
    }

    private int getTotalPages() {
        return this.m_totalPages;
    }

    protected int getTotalListItemsPerPage() {
        return 10;
    }

    void setDataList(FlexTable dataList) {
        this.dataList = dataList;
    }

    FlexTable getDataList() {
        return this.dataList;
    }

    protected HTMLTable.Cell getCellForEvent(ClickEvent event) {
        return this.getDataList().getCellForEvent(event);
    }

    static interface LocationDetailStyle
    extends CssResource {
        public String detailContainerStyle();

        public String iconStyle();

        public String nameStyle();

        public String areaStyle();

        public String statusStyle();

        public String alternateRowStyle();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface PageableListUiBinder
    extends UiBinder<Widget, PageableList> {
    }
}

