/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.client;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.opennms.features.poller.remote.gwt.client.ApplicationDetails;
import org.opennms.features.poller.remote.gwt.client.ApplicationInfo;
import org.opennms.features.poller.remote.gwt.client.PageableList;
import org.opennms.features.poller.remote.gwt.client.events.ApplicationDetailsRetrievedEvent;
import org.opennms.features.poller.remote.gwt.client.events.ApplicationDetailsRetrievedEventHandler;
import org.opennms.features.poller.remote.gwt.client.events.ApplicationSelectedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageableApplicationList
extends PageableList
implements ApplicationDetailsRetrievedEventHandler {
    private ArrayList<ApplicationInfo> m_applications;
    private HandlerManager m_eventBus;
    private ApplicationDetails m_selected = null;

    public void updateList(ArrayList<ApplicationInfo> applications) {
        this.setApplications(applications);
        if (this.m_selected != null) {
            this.m_eventBus.fireEvent((GwtEvent)new ApplicationSelectedEvent(this.m_selected.getApplicationName()));
        }
        this.refresh();
    }

    @Override
    protected Widget getListItemWidget(int index) {
        return new ApplicationDetailView(this.getApplications().get(index));
    }

    private void setApplications(ArrayList<ApplicationInfo> applications) {
        this.m_applications = applications;
    }

    private ArrayList<ApplicationInfo> getApplications() {
        return this.m_applications;
    }

    @Override
    protected int getListSize() {
        if (this.m_applications == null) {
            return 0;
        }
        return this.m_applications.size();
    }

    @Override
    public void onItemClickHandler(ClickEvent event) {
        HTMLTable.Cell cell = this.getCellForEvent(event);
        ApplicationInfo appInfo = this.getApplications().get(cell.getRowIndex());
        this.m_eventBus.fireEvent((GwtEvent)new ApplicationSelectedEvent(appInfo.getName()));
    }

    public void setEventBus(HandlerManager eventBus) {
        this.m_eventBus = eventBus;
        this.registerHandlers();
    }

    private void registerHandlers() {
        this.m_eventBus.addHandler(ApplicationDetailsRetrievedEvent.TYPE, (EventHandler)this);
        this.addHandler((EventHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                PageableApplicationList.this.refreshApplicationListResize();
            }
        }, ResizeEvent.getType());
    }

    @Override
    public void onApplicationDetailsRetrieved(ApplicationDetailsRetrievedEvent event) {
        this.m_selected = event.getApplicationDetails();
        this.refreshApplicationListResize();
    }

    public void refreshApplicationListResize() {
        for (int i = 0; i < this.getDataList().getRowCount(); ++i) {
            ApplicationDetailView view = (ApplicationDetailView)this.getDataList().getWidget(i, 0);
            view.resizeToFit();
        }
        this.refresh();
    }

    private class ApplicationDetailView
    extends Widget {
        final Image m_icon = new Image();
        final Label m_nameLabel = new Label();
        final HTML m_statusLabel = new HTML();

        protected void doAttachChildren() {
            super.doAttachChildren();
            DOM.appendChild((com.google.gwt.user.client.Element)this.getElement(), (com.google.gwt.user.client.Element)this.m_icon.getElement());
            DOM.appendChild((com.google.gwt.user.client.Element)this.getElement(), (com.google.gwt.user.client.Element)this.m_nameLabel.getElement());
            DOM.appendChild((com.google.gwt.user.client.Element)this.getElement(), (com.google.gwt.user.client.Element)this.m_statusLabel.getElement());
        }

        protected void onLoad() {
            super.onLoad();
            this.resizeToFit();
        }

        private void resizeToFit() {
            int calculatedHeight = this.m_nameLabel.getOffsetHeight() + this.m_statusLabel.getOffsetHeight();
            int newHeight = calculatedHeight > 60 ? calculatedHeight : 60;
            this.setHeight(Integer.toString(newHeight + 2));
        }

        public ApplicationDetailView(ApplicationInfo applicationInfo) {
            this.setElement((Element)Document.get().createDivElement());
            this.setStyles();
            this.m_icon.setUrl(applicationInfo.getMarkerState().getImageURL());
            this.m_nameLabel.setText(applicationInfo.getName());
            this.m_statusLabel.setHTML(this.getApplicationStatusHTML(applicationInfo));
        }

        private String getApplicationStatusHTML(ApplicationInfo applicationInfo) {
            if (PageableApplicationList.this.m_selected != null && PageableApplicationList.this.m_selected.getApplicationName().equals(applicationInfo.getName())) {
                return PageableApplicationList.this.m_selected.getDetailsAsString();
            }
            return applicationInfo.getStatusDetails().getReason();
        }

        private void setStyles() {
            this.setStyleName(PageableApplicationList.this.locationDetailStyle.detailContainerStyle());
            String iconStyle = PageableApplicationList.this.locationDetailStyle.iconStyle();
            this.m_icon.addStyleName(iconStyle);
            this.m_nameLabel.addStyleName(PageableApplicationList.this.locationDetailStyle.nameStyle());
            this.m_statusLabel.addStyleName(PageableApplicationList.this.locationDetailStyle.statusStyle());
        }
    }

    static interface ApplicationDetailStyle
    extends PageableList.LocationDetailStyle {
        public String detailContainerStyle();

        public String iconStyle();

        public String nameStyle();

        public String areaStyle();

        public String statusStyle();

        public String alternateRowStyle();
    }
}

