/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import org.gwtopenmaps.openlayers.client.Bounds;
import org.gwtopenmaps.openlayers.client.Icon;
import org.gwtopenmaps.openlayers.client.LonLat;
import org.gwtopenmaps.openlayers.client.Map;
import org.gwtopenmaps.openlayers.client.MapOptions;
import org.gwtopenmaps.openlayers.client.MapWidget;
import org.gwtopenmaps.openlayers.client.Marker;
import org.gwtopenmaps.openlayers.client.Pixel;
import org.gwtopenmaps.openlayers.client.Size;
import org.gwtopenmaps.openlayers.client.control.Control;
import org.gwtopenmaps.openlayers.client.control.MousePosition;
import org.gwtopenmaps.openlayers.client.control.PanZoomBar;
import org.gwtopenmaps.openlayers.client.event.MapMoveListener;
import org.gwtopenmaps.openlayers.client.event.MapZoomListener;
import org.gwtopenmaps.openlayers.client.event.MarkerBrowserEventListener;
import org.gwtopenmaps.openlayers.client.layer.Layer;
import org.gwtopenmaps.openlayers.client.layer.Markers;
import org.gwtopenmaps.openlayers.client.layer.WMS;
import org.gwtopenmaps.openlayers.client.layer.WMSParams;
import org.gwtopenmaps.openlayers.client.popup.Popup;
import org.opennms.features.poller.remote.gwt.client.GWTBounds;
import org.opennms.features.poller.remote.gwt.client.GWTLatLng;
import org.opennms.features.poller.remote.gwt.client.GWTMarkerState;
import org.opennms.features.poller.remote.gwt.client.MapPanel;
import org.opennms.features.poller.remote.gwt.client.events.GWTMarkerClickedEvent;
import org.opennms.features.poller.remote.gwt.client.events.MapPanelBoundsChangedEvent;
import org.opennms.features.poller.remote.gwt.client.utils.BoundsBuilder;

public class OpenLayersMapPanel
extends Composite
implements MapPanel {
    private static OpenLayersMapPanelUiBinder uiBinder = (OpenLayersMapPanelUiBinder)GWT.create(OpenLayersMapPanelUiBinder.class);
    @UiField
    SimplePanel m_mapHolder;
    private MapWidget m_mapWidget;
    private Map m_map;
    private Markers m_markersLayer;
    private java.util.Map<String, Marker> m_markers = new HashMap<String, Marker>();
    private HandlerManager m_eventBus;

    public OpenLayersMapPanel(HandlerManager eventBus) {
        this.m_eventBus = eventBus;
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.initializeMap();
        this.m_map.addMapMoveListener(new MapMoveListener(){

            public void onMapMove(MapMoveListener.MapMoveEvent eventObject) {
                OpenLayersMapPanel.this.m_eventBus.fireEvent((GwtEvent)new MapPanelBoundsChangedEvent(OpenLayersMapPanel.this.getBounds()));
            }
        });
        this.m_map.addMapZoomListener(new MapZoomListener(){

            public void onMapZoom(MapZoomListener.MapZoomEvent eventObject) {
                OpenLayersMapPanel.this.m_eventBus.fireEvent((GwtEvent)new MapPanelBoundsChangedEvent(OpenLayersMapPanel.this.getBounds()));
            }
        });
    }

    protected void onLoad() {
        super.onLoad();
        this.syncMapSizeWithParent();
    }

    public void initializeMap() {
        MapOptions mo = new MapOptions();
        mo.setProjection("EPSG:4326");
        this.m_mapWidget = new MapWidget("100%", "100%", mo);
        this.m_mapHolder.add((Widget)this.m_mapWidget);
        this.m_map = this.m_mapWidget.getMap();
        this.m_map.addControl((Control)new PanZoomBar());
        this.m_map.addControl((Control)new MousePosition());
        this.m_map.zoomTo(2);
        WMSParams layerParams = new WMSParams();
        layerParams.setLayers("basic");
        WMS wms = new WMS("OpenLayers WMS", "http://labs.metacarta.com/wms/vmap0", layerParams);
        wms.setIsBaseLayer(true);
        this.m_map.addLayer((Layer)wms);
        this.m_markersLayer = new Markers("default");
        this.m_map.addLayer((Layer)this.m_markersLayer);
        this.m_map.zoomToMaxExtent();
        Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                OpenLayersMapPanel.this.syncMapSizeWithParent();
            }
        });
    }

    public void showLocationDetails(String name, String htmlTitle, String htmlContent) {
        Marker marker = this.getMarker(name);
        this.m_map.setCenter(marker.getLonLat());
        if (marker != null) {
            VerticalPanel panel = new VerticalPanel();
            panel.add((Widget)new Label(htmlTitle));
            panel.add((Widget)new HTML(htmlContent));
            Popup p = new Popup(name, marker.getLonLat(), new Size(300, 300), panel.toString(), true);
            p.setAutoSize(true);
            this.m_map.addPopup(p);
        }
    }

    private Marker createMarker(GWTMarkerState marker) {
        LonLat lonLat = OpenLayersMapPanel.toLonLat(marker.getLatLng());
        Icon icon = this.createIcon(marker);
        Marker m = new Marker(lonLat, icon);
        m.addBrowserEventListener("click", (MarkerBrowserEventListener)new DefaultMarkerClickHandler(marker));
        return m;
    }

    private Icon createIcon(GWTMarkerState marker) {
        return new Icon(marker.getImageURL(), new Size(32, 32), new Pixel(-16, -32));
    }

    public GWTBounds getBounds() {
        try {
            return OpenLayersMapPanel.toGWTBounds(this.m_map.getExtent());
        }
        catch (Exception e) {
            return new GWTBounds(-180.0, -90.0, 180.0, 90.0);
        }
    }

    public void setBounds(GWTBounds b) {
        this.m_map.zoomToExtent(OpenLayersMapPanel.toBounds(b));
    }

    private static LonLat toLonLat(GWTLatLng latLng) {
        return new LonLat(latLng.getLongitude().doubleValue(), latLng.getLatitude().doubleValue());
    }

    private static GWTBounds toGWTBounds(Bounds bounds) {
        if (bounds == null) {
            return new GWTBounds(-180.0, -90.0, 180.0, 90.0);
        }
        BoundsBuilder bldr = new BoundsBuilder();
        bldr.extend(bounds.getLowerLeftX(), bounds.getLowerLeftY());
        bldr.extend(bounds.getUpperRightX(), bounds.getUpperRightY());
        return bldr.getBounds();
    }

    private static Bounds toBounds(GWTBounds bounds) {
        GWTLatLng nec = bounds.getNorthEastCorner();
        GWTLatLng swc = bounds.getSouthWestCorner();
        return new Bounds(swc.getLongitude().doubleValue(), swc.getLatitude().doubleValue(), nec.getLongitude().doubleValue(), nec.getLatitude().doubleValue());
    }

    private void syncMapSizeWithParent() {
        this.m_map.updateSize();
    }

    public void placeMarker(GWTMarkerState marker) {
        Marker m = this.getMarker(marker.getName());
        if (m == null) {
            m = this.createMarker(marker);
            this.m_markers.put(marker.getName(), m);
            this.m_markersLayer.addMarker(m);
        } else {
            this.updateMarker(m, marker);
        }
    }

    private void updateMarker(Marker m, GWTMarkerState marker) {
        m.setImageUrl(marker.getImageURL());
    }

    private Marker getMarker(String name) {
        return this.m_markers.get(name);
    }

    public Widget getWidget() {
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface OpenLayersMapPanelUiBinder
    extends UiBinder<Widget, OpenLayersMapPanel> {
    }

    private class DefaultMarkerClickHandler
    implements MarkerBrowserEventListener {
        private GWTMarkerState m_markerState;

        public DefaultMarkerClickHandler(GWTMarkerState markerState) {
            this.setMarkerState(markerState);
        }

        public void setMarkerState(GWTMarkerState markerState) {
            this.m_markerState = markerState;
        }

        public GWTMarkerState getMarkerState() {
            return this.m_markerState;
        }

        public void onBrowserEvent(MarkerBrowserEventListener.MarkerBrowserEvent markerBrowserEvent) {
            OpenLayersMapPanel.this.m_eventBus.fireEvent((GwtEvent)new GWTMarkerClickedEvent(this.getMarkerState()));
        }
    }
}

