/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.googlecode.gwtmapquest.transaction.MQAAbstractShape;
import com.googlecode.gwtmapquest.transaction.MQAControl;
import com.googlecode.gwtmapquest.transaction.MQAIcon;
import com.googlecode.gwtmapquest.transaction.MQALargeZoomControl;
import com.googlecode.gwtmapquest.transaction.MQALatLng;
import com.googlecode.gwtmapquest.transaction.MQAPoi;
import com.googlecode.gwtmapquest.transaction.MQAPoint;
import com.googlecode.gwtmapquest.transaction.MQARectLL;
import com.googlecode.gwtmapquest.transaction.MQATileMap;
import com.googlecode.gwtmapquest.transaction.event.MoveEndEvent;
import com.googlecode.gwtmapquest.transaction.event.MoveEndHandler;
import com.googlecode.gwtmapquest.transaction.event.ZoomEndEvent;
import com.googlecode.gwtmapquest.transaction.event.ZoomEndHandler;
import java.util.HashMap;
import java.util.Map;
import org.opennms.features.poller.remote.gwt.client.GWTBounds;
import org.opennms.features.poller.remote.gwt.client.GWTLatLng;
import org.opennms.features.poller.remote.gwt.client.GWTMarkerState;
import org.opennms.features.poller.remote.gwt.client.MapPanel;
import org.opennms.features.poller.remote.gwt.client.events.GWTMarkerClickedEvent;
import org.opennms.features.poller.remote.gwt.client.events.MapPanelBoundsChangedEvent;
import org.opennms.features.poller.remote.gwt.client.utils.BoundsBuilder;

public class MapQuestMapPanel
extends Composite
implements MapPanel {
    private static MapQuestMapPanelUiBinder uiBinder = (MapQuestMapPanelUiBinder)GWT.create(MapQuestMapPanelUiBinder.class);
    @UiField
    SimplePanel m_mapHolder;
    private MQATileMap m_map;
    private Map<String, MQAPoi> m_markers = new HashMap<String, MQAPoi>();
    private HandlerManager m_eventBus;

    public MapQuestMapPanel(HandlerManager eventBus) {
        this.m_eventBus = eventBus;
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.m_map = MQATileMap.newInstance((Element)this.getMapHolder().getElement());
        this.initializeMap();
        this.m_map.addMoveEndHandler(new MoveEndHandler(){

            public void onMoveEnd(MoveEndEvent event) {
                MapQuestMapPanel.this.m_eventBus.fireEvent((GwtEvent)new MapPanelBoundsChangedEvent(MapQuestMapPanel.this.getBounds()));
            }
        });
        this.m_map.addZoomEndHandler(new ZoomEndHandler(){

            public void onZoomEnd(ZoomEndEvent event) {
                MapQuestMapPanel.this.m_eventBus.fireEvent((GwtEvent)new MapPanelBoundsChangedEvent(MapQuestMapPanel.this.getBounds()));
            }
        });
    }

    protected void onLoad() {
        super.onLoad();
        this.syncMapSizeWithParent();
    }

    public void initializeMap() {
        this.getMapHolder().setSize("100%", "100%");
        this.m_map.addControl((MQAControl)MQALargeZoomControl.newInstance());
        this.m_map.setZoomLevel(1);
        this.m_map.setCenter(MQALatLng.newInstance((String)"0,0"));
        Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                MapQuestMapPanel.this.syncMapSizeWithParent();
            }
        });
    }

    public void showLocationDetails(String name, String htmlTitle, String htmlContent) {
        MQAPoi point = this.getMarker(name);
        if (point != null) {
            MQALatLng latLng = point.getLatLng();
            this.m_map.setCenter(latLng);
            this.m_map.getInfoWindow().hide();
            point.setInfoTitleHTML(htmlTitle);
            point.setInfoContentHTML(htmlContent);
            point.showInfoWindow();
            NodeList elements = Document.get().getElementsByTagName("div");
            for (int i = 0; i < elements.getLength(); ++i) {
                Element e = (Element)elements.getItem(i);
                if (!e.getClassName().equals("mqpoicontenttext")) continue;
                Style s = e.getStyle();
                s.setOverflow(Style.Overflow.HIDDEN);
                break;
            }
        }
    }

    private MQAPoi createMarker(GWTMarkerState marker) {
        MQALatLng latLng = MapQuestMapPanel.toMQALatLng(marker.getLatLng());
        MQAIcon icon = this.createIcon(marker);
        MQAPoi point = MQAPoi.newInstance((MQALatLng)latLng, (MQAIcon)icon);
        point.setIconOffset(MQAPoint.newInstance((int)-16, (int)-32));
        point.addClickHandler((ClickHandler)new DefaultMarkerClickHandler(marker));
        point.setMaxZoomLevel(16);
        point.setMinZoomLevel(1);
        return point;
    }

    private MQAIcon createIcon(GWTMarkerState marker) {
        return MQAIcon.newInstance((String)marker.getImageURL(), (int)32, (int)32);
    }

    public GWTBounds getBounds() {
        return MapQuestMapPanel.toGWTBounds(this.m_map.getBounds());
    }

    public void setBounds(GWTBounds b) {
        this.m_map.zoomToRect(MapQuestMapPanel.toMQARectLL(b));
    }

    private static MQALatLng toMQALatLng(GWTLatLng latLng) {
        return MQALatLng.newInstance((double)latLng.getLatitude(), (double)latLng.getLongitude());
    }

    private static GWTBounds toGWTBounds(MQARectLL bounds) {
        BoundsBuilder bldr = new BoundsBuilder();
        bldr.extend(bounds.getUpperLeft().getLatitude(), bounds.getUpperLeft().getLongitude());
        bldr.extend(bounds.getLowerRight().getLatitude(), bounds.getLowerRight().getLongitude());
        return bldr.getBounds();
    }

    private static MQARectLL toMQARectLL(GWTBounds bounds) {
        MQALatLng ne = MapQuestMapPanel.toMQALatLng(bounds.getNorthEastCorner());
        MQALatLng sw = MapQuestMapPanel.toMQALatLng(bounds.getSouthWestCorner());
        MQARectLL mqBounds = MQARectLL.newInstance((MQALatLng)ne, (MQALatLng)sw);
        return mqBounds;
    }

    private SimplePanel getMapHolder() {
        return this.m_mapHolder;
    }

    private void syncMapSizeWithParent() {
        this.m_map.setSize();
    }

    public void placeMarker(GWTMarkerState marker) {
        MQAPoi m = this.getMarker(marker.getName());
        if (m == null) {
            m = this.createMarker(marker);
            this.m_markers.put(marker.getName(), m);
            this.m_map.addShape((MQAAbstractShape)m);
        } else {
            this.updateMarker(m, marker);
        }
    }

    private void updateMarker(MQAPoi m, GWTMarkerState marker) {
        m.setIcon(this.createIcon(marker));
        m.setVisible(marker.isVisible());
    }

    private MQAPoi getMarker(String name) {
        return this.m_markers.get(name);
    }

    public Widget getWidget() {
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface MapQuestMapPanelUiBinder
    extends UiBinder<Widget, MapQuestMapPanel> {
    }

    private class DefaultMarkerClickHandler
    implements ClickHandler {
        private GWTMarkerState m_markerState;

        public DefaultMarkerClickHandler(GWTMarkerState markerState) {
            this.setMarkerState(markerState);
        }

        public void onClick(ClickEvent event) {
            MapQuestMapPanel.this.m_eventBus.fireEvent((GwtEvent)new GWTMarkerClickedEvent(this.getMarkerState()));
        }

        public void setMarkerState(GWTMarkerState markerState) {
            this.m_markerState = markerState;
        }

        public GWTMarkerState getMarkerState() {
            return this.m_markerState;
        }
    }
}

