/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.opennms.features.poller.remote.gwt.client.ApplicationInfo;
import org.opennms.features.poller.remote.gwt.client.FilterPanel;
import org.opennms.features.poller.remote.gwt.client.PageableApplicationList;
import org.opennms.features.poller.remote.gwt.client.PageableLocationList;
import org.opennms.features.poller.remote.gwt.client.TagPanel;
import org.opennms.features.poller.remote.gwt.client.events.LocationPanelSelectEvent;
import org.opennms.features.poller.remote.gwt.client.events.LocationPanelSelectEventHandler;
import org.opennms.features.poller.remote.gwt.client.location.LocationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationPanel
extends Composite
implements LocationPanelSelectEventHandler,
TagPanel.TagResizeEventHandler,
RequiresResize {
    private static final Binder BINDER = (Binder)GWT.create(Binder.class);
    private transient HandlerManager m_eventBus;
    private transient List<HandlerRegistration> eventRegistrations = new ArrayList<HandlerRegistration>();
    @UiField
    PageableLocationList locationList;
    @UiField
    PageableApplicationList applicationList;
    @UiField
    FilterPanel filterPanel;
    @UiField
    TagPanel tagPanel;
    @UiField
    HTMLPanel filterOptionsPanel;
    @UiField
    FlowPanel listsPanel;

    public LocationPanel() {
        this.initWidget((Widget)BINDER.createAndBindUi(this));
        this.locationList.addLocationPanelSelectEventHandler(this);
        this.updateSelectedApplications(new TreeSet<ApplicationInfo>());
    }

    public void setEventBus(HandlerManager eventBus) {
        for (HandlerRegistration registration : this.eventRegistrations) {
            registration.removeHandler();
        }
        this.m_eventBus = eventBus;
        this.m_eventBus.addHandler(TagPanel.TagResizeEvent.TYPE, (EventHandler)this);
        this.filterPanel.setEventBus(eventBus);
        this.tagPanel.setEventBus(eventBus);
        this.applicationList.setEventBus(eventBus);
    }

    @Override
    public void onLocationSelected(LocationPanelSelectEvent event) {
        this.m_eventBus.fireEvent((GwtEvent)event);
    }

    public void showLocationList() {
        LocationPanel.setVisible((Element)this.locationList.getElement(), (boolean)true);
        LocationPanel.setVisible((Element)this.applicationList.getElement(), (boolean)false);
        this.locationList.refreshLocationListResize();
    }

    public void showApplicationList() {
        LocationPanel.setVisible((Element)this.locationList.getElement(), (boolean)false);
        LocationPanel.setVisible((Element)this.applicationList.getElement(), (boolean)true);
        this.applicationList.refreshApplicationListResize();
    }

    public void updateSelectedApplications(Set<ApplicationInfo> selectedApplications) {
        this.filterPanel.updateSelectedApplications(selectedApplications);
        this.resizeDockPanel();
    }

    public void updateApplicationNames(Set<String> allApplicationNames) {
        this.filterPanel.updateApplicationNames(allApplicationNames);
    }

    public void updateApplicationList(ArrayList<ApplicationInfo> appList) {
        this.applicationList.updateList(appList);
    }

    public void updateLocationList(ArrayList<LocationInfo> visibleLocations) {
        this.locationList.updateList(visibleLocations);
    }

    public void selectTag(String tag) {
        this.tagPanel.selectTag(tag);
    }

    public void clearTagPanel() {
        this.tagPanel.clear();
    }

    public boolean addAllTags(Collection<String> tags) {
        return this.tagPanel.addAll((Collection<? extends String>)tags);
    }

    public void showApplicationFilters(boolean isApplicationView) {
        this.filterPanel.showApplicationFilters(isApplicationView);
    }

    public void resizeDockPanel() {
        int verticalSpacer = 3;
        int newSize = this.tagPanel.getOffsetHeight() + this.filterPanel.getOffsetHeight() + verticalSpacer;
        com.google.gwt.user.client.Element element = this.listsPanel.getElement();
        element.setAttribute("style", "position: absolute; top: " + newSize + "px; left: 0px; right: 0px; bottom: 0px;");
    }

    @Override
    public void onTagPanelResize() {
        this.resizeDockPanel();
    }

    public void onResize() {
        if (this.applicationList.isVisible()) {
            this.applicationList.refreshApplicationListResize();
        } else if (this.locationList.isVisible()) {
            this.locationList.refreshLocationListResize();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Binder
    extends UiBinder<Widget, LocationPanel> {
    }
}

