/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.client;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.opennms.features.poller.remote.gwt.client.GWTLocationMonitor;
import org.opennms.features.poller.remote.gwt.client.GWTLocationSpecificStatus;
import org.opennms.features.poller.remote.gwt.client.GWTMonitoredService;
import org.opennms.features.poller.remote.gwt.client.GWTPollResult;
import org.opennms.features.poller.remote.gwt.client.StatusDetails;
import org.opennms.features.poller.remote.gwt.client.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationMonitorState
implements Serializable,
IsSerializable {
    private static final long serialVersionUID = 1L;
    private Set<GWTLocationMonitor> m_monitorsStarted = new HashSet<GWTLocationMonitor>();
    private Set<GWTLocationMonitor> m_monitorsStopped = new HashSet<GWTLocationMonitor>();
    private Set<GWTLocationMonitor> m_monitorsDisconnected = new HashSet<GWTLocationMonitor>();
    private Collection<GWTLocationSpecificStatus> m_locationStatuses;
    private Set<String> m_serviceNames = new HashSet<String>();
    private StatusDetails m_statusDetails;

    public LocationMonitorState() {
    }

    public LocationMonitorState(Collection<GWTLocationSpecificStatus> statuses) {
        this.initializeStatuses(statuses);
    }

    public LocationMonitorState(Collection<GWTLocationMonitor> monitors, Collection<GWTLocationSpecificStatus> statuses) {
        this.initializeStatuses(statuses);
        this.initializeMonitors(monitors);
    }

    public StatusDetails getStatusDetails() {
        if (this.m_statusDetails == null) {
            this.m_statusDetails = this.getStatusDetailsUncached();
        }
        return this.m_statusDetails;
    }

    private void initializeMonitors(Collection<GWTLocationMonitor> monitors) {
        for (GWTLocationMonitor monitor : monitors) {
            this.handleMonitor(monitor);
        }
    }

    private void initializeStatuses(Collection<GWTLocationSpecificStatus> statuses) {
        if (statuses != null) {
            for (GWTLocationSpecificStatus status : statuses) {
                this.handleMonitor(status.getLocationMonitor());
                this.m_serviceNames.add(status.getMonitoredService().getServiceName());
            }
            this.m_locationStatuses = statuses;
        }
    }

    private void handleMonitor(GWTLocationMonitor monitor) {
        if (this.m_monitorsStarted.contains(monitor) || this.m_monitorsStopped.contains(monitor) || this.m_monitorsDisconnected.contains(monitor)) {
            return;
        }
        String statusText = monitor.getStatus();
        if (statusText.equalsIgnoreCase("CONFIG_CHANGED") || statusText.equalsIgnoreCase("STARTED")) {
            this.m_monitorsStarted.add(monitor);
        } else if (statusText.equalsIgnoreCase("DISCONNECTED")) {
            this.m_monitorsDisconnected.add(monitor);
        } else if (statusText.equalsIgnoreCase("REGISTERED") || statusText.equalsIgnoreCase("PAUSED") || statusText.equalsIgnoreCase("STOPPED")) {
            this.m_monitorsStopped.add(monitor);
        } else {
            throw new RuntimeException("unknown monitor status: " + statusText);
        }
    }

    public boolean allMonitorsStarted() {
        if (this.m_monitorsStarted.size() == 0) {
            return false;
        }
        if (this.m_monitorsStopped.size() > 0) {
            return false;
        }
        return this.m_monitorsDisconnected.size() <= 0;
    }

    public boolean atLeastOneMonitorStarted() {
        return this.m_monitorsStarted.size() > 0;
    }

    public boolean allButOneMonitorsDisconnected() {
        if (this.m_monitorsDisconnected.size() == 0) {
            return false;
        }
        if (this.m_monitorsStarted.size() > 1) {
            return false;
        }
        return this.m_monitorsStarted.size() != 0;
    }

    public boolean allMonitorsDisconnected() {
        if (this.m_monitorsDisconnected.size() == 0) {
            return false;
        }
        if (this.m_monitorsStarted.size() > 0) {
            return false;
        }
        return this.m_monitorsStopped.size() <= 0;
    }

    public boolean noMonitorsStarted() {
        return this.m_monitorsStarted.size() == 0;
    }

    protected int getMonitorsStarted() {
        return this.m_monitorsStarted.size();
    }

    protected int getMonitorsStopped() {
        return this.m_monitorsStopped.size();
    }

    protected int getMonitorsDisconnected() {
        return this.m_monitorsDisconnected.size();
    }

    protected Collection<String> getServiceNames() {
        ArrayList<String> serviceNames = Collections.list(Collections.enumeration(this.m_serviceNames));
        Collections.sort(serviceNames);
        return serviceNames;
    }

    protected Collection<GWTMonitoredService> getServices() {
        TreeSet<GWTMonitoredService> services = new TreeSet<GWTMonitoredService>();
        for (GWTLocationSpecificStatus status : this.m_locationStatuses) {
            services.add(status.getMonitoredService());
        }
        return services;
    }

    protected Collection<String> getServicesDown() {
        HashSet<String> servicesDown = new HashSet<String>();
        for (GWTLocationSpecificStatus status : this.m_locationStatuses) {
            GWTMonitoredService service = status.getMonitoredService();
            GWTPollResult result = status.getPollResult();
            if (!result.isDown()) continue;
            servicesDown.add(service.getServiceName());
        }
        return servicesDown;
    }

    protected Collection<GWTLocationMonitor> getMonitorsWithServicesDown() {
        HashSet<GWTLocationMonitor> monitors = new HashSet<GWTLocationMonitor>();
        for (GWTLocationSpecificStatus status : this.m_locationStatuses) {
            GWTPollResult result = status.getPollResult();
            if (!result.isDown()) continue;
            monitors.add(status.getLocationMonitor());
        }
        return monitors;
    }

    protected StatusDetails getStatusDetailsUncached() {
        if (this.noMonitorsStarted()) {
            return StatusDetails.unknown("No monitors are started for this location.");
        }
        if (this.m_locationStatuses == null || this.m_locationStatuses.size() == 0) {
            return StatusDetails.unknown("No monitors have reported for this location.");
        }
        if (this.allButOneMonitorsDisconnected()) {
            return StatusDetails.marginal("Only 1 monitor is started, the rest are disconnected.");
        }
        HashSet<String> anyDown = new HashSet<String>();
        HashSet<String> services = new HashSet<String>();
        HashSet<String> servicesDown = new HashSet<String>();
        for (String serviceName : this.m_serviceNames) {
            boolean serviceAllDown = true;
            boolean foundService = false;
            for (GWTLocationSpecificStatus status : this.m_locationStatuses) {
                GWTMonitoredService monitoredService = status.getMonitoredService();
                if (!monitoredService.getServiceName().equals(serviceName)) continue;
                foundService = true;
                services.add(serviceName);
                GWTPollResult pollResult = status.getPollResult();
                if (pollResult.getStatus().equalsIgnoreCase("down")) {
                    anyDown.add(serviceName);
                    continue;
                }
                serviceAllDown = false;
            }
            if (!foundService || !serviceAllDown) continue;
            servicesDown.add(serviceName);
        }
        if (servicesDown.size() > 0) {
            if (servicesDown.size() == services.size()) {
                return StatusDetails.down("All services are down on all started monitors.");
            }
            if (servicesDown.size() == 1) {
                return StatusDetails.down((String)servicesDown.iterator().next() + " has been reported down by all monitors.");
            }
            return StatusDetails.down("The following services are reported down by all monitors: " + StringUtils.join(servicesDown, ", ") + ".");
        }
        if (anyDown.size() > 0) {
            return StatusDetails.marginal("The following services are reported down by at least one monitor: " + StringUtils.join(anyDown, ", ") + ".");
        }
        return StatusDetails.up();
    }

    public String toString() {
        return "LocationMonitorState[started=" + this.m_monitorsStarted + ",stopped=" + this.m_monitorsStopped + ",disconnected=" + this.m_monitorsDisconnected + ",statuses=" + this.m_locationStatuses + ",services=" + this.m_serviceNames + "]";
    }
}

