/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.client;

import com.google.gwt.maps.utility.client.DefaultPackage;
import com.google.gwt.maps.utility.client.GoogleMapsUtility;
import com.google.gwt.maps.utility.client.GoogleMapsUtilityPackage;
import com.google.gwt.user.client.IncrementalCommand;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import org.opennms.features.poller.remote.gwt.client.DefaultLocationManager;
import org.opennms.features.poller.remote.gwt.client.InitializationException;
import org.opennms.features.poller.remote.gwt.client.LocationManager;
import org.opennms.features.poller.remote.gwt.client.LocationStatusServiceAsync;

public class InitializationCommand
implements IncrementalCommand {
    private Queue<DataLoader> m_queue = new LinkedList<DataLoader>();
    private DataLoader m_currentLoader;
    private final DefaultLocationManager m_abstractLocationManager;
    private Runnable m_finisher;

    public InitializationCommand(DefaultLocationManager abstractLocationManager, Runnable finisher, DataLoader ... dataLoaders) {
        this.m_abstractLocationManager = abstractLocationManager;
        this.m_finisher = finisher;
        this.initialize(dataLoaders);
    }

    protected void initialize(DataLoader ... dataLoaders) {
        this.m_queue.addAll(Arrays.asList(dataLoaders));
    }

    public LocationManager getLocationManager() {
        return this.m_abstractLocationManager;
    }

    public boolean execute() {
        if (this.m_currentLoader == null || this.m_currentLoader.isLoaded()) {
            this.m_currentLoader = this.m_queue.poll();
            if (this.m_currentLoader == null) {
                this.finished();
                return false;
            }
            this.m_currentLoader.load();
        }
        return true;
    }

    protected void finished() throws InitializationException {
        if (this.m_finisher != null) {
            this.m_finisher.run();
        }
    }

    public LocationStatusServiceAsync getRemoteService() {
        return this.m_abstractLocationManager.getRemoteService();
    }

    public static abstract class DataLoader {
        boolean m_loaded = false;

        public void setLoaded() {
            this.m_loaded = true;
            this.onLoaded();
        }

        public boolean isLoaded() {
            return this.m_loaded;
        }

        public void load() {
            this.setLoaded();
        }

        public void onLoaded() {
        }

        public void loadApi(DefaultPackage api) {
            GoogleMapsUtility.loadUtilityApi((Runnable)new Runnable(){

                public void run() {
                    DataLoader.this.setLoaded();
                }
            }, (GoogleMapsUtilityPackage[])new GoogleMapsUtilityPackage[]{api});
        }
    }
}

