/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.maps.client.InfoWindowContent;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.control.Control;
import com.google.gwt.maps.client.control.LargeMapControl;
import com.google.gwt.maps.client.event.InfoWindowCloseClickHandler;
import com.google.gwt.maps.client.event.MapMoveEndHandler;
import com.google.gwt.maps.client.event.MarkerClickHandler;
import com.google.gwt.maps.client.geom.LatLngBounds;
import com.google.gwt.maps.client.geom.Point;
import com.google.gwt.maps.client.geom.Size;
import com.google.gwt.maps.client.overlay.Icon;
import com.google.gwt.maps.client.overlay.Marker;
import com.google.gwt.maps.client.overlay.MarkerOptions;
import com.google.gwt.maps.client.overlay.Overlay;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.opennms.features.poller.remote.gwt.client.GWTBounds;
import org.opennms.features.poller.remote.gwt.client.GWTMarkerState;
import org.opennms.features.poller.remote.gwt.client.MapPanel;
import org.opennms.features.poller.remote.gwt.client.events.GWTMarkerClickedEvent;
import org.opennms.features.poller.remote.gwt.client.events.MapPanelBoundsChangedEvent;
import org.opennms.features.poller.remote.gwt.client.utils.GoogleMapsUtils;

public class GoogleMapsPanel
extends Composite
implements MapPanel {
    private static GoogleMapsPanelUiBinder uiBinder = (GoogleMapsPanelUiBinder)GWT.create(GoogleMapsPanelUiBinder.class);
    @UiField
    MapWidget m_mapWidget;
    private Map<String, Marker> m_markers = new HashMap<String, Marker>();
    private Map<String, GWTMarkerState> m_markerStates = new HashMap<String, GWTMarkerState>();
    private HandlerManager m_eventBus;

    public GoogleMapsPanel(HandlerManager eventBus) {
        this.m_eventBus = eventBus;
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.initializeMapPanel();
        this.m_mapWidget.addMapMoveEndHandler(new MapMoveEndHandler(){

            public void onMoveEnd(MapMoveEndHandler.MapMoveEndEvent event) {
                GoogleMapsPanel.this.m_eventBus.fireEvent((GwtEvent)new MapPanelBoundsChangedEvent(GoogleMapsPanel.this.getBounds()));
            }
        });
    }

    private MapWidget getMapWidget() {
        return this.m_mapWidget;
    }

    public void showLocationDetails(String name, String htmlTitle, String htmlContent) {
        Marker m = this.m_markers.get(name);
        this.getMapWidget().savePosition();
        this.getMapWidget().setCenter(m.getLatLng());
        if (m != null) {
            VerticalPanel panel = new VerticalPanel();
            panel.add((Widget)new Label(htmlTitle));
            panel.add((Widget)new HTML(htmlContent));
            this.getMapWidget().getInfoWindow().open(m.getLatLng(), new InfoWindowContent(panel.toString()));
            this.getMapWidget().getInfoWindow().addInfoWindowCloseClickHandler(new InfoWindowCloseClickHandler(){

                public void onCloseClick(InfoWindowCloseClickHandler.InfoWindowCloseClickEvent event) {
                    GoogleMapsPanel.this.getMapWidget().returnToSavedPosition();
                }
            });
        }
    }

    public GWTBounds getBounds() {
        return GoogleMapsUtils.toGWTBounds(this.getMapWidget().getBounds());
    }

    public void setBounds(GWTBounds b) {
        LatLngBounds bounds = GoogleMapsUtils.toLatLngBounds(b);
        this.getMapWidget().setCenter(bounds.getCenter(), this.getMapWidget().getBoundsZoomLevel(bounds));
    }

    private void initializeMapPanel() {
        this.getMapWidget().setSize("100%", "100%");
        this.getMapWidget().setUIToDefault();
        this.getMapWidget().addControl((Control)new LargeMapControl());
        this.getMapWidget().setScrollWheelZoomEnabled(true);
        Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent resizeEvent) {
                if (GoogleMapsPanel.this.getMapWidget() != null) {
                    GoogleMapsPanel.this.getMapWidget().checkResizeAndCenter();
                }
            }
        });
    }

    private void addOverlay(Marker newMarker) {
        this.getMapWidget().addOverlay((Overlay)newMarker);
    }

    private Marker createMarker(GWTMarkerState marker) {
        Icon icon = Icon.newInstance();
        icon.setIconSize(Size.newInstance((int)32, (int)32));
        icon.setIconAnchor(Point.newInstance((int)16, (int)32));
        String markerImageURL = marker.getImageURL();
        icon.setImageURL(markerImageURL);
        MarkerOptions markerOptions = MarkerOptions.newInstance();
        markerOptions.setAutoPan(true);
        markerOptions.setClickable(true);
        markerOptions.setTitle(marker.getName());
        markerOptions.setIcon(icon);
        Marker m = new Marker(GoogleMapsUtils.toLatLng(marker.getLatLng()), markerOptions);
        m.setVisible(marker.isVisible());
        m.addMarkerClickHandler((MarkerClickHandler)new DefaultMarkerClickHandler(marker));
        return m;
    }

    public void placeMarker(GWTMarkerState marker) {
        this.m_markerStates.put(marker.getName(), marker);
        Marker m = this.m_markers.get(marker.getName());
        if (m == null) {
            m = this.createMarker(marker);
            this.m_markers.put(marker.getName(), m);
            this.addOverlay(m);
        } else {
            this.updateMarkerFromState(m, marker);
        }
    }

    private void updateMarkerFromState(Marker m, GWTMarkerState marker) {
        m.setImage(marker.getImageURL());
        m.setVisible(marker.isVisible());
    }

    public Widget getWidget() {
        return this;
    }

    private final class DefaultMarkerClickHandler
    implements MarkerClickHandler {
        private final GWTMarkerState m_marker;

        DefaultMarkerClickHandler(GWTMarkerState marker) {
            this.m_marker = marker;
        }

        public void onClick(MarkerClickHandler.MarkerClickEvent mke) {
            GoogleMapsPanel.this.m_eventBus.fireEvent((GwtEvent)new GWTMarkerClickedEvent(this.m_marker));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface GoogleMapsPanelUiBinder
    extends UiBinder<Widget, GoogleMapsPanel> {
    }
}

