/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.client;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.Date;
import org.opennms.features.poller.remote.gwt.client.utils.CompareToBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWTPollResult
implements Serializable,
IsSerializable,
Comparable<GWTPollResult> {
    private static final long serialVersionUID = 1L;
    private String m_status;
    private Date m_timestamp;
    private String m_reason;
    private Double m_responseTime;

    public GWTPollResult() {
    }

    public GWTPollResult(String status, Date timestamp, String reason, Double responseTime) {
        this.m_status = status;
        this.m_timestamp = timestamp;
        this.m_reason = reason;
        this.m_responseTime = responseTime;
    }

    public String getReason() {
        return this.m_reason;
    }

    public void setReason(String reason) {
        this.m_reason = reason;
    }

    public Double getResponseTime() {
        return this.m_responseTime;
    }

    public void setResponseTime(Double responseTime) {
        this.m_responseTime = responseTime;
    }

    public String getStatus() {
        return this.m_status;
    }

    public void setStatus(String status) {
        this.m_status = status;
    }

    public Date getTimestamp() {
        return this.m_timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.m_timestamp = timestamp;
    }

    public boolean isDown() {
        return this.m_status.equalsIgnoreCase("down");
    }

    public static GWTPollResult available(int responseTime) {
        GWTPollResult result = new GWTPollResult();
        result.setResponseTime(Double.valueOf(responseTime));
        result.setStatus("Up");
        result.setTimestamp(new Date());
        return result;
    }

    public static GWTPollResult down(String reason) {
        GWTPollResult result = new GWTPollResult();
        result.setStatus("Down");
        result.setReason(reason);
        result.setTimestamp(new Date());
        return result;
    }

    public String toString() {
        return "GWTPollResult[status=" + this.m_status + ",timestamp=" + this.m_timestamp + ",responseTime=" + this.m_responseTime + ",reason=" + this.m_reason + "]";
    }

    @Override
    public int compareTo(GWTPollResult that) {
        return new CompareToBuilder().append(this.getTimestamp(), that.getTimestamp()).append(this.getStatus(), that.getStatus()).append(this.getResponseTime(), that.getResponseTime()).append(this.getReason(), that.getReason()).toComparison();
    }
}

