/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.client;

import org.opennms.features.poller.remote.gwt.client.GWTLatLng;
import org.opennms.features.poller.remote.gwt.client.utils.HashCodeBuilder;

public class GWTBounds {
    GWTLatLng m_northEastCorner;
    GWTLatLng m_southWestCorner;

    public GWTBounds(GWTLatLng southWestCorner, GWTLatLng northEastCorner) {
        this.m_northEastCorner = northEastCorner;
        this.m_southWestCorner = southWestCorner;
    }

    public GWTBounds(double swLat, double swLng, double neLat, double neLng) {
        this(new GWTLatLng(swLat, swLng), new GWTLatLng(neLat, neLng));
    }

    public boolean contains(GWTLatLng coords) {
        return this.containsLongitude(coords.getLongitude()) && this.containsLatitude(coords.getLatitude());
    }

    private boolean containsLongitude(Double longitude) {
        if (this.m_southWestCorner.getLongitude() <= this.m_northEastCorner.getLongitude()) {
            return this.m_southWestCorner.getLongitude() <= longitude && longitude <= this.m_northEastCorner.getLongitude();
        }
        return !(this.m_northEastCorner.getLongitude() < longitude) || !(longitude < this.m_southWestCorner.getLongitude());
    }

    private boolean containsLatitude(Double latitude) {
        return this.m_southWestCorner.getLatitude() <= latitude && latitude <= this.m_northEastCorner.getLatitude();
    }

    public boolean contains(GWTBounds bounds) {
        return this.contains(bounds.getNorthEastCorner()) && this.contains(bounds.getSouthWestCorner());
    }

    public GWTLatLng getSouthWestCorner() {
        return this.m_southWestCorner;
    }

    public GWTLatLng getNorthEastCorner() {
        return this.m_northEastCorner;
    }

    public boolean equals(Object o) {
        if (o instanceof GWTBounds) {
            GWTBounds b = (GWTBounds)o;
            return this.m_southWestCorner.equals(b.m_southWestCorner) && this.m_northEastCorner.equals(b.m_northEastCorner);
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.m_southWestCorner).append(this.m_northEastCorner).toHashcode();
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("((");
        bldr.append(this.m_southWestCorner.getCoordinates());
        bldr.append("), (");
        bldr.append(this.m_northEastCorner.getCoordinates());
        bldr.append("))");
        return bldr.toString();
    }
}

