/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.ToggleButton;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import org.opennms.features.poller.remote.gwt.client.ApplicationInfo;
import org.opennms.features.poller.remote.gwt.client.GWTMarkerState;
import org.opennms.features.poller.remote.gwt.client.LocationManager;
import org.opennms.features.poller.remote.gwt.client.Status;
import org.opennms.features.poller.remote.gwt.client.events.ApplicationDeselectedEvent;
import org.opennms.features.poller.remote.gwt.client.events.ApplicationSelectedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterPanel
extends Composite {
    private static final Binder BINDER = (Binder)GWT.create(Binder.class);
    private transient HandlerManager m_eventBus;
    private transient LocationManager m_locationManager;
    @UiField
    FilterStyles filterStyles;
    @UiField(provided=true)
    SuggestBox applicationNameSuggestBox;
    @UiField
    Panel applicationTray;
    @UiField
    Label noApplicationsCaption;
    @UiField
    Panel applicationFilters;
    @UiField
    ToggleButton upButton;
    @UiField
    ToggleButton marginalButton;
    @UiField
    ToggleButton downButton;
    @UiField
    ToggleButton unknownButton;
    private final MultiWordSuggestOracle applicationNames = new MultiWordSuggestOracle();

    public FilterPanel() {
        this.applicationNameSuggestBox = new SuggestBox((SuggestOracle)this.applicationNames);
        this.initWidget((Widget)BINDER.createAndBindUi((Object)this));
        this.upButton.setDown(true);
        this.marginalButton.setDown(true);
        this.downButton.setDown(true);
        this.unknownButton.setDown(true);
    }

    @UiHandler(value={"applicationNameSuggestBox"})
    public void onApplicationSelect(SelectionEvent<SuggestOracle.Suggestion> event) {
        SuggestOracle.Suggestion item = (SuggestOracle.Suggestion)event.getSelectedItem();
        ApplicationInfo app = this.m_locationManager.getApplicationInfo(item.getReplacementString());
        this.m_eventBus.fireEvent((GwtEvent)new ApplicationSelectedEvent(app.getName()));
    }

    @UiHandler(value={"upButton"})
    public void onUpButtonClick(ClickEvent event) {
        this.m_eventBus.fireEvent((GwtEvent)new StatusSelectionChangedEvent(Status.UP, this.upButton.isDown()));
    }

    @UiHandler(value={"marginalButton"})
    public void onMarginalButtonClick(ClickEvent event) {
        this.m_eventBus.fireEvent((GwtEvent)new StatusSelectionChangedEvent(Status.MARGINAL, this.marginalButton.isDown()));
    }

    @UiHandler(value={"downButton"})
    public void onDownButtonClick(ClickEvent event) {
        this.m_eventBus.fireEvent((GwtEvent)new StatusSelectionChangedEvent(Status.DOWN, this.downButton.isDown()));
    }

    @UiHandler(value={"unknownButton"})
    public void onUnknownButtonClick(ClickEvent event) {
        this.m_eventBus.fireEvent((GwtEvent)new StatusSelectionChangedEvent(Status.UNKNOWN, this.unknownButton.isDown()));
    }

    public void updateApplicationNames(Collection<String> names) {
        this.applicationNames.clear();
        this.applicationNames.addAll(names);
    }

    public void updateSelectedApplications(Collection<ApplicationInfo> apps) {
        this.applicationFilters.clear();
        if (apps.size() > 0) {
            this.noApplicationsCaption.setVisible(false);
            for (ApplicationInfo app : apps) {
                this.applicationFilters.add((Widget)new ApplicationFilter(app));
            }
        } else {
            this.noApplicationsCaption.setVisible(true);
        }
    }

    public void showApplicationFilters(boolean showMe) {
        this.applicationTray.setVisible(showMe);
    }

    public void setEventBus(HandlerManager eventBus) {
        this.m_eventBus = eventBus;
    }

    public void setLocationManager(LocationManager manager) {
        this.m_locationManager = manager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StatusSelectionChangedEvent
    extends GwtEvent<StatusSelectionChangedEventHandler> {
        public static GwtEvent.Type<StatusSelectionChangedEventHandler> TYPE = new GwtEvent.Type();
        private final Status m_status;
        private final boolean m_selected;

        public StatusSelectionChangedEvent(Status status, boolean selected) {
            this.m_status = status;
            this.m_selected = selected;
        }

        protected void dispatch(StatusSelectionChangedEventHandler handler) {
            handler.onStatusSelectionChanged(this.m_status, this.m_selected);
        }

        public GwtEvent.Type<StatusSelectionChangedEventHandler> getAssociatedType() {
            return TYPE;
        }
    }

    public static interface StatusSelectionChangedEventHandler
    extends EventHandler {
        public void onStatusSelectionChanged(Status var1, boolean var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FiltersChangedEvent
    extends GwtEvent<FiltersChangedEventHandler> {
        public static GwtEvent.Type<FiltersChangedEventHandler> TYPE = new GwtEvent.Type();
        private final Filters m_filters;

        public FiltersChangedEvent(Filters filters) {
            this.m_filters = filters;
        }

        protected void dispatch(FiltersChangedEventHandler handler) {
            handler.onFiltersChanged(this.m_filters);
        }

        public GwtEvent.Type<FiltersChangedEventHandler> getAssociatedType() {
            return TYPE;
        }
    }

    public static class Filters {
    }

    public static interface FiltersChangedEventHandler
    extends EventHandler {
        public void onFiltersChanged(Filters var1);
    }

    private class ApplicationFilter
    extends HorizontalPanel {
        public ApplicationFilter(final ApplicationInfo app) {
            Image appIcon = new Image(new GWTMarkerState("filter", null, app.getStatusDetails().getStatus()).getImageURL());
            appIcon.addStyleName(FilterPanel.this.filterStyles.panelIcon());
            super.add((Widget)appIcon);
            Label appName = new Label(app.getName());
            appName.addStyleName(FilterPanel.this.filterStyles.panelCaption());
            super.add((Widget)appName);
            Anchor removeLink = new Anchor("remove");
            removeLink.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    FilterPanel.this.m_eventBus.fireEvent((GwtEvent)new ApplicationDeselectedEvent(app));
                }
            });
            super.add((Widget)removeLink);
            super.addStyleName(FilterPanel.this.filterStyles.panelEntry());
        }
    }

    static interface FilterStyles
    extends CssResource {
        public String panelCaption();

        public String panelEntry();

        public String panelIcon();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Binder
    extends UiBinder<Widget, FilterPanel> {
    }
}

