/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.IncrementalCommand;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SplitLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.opennms.features.poller.remote.gwt.client.ApplicationDetails;
import org.opennms.features.poller.remote.gwt.client.ApplicationInfo;
import org.opennms.features.poller.remote.gwt.client.EventServiceInitializer;
import org.opennms.features.poller.remote.gwt.client.FilterPanel;
import org.opennms.features.poller.remote.gwt.client.GWTBounds;
import org.opennms.features.poller.remote.gwt.client.GWTMarkerState;
import org.opennms.features.poller.remote.gwt.client.InitializationCommand;
import org.opennms.features.poller.remote.gwt.client.LocationManager;
import org.opennms.features.poller.remote.gwt.client.LocationMonitorState;
import org.opennms.features.poller.remote.gwt.client.LocationPanel;
import org.opennms.features.poller.remote.gwt.client.LocationStatusService;
import org.opennms.features.poller.remote.gwt.client.LocationStatusServiceAsync;
import org.opennms.features.poller.remote.gwt.client.MapPanel;
import org.opennms.features.poller.remote.gwt.client.RemotePollerPresenter;
import org.opennms.features.poller.remote.gwt.client.SmartMapFit;
import org.opennms.features.poller.remote.gwt.client.Status;
import org.opennms.features.poller.remote.gwt.client.TagPanel;
import org.opennms.features.poller.remote.gwt.client.events.ApplicationDeselectedEvent;
import org.opennms.features.poller.remote.gwt.client.events.ApplicationDetailsRetrievedEvent;
import org.opennms.features.poller.remote.gwt.client.events.ApplicationSelectedEvent;
import org.opennms.features.poller.remote.gwt.client.events.GWTMarkerClickedEvent;
import org.opennms.features.poller.remote.gwt.client.events.LocationManagerInitializationCompleteEvent;
import org.opennms.features.poller.remote.gwt.client.events.LocationManagerInitializationCompleteEventHander;
import org.opennms.features.poller.remote.gwt.client.events.LocationPanelSelectEvent;
import org.opennms.features.poller.remote.gwt.client.events.LocationsUpdatedEvent;
import org.opennms.features.poller.remote.gwt.client.events.MapPanelBoundsChangedEvent;
import org.opennms.features.poller.remote.gwt.client.location.LocationDetails;
import org.opennms.features.poller.remote.gwt.client.location.LocationInfo;
import org.opennms.features.poller.remote.gwt.client.utils.BoundsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLocationManager
implements LocationManager,
RemotePollerPresenter {
    protected final HandlerManager m_eventBus;
    private final HandlerManager m_handlerManager = new HandlerManager((Object)this);
    private final LocationStatusServiceAsync m_remoteService = (LocationStatusServiceAsync)GWT.create(LocationStatusService.class);
    private final Map<String, LocationInfo> m_locations = new HashMap<String, LocationInfo>();
    private final Map<String, ApplicationInfo> m_applications = new HashMap<String, ApplicationInfo>();
    private String m_selectedTag = null;
    private final Set<Status> m_selectedStatuses = new HashSet<Status>();
    private final MapPanel m_mapPanel;
    private LocationPanel m_locationPanel;
    private final SplitLayoutPanel m_panel;
    private boolean m_updated = false;
    private boolean m_locationViewActive = true;
    private Set<ApplicationInfo> m_selectedApplications = new HashSet<ApplicationInfo>();

    public DefaultLocationManager(HandlerManager eventBus, SplitLayoutPanel panel, LocationPanel locationPanel, MapPanel mapPanel) {
        this.m_eventBus = eventBus;
        this.m_panel = panel;
        this.m_locationPanel = locationPanel;
        this.m_mapPanel = mapPanel;
        this.m_eventBus.addHandler(LocationPanelSelectEvent.TYPE, (EventHandler)this);
        this.m_eventBus.addHandler(LocationsUpdatedEvent.TYPE, (EventHandler)this);
        this.m_eventBus.addHandler(MapPanelBoundsChangedEvent.TYPE, (EventHandler)this);
        this.m_eventBus.addHandler(FilterPanel.FiltersChangedEvent.TYPE, (EventHandler)this);
        this.m_eventBus.addHandler(TagPanel.TagSelectedEvent.TYPE, (EventHandler)this);
        this.m_eventBus.addHandler(TagPanel.TagClearedEvent.TYPE, (EventHandler)this);
        this.m_eventBus.addHandler(FilterPanel.StatusSelectionChangedEvent.TYPE, (EventHandler)this);
        this.m_eventBus.addHandler(ApplicationDeselectedEvent.TYPE, (EventHandler)this);
        this.m_eventBus.addHandler(ApplicationSelectedEvent.TYPE, (EventHandler)this);
        this.m_eventBus.addHandler(GWTMarkerClickedEvent.TYPE, (EventHandler)this);
        for (Status s : Status.values()) {
            this.m_selectedStatuses.add(s);
        }
    }

    @Override
    public void initialize() {
        DeferredCommand.addCommand((IncrementalCommand)new InitializationCommand(this, this.createFinisher(), this.createDataLoaders()));
    }

    private Runnable createFinisher() {
        return new Runnable(){

            public void run() {
                DefaultLocationManager.this.initializationComplete();
            }
        };
    }

    protected InitializationCommand.DataLoader[] createDataLoaders() {
        return new InitializationCommand.DataLoader[]{new InitializationCommand.DataLoader(){

            public void onLoaded() {
                DefaultLocationManager.this.getPanel().add(DefaultLocationManager.this.m_mapPanel.getWidget());
            }
        }, new EventServiceInitializer(this)};
    }

    protected void initializationComplete() {
        this.m_handlerManager.fireEvent((GwtEvent)new LocationManagerInitializationCompleteEvent());
    }

    protected LocationStatusServiceAsync getRemoteService() {
        return this.m_remoteService;
    }

    @Override
    public void addLocationManagerInitializationCompleteEventHandler(LocationManagerInitializationCompleteEventHander handler) {
        this.m_handlerManager.addHandler(LocationManagerInitializationCompleteEvent.TYPE, (EventHandler)handler);
    }

    protected void displayDialog(String title, String contents) {
        DialogBox db = new DialogBox();
        db.setAutoHideEnabled(true);
        db.setModal(true);
        db.setText(title);
        db.setWidget((Widget)new Label(contents, true));
        db.show();
    }

    protected SplitLayoutPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public Set<String> getAllLocationNames() {
        return new TreeSet<String>(this.m_locations.keySet());
    }

    protected GWTBounds getLocationBounds() {
        BoundsBuilder bldr = new BoundsBuilder();
        for (LocationInfo l : this.m_locations.values()) {
            bldr.extend(l.getLatLng());
        }
        return bldr.getBounds();
    }

    @Override
    public void createOrUpdateLocation(LocationInfo locationInfo) {
        if (locationInfo.getMarkerState() == null) {
            locationInfo.setMarkerState(this.getMarkerForLocation(locationInfo));
        }
        this.m_locations.put(locationInfo.getName(), locationInfo);
        this.m_locationPanel.updateApplicationNames(this.getAllApplicationNames());
    }

    @Override
    public void createOrUpdateApplication(ApplicationInfo applicationInfo) {
        if (applicationInfo.getLocations().size() == 0) {
            applicationInfo.setPriority(Long.MAX_VALUE);
        } else {
            applicationInfo.setPriority(0L);
            for (String location : applicationInfo.getLocations()) {
                LocationInfo locationInfo = this.m_locations.get(location);
                if (locationInfo == null) continue;
                applicationInfo.setPriority(applicationInfo.getPriority() + locationInfo.getPriority());
            }
        }
        this.m_applications.put(applicationInfo.getName(), applicationInfo);
        this.m_locationPanel.updateApplicationNames(this.getAllApplicationNames());
    }

    @Override
    public void reportError(String errorMessage, Throwable throwable) {
    }

    @Override
    public void fitMapToLocations() {
        if (this.m_mapPanel instanceof SmartMapFit) {
            ((SmartMapFit)((Object)this.m_mapPanel)).fitToBounds();
        } else {
            this.m_mapPanel.setBounds(this.getLocationBounds());
        }
    }

    public ArrayList<LocationInfo> getVisibleLocations() {
        ArrayList<LocationInfo> visibleLocations = new ArrayList<LocationInfo>();
        for (LocationInfo location : this.m_locations.values()) {
            GWTMarkerState markerState = location.getMarkerState();
            GWTBounds mapBounds = this.m_mapPanel.getBounds();
            if (!markerState.isSelected() || !markerState.isWithinBounds(mapBounds) || !markerState.isVisible()) continue;
            visibleLocations.add(location);
        }
        Collections.sort(visibleLocations, new Comparator<LocationInfo>(){

            @Override
            public int compare(LocationInfo o1, LocationInfo o2) {
                return o1.compareTo(o2);
            }
        });
        return visibleLocations;
    }

    private void updateAllMarkerStates() {
        for (LocationInfo location : this.m_locations.values()) {
            GWTMarkerState markerState = location.getMarkerState();
            boolean visible = this.m_selectedStatuses.contains(location.getStatusDetails().getStatus());
            markerState.setVisible(visible);
            boolean selected = false;
            if (this.m_locationViewActive || this.m_selectedApplications.size() == 0) {
                selected = true;
            } else {
                for (ApplicationInfo app : this.m_selectedApplications) {
                    if (!app.getLocations().contains(location.getName())) continue;
                    selected = true;
                    break;
                }
            }
            if (selected && this.m_selectedTag != null) {
                selected = location.getTags() != null && location.getTags().contains(this.m_selectedTag);
            }
            markerState.setSelected(selected);
            this.m_mapPanel.placeMarker(markerState);
        }
    }

    public List<String> getAllTags() {
        ArrayList<String> retval = new ArrayList<String>();
        for (LocationInfo location : this.m_locations.values()) {
            retval.addAll(location.getTags());
        }
        return retval;
    }

    @Override
    public List<String> getTagsOnVisibleLocations() {
        ArrayList<String> retval = new ArrayList<String>();
        for (LocationInfo location : this.getVisibleLocations()) {
            retval.addAll(location.getTags());
        }
        return retval;
    }

    @Override
    public void onLocationSelected(LocationPanelSelectEvent event) {
        this.showLocationDetails(event.getLocationName());
    }

    private void showLocationDetails(final String locationName) {
        final LocationInfo loc = this.m_locations.get(locationName);
        this.m_remoteService.getLocationDetails(locationName, new AsyncCallback<LocationDetails>(){

            public void onFailure(Throwable t) {
                DefaultLocationManager.this.m_mapPanel.showLocationDetails(locationName, "Error Getting Location Details", "<p>An error occurred getting the location details.</p><pre>" + URL.encode((String)t.getMessage()) + "</pre>");
            }

            public void onSuccess(LocationDetails locationDetails) {
                DefaultLocationManager.this.m_mapPanel.showLocationDetails(locationName, locationName + " (" + loc.getArea() + ")", DefaultLocationManager.getLocationInfoDetails(loc, locationDetails));
            }
        });
    }

    @Override
    public void onBoundsChanged(MapPanelBoundsChangedEvent e) {
        this.updateAllMarkerStates();
        this.m_locationPanel.clearTagPanel();
        this.m_locationPanel.addAllTags(this.getAllTags());
        this.m_locationPanel.selectTag(this.m_selectedTag);
        this.m_locationPanel.updateLocationList((ArrayList<LocationInfo>)this.getVisibleLocations());
    }

    @Override
    public void onLocationsUpdated(LocationsUpdatedEvent e) {
        this.updateAllMarkerStates();
        this.m_locationPanel.clearTagPanel();
        this.m_locationPanel.addAllTags(this.getAllTags());
        this.m_locationPanel.selectTag(this.m_selectedTag);
        this.m_locationPanel.updateApplicationNames(this.getAllApplicationNames());
        this.m_locationPanel.updateLocationList((ArrayList<LocationInfo>)this.getVisibleLocations());
    }

    @Override
    public void updateLocation(LocationInfo info) {
        if (info == null) {
            return;
        }
        this.createOrUpdateLocation(info);
        GWTMarkerState m = this.getMarkerForLocation(info);
        this.m_mapPanel.placeMarker(m);
        if (!this.m_updated) {
            return;
        }
        this.updateAllMarkerStates();
        this.m_locationPanel.updateLocationList((ArrayList<LocationInfo>)this.getVisibleLocations());
    }

    @Override
    public void updateApplication(ApplicationInfo applicationInfo) {
        if (applicationInfo == null) {
            return;
        }
        this.createOrUpdateApplication(applicationInfo);
        this.updateApplicationList();
        if (!this.m_updated) {
            return;
        }
        this.updateAllMarkerStates();
        for (String locationName : applicationInfo.getLocations()) {
            GWTMarkerState m = this.getMarkerForLocation(locationName);
            if (m == null) continue;
            this.m_mapPanel.placeMarker(m);
        }
    }

    private void updateApplicationList() {
        ArrayList<ApplicationInfo> applicationList = new ArrayList<ApplicationInfo>();
        applicationList.addAll(this.m_applications.values());
        Collections.sort(applicationList);
        this.m_locationPanel.updateApplicationList(applicationList);
    }

    @Override
    public void removeApplication(String applicationName) {
        ApplicationInfo info = this.m_applications.get(applicationName);
        if (info != null) {
            this.m_selectedApplications.remove(info);
            this.m_applications.remove(applicationName);
            this.updateApplicationList();
        }
    }

    @Override
    public void updateComplete() {
        if (!this.m_updated) {
            this.updateAllMarkerStates();
            this.fitMapToLocations();
            this.m_updated = true;
        }
    }

    @Override
    public void onFiltersChanged(FilterPanel.Filters filters) {
    }

    @Override
    public void onTagSelected(String tagName) {
        this.m_selectedTag = tagName;
        this.updateAllMarkerStates();
        this.m_locationPanel.updateLocationList((ArrayList<LocationInfo>)this.getVisibleLocations());
    }

    @Override
    public void onTagCleared() {
        this.m_selectedTag = null;
        this.updateAllMarkerStates();
        this.m_locationPanel.updateLocationList((ArrayList<LocationInfo>)this.getVisibleLocations());
    }

    @Override
    public Set<String> getAllApplicationNames() {
        return new TreeSet<String>(this.m_applications.keySet());
    }

    @Override
    public ApplicationInfo getApplicationInfo(String name) {
        if (name == null) {
            return null;
        }
        return this.m_applications.get(name);
    }

    @Override
    public LocationInfo getLocation(String locationName) {
        return this.m_locations.get(locationName);
    }

    @Override
    public void onGWTMarkerClicked(GWTMarkerClickedEvent event) {
        GWTMarkerState markerState = event.getMarkerState();
        this.showLocationDetails(markerState.getName());
    }

    @Override
    public void onStatusSelectionChanged(Status status, boolean selected) {
        if (selected) {
            this.m_selectedStatuses.add(status);
        } else {
            this.m_selectedStatuses.remove(status);
        }
        this.updateAllMarkerStates();
        this.m_locationPanel.updateLocationList((ArrayList<LocationInfo>)this.getVisibleLocations());
    }

    private GWTMarkerState getMarkerForLocation(String locationName) {
        LocationInfo location = this.m_locations.get(locationName);
        if (location != null) {
            return this.getMarkerForLocation(location);
        }
        return null;
    }

    private GWTMarkerState getMarkerForLocation(LocationInfo location) {
        boolean statusIsVisible;
        if (location == null) {
            return null;
        }
        GWTMarkerState state = location.getMarkerState();
        if (state == null) {
            state = new GWTMarkerState(location.getName(), location.getLatLng(), location.getStatusDetails().getStatus());
            location.setMarkerState(state);
        }
        state.setVisible((statusIsVisible = this.m_selectedStatuses.contains(location.getStatusDetails().getStatus())) && location.isVisible(this.m_mapPanel.getBounds()));
        return state;
    }

    @Override
    public void onApplicationSelected(ApplicationSelectedEvent event) {
        String applicationName = event.getApplicationname();
        ApplicationInfo app = this.m_applications.get(applicationName);
        this.m_selectedApplications.add(app);
        this.updateAllMarkerStates();
        this.m_locationPanel.updateSelectedApplications(this.m_selectedApplications);
        this.m_remoteService.getApplicationDetails(applicationName, new AsyncCallback<ApplicationDetails>(){

            public void onFailure(Throwable t) {
            }

            public void onSuccess(ApplicationDetails applicationDetails) {
                DefaultLocationManager.this.m_eventBus.fireEvent((GwtEvent)new ApplicationDetailsRetrievedEvent(applicationDetails));
            }
        });
    }

    @Override
    public void onApplicationDeselected(ApplicationDeselectedEvent event) {
        this.m_selectedApplications.remove(event.getAppInfo());
        this.updateAllMarkerStates();
        this.m_locationPanel.updateSelectedApplications(this.m_selectedApplications);
    }

    @Override
    public void locationClicked() {
        this.m_locationViewActive = true;
        this.updateAllMarkerStates();
    }

    @Override
    public void applicationClicked() {
        this.m_locationViewActive = false;
        this.updateAllMarkerStates();
    }

    public static String getLocationInfoDetails(LocationInfo locationInfo, LocationDetails locationDetails) {
        LocationMonitorState state = locationDetails.getLocationMonitorState();
        int pollersStarted = state.getMonitorsStarted();
        int pollersStopped = state.getMonitorsStopped();
        int pollersDisconnected = state.getMonitorsDisconnected();
        int services = state.getServices().size();
        int servicesWithOutages = state.getServicesDown().size();
        int monitorsWithOutages = state.getMonitorsWithServicesDown().size();
        StringBuilder sb = new StringBuilder();
        sb.append("<div id=\"locationStatus\">");
        sb.append("<dl class=\"statusContents\">\n");
        sb.append("<dt class=\"").append(state.getStatusDetails().getStatus().getStyle()).append(" statusDt\">").append("Monitors:").append("</dt>\n");
        sb.append("<dd class=\"").append(state.getStatusDetails().getStatus().getStyle()).append(" statusDd\">");
        sb.append(pollersStarted + " started").append("<br>\n");
        sb.append(pollersStopped + " stopped").append("<br>\n");
        sb.append(pollersDisconnected + " disconnected").append("\n");
        sb.append("</dd>\n");
        if (pollersStarted > 0) {
            String styleName = Status.UP.getStyle();
            if (servicesWithOutages > 0) {
                styleName = monitorsWithOutages == pollersStarted ? Status.DOWN.getStyle() : Status.MARGINAL.getStyle();
            }
            sb.append("<dt class=\"").append(styleName).append(" statusDt\">").append("Services:").append("</dt>\n");
            sb.append("<dd class=\"").append(styleName).append(" statusDd\">");
            sb.append(servicesWithOutages).append(" outage").append(servicesWithOutages == 1 ? "" : "s");
            sb.append(" (of ").append(services).append(" service").append(services == 1 ? "" : "s").append(")").append("<br>\n");
            sb.append(monitorsWithOutages).append(" poller").append(monitorsWithOutages == 1 ? "" : "s").append(" reporting errors").append("\n");
            sb.append("</dd>\n");
        }
        sb.append("</div>");
        return sb.toString();
    }
}

