/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.client;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.features.poller.remote.gwt.client.ApplicationDetails;
import org.opennms.features.poller.remote.gwt.client.ApplicationInfo;
import org.opennms.features.poller.remote.gwt.client.GWTLocationMonitor;
import org.opennms.features.poller.remote.gwt.client.GWTLocationSpecificStatus;
import org.opennms.features.poller.remote.gwt.client.StatusDetails;
import org.opennms.features.poller.remote.gwt.client.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationState
implements Serializable,
IsSerializable {
    private static final long serialVersionUID = 1L;
    private Map<String, ApplicationDetails> m_statuses = new HashMap<String, ApplicationDetails>();
    private StatusDetails m_statusDetails;

    public ApplicationState() {
    }

    public ApplicationState(Date from, Date to, Collection<ApplicationInfo> applications, List<GWTLocationMonitor> monitors, Map<String, List<GWTLocationSpecificStatus>> statuses) {
        for (ApplicationInfo app : applications) {
            this.m_statuses.put(app.getName(), new ApplicationDetails(app, from, to, monitors, statuses.get(app.getName())));
        }
    }

    public StatusDetails getStatusDetails() {
        if (this.m_statusDetails == null) {
            this.m_statusDetails = this.getStatusDetailsUncached();
        }
        return this.m_statusDetails;
    }

    private StatusDetails getStatusDetailsUncached() {
        if (this.m_statuses.size() == 0) {
            return StatusDetails.unknown("No applications are currently defined.");
        }
        ArrayList<String> m_applicationsUnknown = new ArrayList<String>();
        ArrayList<String> m_applicationsDown = new ArrayList<String>();
        ArrayList<String> m_applicationsMarginal = new ArrayList<String>();
        for (String appName : this.m_statuses.keySet()) {
            ApplicationDetails status = this.m_statuses.get(appName);
            switch (status.getStatusDetails().getStatus()) {
                case UNKNOWN: {
                    m_applicationsUnknown.add(appName);
                    break;
                }
                case DOWN: {
                    m_applicationsDown.add(appName);
                    break;
                }
                case MARGINAL: {
                    m_applicationsMarginal.add(appName);
                }
            }
        }
        if (m_applicationsUnknown.size() > 0) {
            return StatusDetails.unknown("The following applications are reporting an unknown status: " + StringUtils.join(m_applicationsUnknown, ", "));
        }
        if (m_applicationsDown.size() > 0) {
            return StatusDetails.down("The following applications are reported as down: " + StringUtils.join(m_applicationsDown, ", "));
        }
        if (m_applicationsMarginal.size() > 0) {
            return StatusDetails.marginal("The following applications are reported as marginal: " + StringUtils.join(m_applicationsMarginal, ", "));
        }
        return StatusDetails.up();
    }
}

