/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.client;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.opennms.features.poller.remote.gwt.client.ApplicationInfo;
import org.opennms.features.poller.remote.gwt.client.GWTLocationMonitor;
import org.opennms.features.poller.remote.gwt.client.GWTLocationSpecificStatus;
import org.opennms.features.poller.remote.gwt.client.GWTMonitoredService;
import org.opennms.features.poller.remote.gwt.client.GWTServiceOutage;
import org.opennms.features.poller.remote.gwt.client.LocationSpecificStatusComparator;
import org.opennms.features.poller.remote.gwt.client.Status;
import org.opennms.features.poller.remote.gwt.client.StatusDetails;
import org.opennms.features.poller.remote.gwt.client.utils.CompareToBuilder;
import org.opennms.features.poller.remote.gwt.client.utils.Interval;
import org.opennms.features.poller.remote.gwt.client.utils.IntervalUtils;
import org.opennms.features.poller.remote.gwt.client.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationDetails
implements Serializable,
IsSerializable {
    private static final long serialVersionUID = 1L;
    private String m_name;
    private ApplicationInfo m_application;
    private Map<Integer, GWTLocationMonitor> m_monitors = new HashMap<Integer, GWTLocationMonitor>();
    private Map<Integer, GWTMonitoredService> m_services = new HashMap<Integer, GWTMonitoredService>();
    private List<GWTLocationSpecificStatus> m_locationSpecificStatuses;
    private Date m_statusFrom;
    private Date m_statusTo;
    private StatusDetails m_statusDetails;
    private Map<Integer, Map<Integer, List<GWTServiceOutage>>> m_outages;

    public ApplicationDetails() {
        this.m_name = null;
        this.m_locationSpecificStatuses = null;
        this.m_statusFrom = null;
        this.m_statusTo = null;
    }

    public ApplicationDetails(ApplicationInfo application, Date from, Date to, Collection<GWTLocationMonitor> monitors, List<GWTLocationSpecificStatus> statuses) {
        this.m_name = application.getName();
        this.m_application = application;
        this.m_statusFrom = from;
        this.m_statusTo = to;
        if (monitors != null) {
            for (GWTLocationMonitor monitor : monitors) {
                this.m_monitors.put(monitor.getId(), monitor);
            }
        }
        this.m_locationSpecificStatuses = statuses;
        if (this.m_locationSpecificStatuses != null) {
            Collections.sort(this.m_locationSpecificStatuses, new LocationSpecificStatusComparator());
            for (GWTLocationSpecificStatus status : this.m_locationSpecificStatuses) {
                GWTMonitoredService monitoredService = status.getMonitoredService();
                this.m_services.put(monitoredService.getId(), monitoredService);
            }
        }
    }

    private Map<Integer, Map<Integer, List<GWTServiceOutage>>> getOutages() {
        if (this.m_outages == null) {
            this.m_outages = this.getOutagesUncached();
        }
        return this.m_outages;
    }

    private Map<Integer, Map<Integer, List<GWTServiceOutage>>> getOutagesUncached() {
        HashMap<Integer, Map<Integer, List<GWTServiceOutage>>> outages = new HashMap<Integer, Map<Integer, List<GWTServiceOutage>>>();
        if (this.m_locationSpecificStatuses == null) {
            return outages;
        }
        for (GWTLocationSpecificStatus status : this.m_locationSpecificStatuses) {
            ArrayList monitorOutages;
            Integer serviceId = status.getMonitoredService().getId();
            Integer monitorId = status.getLocationMonitor().getId();
            GWTServiceOutage lastOutage = null;
            HashMap serviceOutages = (HashMap)outages.get(serviceId);
            if (serviceOutages != null && (monitorOutages = (ArrayList)serviceOutages.get(monitorId)) != null && monitorOutages.size() > 0) {
                lastOutage = (GWTServiceOutage)monitorOutages.get(monitorOutages.size() - 1);
            }
            if (lastOutage != null && lastOutage.getTo() == null) {
                if (status.getPollResult().isDown()) continue;
                lastOutage.setTo(status.getPollResult().getTimestamp());
                continue;
            }
            if (!status.getPollResult().isDown()) continue;
            lastOutage = new GWTServiceOutage();
            lastOutage.setService(status.getMonitoredService());
            lastOutage.setMonitor(status.getLocationMonitor());
            lastOutage.setFrom(status.getPollResult().getTimestamp());
            if (serviceOutages == null) {
                serviceOutages = new HashMap();
                outages.put(serviceId, serviceOutages);
            }
            if ((monitorOutages = (List)serviceOutages.get(monitorId)) == null) {
                monitorOutages = new ArrayList();
                serviceOutages.put(monitorId, monitorOutages);
            }
            ((List)serviceOutages.get(monitorId)).add(lastOutage);
        }
        for (Integer serviceId : outages.keySet()) {
            for (Integer monitorId : ((Map)outages.get(serviceId)).keySet()) {
                for (GWTServiceOutage outage : (List)((Map)outages.get(serviceId)).get(monitorId)) {
                    if (outage.getFrom() == null) {
                        outage.setFrom(this.m_statusFrom);
                    }
                    if (outage.getTo() != null) continue;
                    outage.setTo(this.m_statusTo);
                }
            }
        }
        return outages;
    }

    private Collection<GWTMonitoredService> getAllServices() {
        HashSet<GWTMonitoredService> services = new HashSet<GWTMonitoredService>();
        if (this.m_locationSpecificStatuses != null) {
            for (GWTLocationSpecificStatus status : this.m_locationSpecificStatuses) {
                services.add(status.getMonitoredService());
            }
        }
        return services;
    }

    public StatusDetails getStatusDetails() {
        if (this.m_statusDetails == null) {
            this.m_statusDetails = this.getStatusDetailsUncached();
        }
        return this.m_statusDetails;
    }

    private StatusDetails getStatusDetailsUncached() {
        TreeSet<String> names;
        if (this.m_locationSpecificStatuses == null || this.m_locationSpecificStatuses.size() == 0) {
            return StatusDetails.unknown("No locations have reported status updates.");
        }
        if (this.m_monitors == null || this.m_monitors.size() == 0) {
            return StatusDetails.unknown("No location monitors are currently reporting.");
        }
        HashSet<Integer> monitorIds = new HashSet<Integer>();
        HashSet<GWTMonitoredService> servicesWithOutages = new HashSet<GWTMonitoredService>();
        HashSet<GWTMonitoredService> servicesDown = new HashSet<GWTMonitoredService>();
        boolean foundActiveMonitor = false;
        for (GWTLocationMonitor monitor : this.m_monitors.values()) {
            if (!monitor.getStatus().equals("STARTED")) continue;
            foundActiveMonitor = true;
            monitorIds.add(monitor.getId());
        }
        if (!foundActiveMonitor) {
            return StatusDetails.unknown("No location monitors are currently reporting.");
        }
        Map<Integer, Map<Integer, List<GWTServiceOutage>>> outages = this.getOutages();
        for (Integer serviceId : outages.keySet()) {
            ArrayList<GWTServiceOutage> locationOutages = new ArrayList<GWTServiceOutage>();
            for (Integer monitorId : outages.get(serviceId).keySet()) {
                for (GWTServiceOutage outage : outages.get(serviceId).get(monitorId)) {
                    locationOutages.add(outage);
                }
                locationOutages.addAll((Collection)outages.get(serviceId).get(monitorId));
            }
            GWTMonitoredService service = null;
            if (locationOutages.size() <= 0) {
                return StatusDetails.unknown("No locations reporting for service ID " + serviceId);
            }
            service = ((GWTServiceOutage)locationOutages.iterator().next()).getService();
            HashSet<GWTLocationMonitor> monitorsFailing = new HashSet<GWTLocationMonitor>();
            HashSet<GWTLocationMonitor> monitorsPassing = new HashSet<GWTLocationMonitor>(this.m_monitors.values());
            Collections.sort(locationOutages);
            for (GWTServiceOutage outage : locationOutages) {
                GWTLocationMonitor monitor = outage.getMonitor();
                if (outage.getTo().compareTo(this.m_statusTo) >= 0) {
                    monitorsFailing.add(monitor);
                    monitorsPassing.remove(monitor);
                    continue;
                }
                monitorsPassing.add(monitor);
                monitorsFailing.remove(monitor);
            }
            if (monitorsFailing.size() <= 0) continue;
            if (monitorsPassing.size() == 0) {
                servicesDown.add(service);
                continue;
            }
            servicesWithOutages.add(service);
        }
        outages = null;
        HashSet<String> allServiceNames = new HashSet<String>();
        HashMap<String, Integer> unmonitoredServiceCounts = new HashMap<String, Integer>();
        for (GWTMonitoredService service : this.m_application.getServices()) {
            String serviceName = service.getServiceName();
            allServiceNames.add(serviceName);
            if (!unmonitoredServiceCounts.containsKey(serviceName)) {
                unmonitoredServiceCounts.put(serviceName, 0);
            }
            unmonitoredServiceCounts.put(serviceName, (Integer)unmonitoredServiceCounts.get(serviceName) + 1);
        }
        HashSet unmonitoredServiceNames = new HashSet(allServiceNames);
        for (GWTMonitoredService service : this.getAllServices()) {
            String serviceName = service.getServiceName();
            unmonitoredServiceNames.remove(serviceName);
            if (!unmonitoredServiceCounts.containsKey(serviceName)) continue;
            int count = (Integer)unmonitoredServiceCounts.get(serviceName) - 1;
            unmonitoredServiceCounts.put(serviceName, count);
            if (count != 0) continue;
            unmonitoredServiceCounts.remove(serviceName);
        }
        if (unmonitoredServiceCounts.size() > 0) {
            names = new TreeSet<String>();
            for (String key : unmonitoredServiceCounts.keySet()) {
                Integer count = (Integer)unmonitoredServiceCounts.get(key);
                names.add(count > 1 ? key + " (" + count + ")" : key);
            }
            return StatusDetails.unknown("The following services were not being reported on by any monitor: " + StringUtils.join(names, ", "));
        }
        if (servicesDown.size() > 0) {
            names = new TreeSet();
            for (GWTMonitoredService service : servicesDown) {
                names.add(service.getServiceName());
            }
            return StatusDetails.down("The following services were reported as down by all monitors: " + StringUtils.join(names, ","));
        }
        if (servicesWithOutages.size() == this.m_application.getServices().size()) {
            names = new TreeSet();
            for (GWTMonitoredService service : servicesWithOutages) {
                names.add(service.getServiceName());
            }
            return StatusDetails.marginal("The following services were reported to have outages in this application: " + StringUtils.join(names, ", "));
        }
        return StatusDetails.up();
    }

    public Double getAvailability(GWTMonitoredService service) {
        Set<Interval> serviceOutages = this.getServiceOutageIntervals(service.getId());
        return this.computeAvailabilityForOutageIntervals(serviceOutages);
    }

    public Double getAvailability() {
        if (this.m_statusFrom == null || this.m_locationSpecificStatuses == null) {
            return null;
        }
        Map<Integer, Map<Integer, List<GWTServiceOutage>>> outages = this.getOutages();
        Set<Interval> serviceOutageIntervals = IntervalUtils.getIntervalSet();
        for (Integer serviceId : outages.keySet()) {
            serviceOutageIntervals.addAll(this.getServiceOutageIntervals(serviceId));
        }
        return this.computeAvailabilityForOutageIntervals(IntervalUtils.normalize(serviceOutageIntervals));
    }

    private Double computeAvailabilityForOutageIntervals(Set<Interval> intervals) {
        Long timeAvailable = 0L;
        Set<Interval> upIntervals = IntervalUtils.invert(this.m_statusFrom, this.m_statusTo, intervals);
        for (Interval i : upIntervals) {
            timeAvailable = timeAvailable + (i.getEndMillis() - i.getStartMillis());
        }
        Long totalTime = this.m_statusTo.getTime() - this.m_statusFrom.getTime();
        double availability = timeAvailable.doubleValue() / totalTime.doubleValue() * 100.0;
        return availability;
    }

    private Set<Interval> getServiceOutageIntervals(Integer serviceId) {
        Map<Integer, Map<Integer, List<GWTServiceOutage>>> outages = this.getOutages();
        Set<Interval> serviceUpIntervals = IntervalUtils.getIntervalSet();
        Map<Integer, List<GWTServiceOutage>> serviceOutages = outages.get(serviceId);
        if (serviceOutages != null && serviceOutages.size() != 0) {
            for (GWTLocationMonitor monitor : this.m_monitors.values()) {
                Integer locationId = monitor.getId();
                Set<Interval> locationIntervals = IntervalUtils.getIntervalSet();
                if (serviceOutages.containsKey(locationId)) {
                    for (GWTServiceOutage outage : serviceOutages.get(locationId)) {
                        locationIntervals.add(new Interval(outage.getFrom().getTime(), outage.getTo().getTime()));
                    }
                }
                locationIntervals = IntervalUtils.invert(this.m_statusFrom, this.m_statusTo, IntervalUtils.normalize(locationIntervals));
                serviceUpIntervals.addAll(locationIntervals);
            }
            return IntervalUtils.invert(this.m_statusFrom, this.m_statusTo, IntervalUtils.normalize(serviceUpIntervals));
        }
        return IntervalUtils.getIntervalSet();
    }

    public String toString() {
        return "ApplicationDetails[name=" + this.m_name + ",range=" + this.m_statusFrom + "-" + this.m_statusTo + ",statuses=" + this.m_locationSpecificStatuses + "]";
    }

    public String getApplicationName() {
        return this.m_name;
    }

    public String getDetailsAsString() {
        Map<Integer, Map<Integer, List<GWTServiceOutage>>> outages = this.getOutages();
        StringBuilder sb = new StringBuilder();
        sb.append("<div id=\"applicationDetails\">\n");
        sb.append("<dl class=\"statusContents\">\n");
        TreeSet<GWTMonitoredService> services = new TreeSet<GWTMonitoredService>(new Comparator<GWTMonitoredService>(){

            @Override
            public int compare(GWTMonitoredService a, GWTMonitoredService b) {
                if (a == null) {
                    if (b == null) {
                        return 0;
                    }
                    return 1;
                }
                if (b == null) {
                    return -1;
                }
                return new CompareToBuilder().append(a.getServiceName(), b.getServiceName()).append(a.getId(), b.getId()).toComparison();
            }
        });
        services.addAll(this.m_services.values());
        for (GWTMonitoredService service : services) {
            Integer serviceId = service.getId();
            double serviceAvailability = this.getAvailability(service);
            String styleName = Status.UNKNOWN.getStyle();
            ArrayList<GWTLocationMonitor> locationsNotReporting = new ArrayList<GWTLocationMonitor>();
            if (serviceAvailability == 100.0) {
                styleName = Status.UP.getStyle();
                Map<Integer, List<GWTServiceOutage>> serviceOutages = outages.get(serviceId);
                if (serviceOutages != null) {
                    for (Integer locationId : serviceOutages.keySet()) {
                        List<GWTServiceOutage> locationOutages = serviceOutages.get(locationId);
                        if (locationOutages == null) continue;
                        for (GWTServiceOutage outage : locationOutages) {
                            if (!outage.getTo().equals(this.m_statusTo) && !outage.getTo().after(this.m_statusTo)) continue;
                            locationsNotReporting.add(this.m_monitors.get(locationId));
                            styleName = Status.MARGINAL.getStyle();
                        }
                    }
                }
            } else {
                ArrayList<Interval> serviceOutageIntervals = new ArrayList<Interval>(this.getServiceOutageIntervals(serviceId));
                int size = serviceOutageIntervals.size();
                if (size > 0) {
                    styleName = ((Interval)serviceOutageIntervals.get(size - 1)).getEndMillis() == this.m_statusTo.getTime() ? Status.DOWN.getStyle() : Status.MARGINAL.getStyle();
                }
                styleName = Status.DOWN.getStyle();
            }
            ArrayList<GWTLocationMonitor> monitors = new ArrayList<GWTLocationMonitor>(this.m_monitors.values());
            Collections.sort(monitors);
            sb.append("<dt class=\"").append(styleName).append(" statusDt\">").append(this.getSummary(service)).append("</dt>\n");
            sb.append("<dd class=\"").append(styleName).append(" statusDd\">");
            sb.append("Availability: ").append(Double.valueOf(serviceAvailability).intValue()).append("%");
            if (locationsNotReporting.size() > 0) {
                ArrayList<String> locationString = new ArrayList<String>();
                for (GWTLocationMonitor monitor : locationsNotReporting) {
                    locationString.add(monitor.getName());
                }
                sb.append("<br>\n").append("Location");
                if (locationsNotReporting.size() > 1) {
                    sb.append("s");
                }
                sb.append(" with outages: ").append(StringUtils.join(locationString));
            }
            sb.append("</dd>\n");
        }
        sb.append("</div>\n");
        return sb.toString();
    }

    private String getSummary(GWTMonitoredService service) {
        StringBuilder sb = new StringBuilder();
        sb.append(service.getServiceName()).append(" (node ").append(service.getNodeId()).append(")");
        if (service.getHostname() != null) {
            sb.append("<br>\n").append(service.getHostname());
            if (service.getIpAddress() != null && !service.getIpAddress().equals(service.getHostname())) {
                sb.append("/").append(service.getIpAddress());
            }
        }
        return sb.toString();
    }

    public Date getStart() {
        return this.m_statusFrom;
    }

    public Date getEnd() {
        return this.m_statusTo;
    }
}

