/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SplitLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import org.opennms.features.poller.remote.gwt.client.DefaultLocationManager;
import org.opennms.features.poller.remote.gwt.client.GoogleMapsPanel;
import org.opennms.features.poller.remote.gwt.client.LocationManager;
import org.opennms.features.poller.remote.gwt.client.LocationPanel;
import org.opennms.features.poller.remote.gwt.client.MapPanel;
import org.opennms.features.poller.remote.gwt.client.MapQuestMapPanel;
import org.opennms.features.poller.remote.gwt.client.OpenLayersMapPanel;
import org.opennms.features.poller.remote.gwt.client.events.LocationManagerInitializationCompleteEvent;
import org.opennms.features.poller.remote.gwt.client.events.LocationManagerInitializationCompleteEventHander;

public class Application
implements EntryPoint {
    private static final Binder BINDER = (Binder)GWT.create(Binder.class);
    private LocationManager m_locationManager;
    private final HandlerManager m_eventBus = new HandlerManager(null);
    @UiField
    protected LocationPanel locationPanel;
    @UiField
    protected DockLayoutPanel mainPanel;
    @UiField
    protected SplitLayoutPanel splitPanel;
    @UiField
    protected Hyperlink locationLink;
    @UiField
    protected Hyperlink applicationLink;
    @UiField
    protected LinkStyles linkStyles;

    public void onModuleLoad() {
        BINDER.createAndBindUi(this);
        Window.setTitle((String)"OpenNMS - Remote Monitor");
        Window.enableScrolling((boolean)false);
        Window.setMargin((String)"0px");
        Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                Application.this.mainPanel.setHeight(Application.this.getAppHeight().toString());
            }
        });
        this.m_locationManager = new DefaultLocationManager(this.m_eventBus, this.splitPanel, this.locationPanel, this.createMapPanel());
        this.m_locationManager.addLocationManagerInitializationCompleteEventHandler(new LocationManagerInitializationCompleteEventHander(){

            public void onInitializationComplete(LocationManagerInitializationCompleteEvent event) {
                Application.this.splitPanel.setWidgetMinSize((Widget)Application.this.locationPanel, 255);
                Application.this.mainPanel.setSize("100%", "100%");
                RootPanel.get((String)"remotePollerMap").add((Widget)Application.this.mainPanel);
                Application.this.mainPanel.setSize("100%", Application.this.getAppHeight().toString());
                Application.this.mainPanel.forceLayout();
                Application.this.onLocationClick(null);
            }
        });
        this.locationPanel.setEventBus(this.m_eventBus);
        this.locationPanel.filterPanel.setLocationManager(this.m_locationManager);
        this.m_locationManager.initialize();
    }

    private Integer getAppHeight() {
        Element e = this.mainPanel.getElement();
        int extraHeight = e.getAbsoluteTop();
        return Window.getClientHeight() - extraHeight;
    }

    @UiHandler(value={"locationLink"})
    public void onLocationClick(ClickEvent event) {
        if (!this.locationLink.getStyleName().contains(this.linkStyles.activeLink())) {
            this.m_locationManager.locationClicked();
            this.locationLink.addStyleName(this.linkStyles.activeLink());
            this.applicationLink.removeStyleName(this.linkStyles.activeLink());
            this.locationPanel.showLocationList();
            this.locationPanel.showApplicationFilters(false);
            this.locationPanel.resizeDockPanel();
        }
    }

    @UiHandler(value={"applicationLink"})
    public void onApplicationClick(ClickEvent event) {
        if (!this.applicationLink.getStyleName().contains(this.linkStyles.activeLink())) {
            this.m_locationManager.applicationClicked();
            this.applicationLink.addStyleName(this.linkStyles.activeLink());
            this.locationLink.removeStyleName(this.linkStyles.activeLink());
            this.locationPanel.showApplicationList();
            this.locationPanel.showApplicationFilters(true);
            this.locationPanel.resizeDockPanel();
        }
    }

    private MapPanel createMapPanel() {
        Composite mapPanel;
        if (this.getMapImplementationType().equals("Mapquest")) {
            mapPanel = new MapQuestMapPanel(this.m_eventBus);
        } else if (this.getMapImplementationType().equals("GoogleMaps")) {
            mapPanel = new GoogleMapsPanel(this.m_eventBus);
        } else if (this.getMapImplementationType().equals("OpenLayers")) {
            mapPanel = new OpenLayersMapPanel(this.m_eventBus);
        } else {
            Window.alert((String)("unknown map implementation: " + this.getMapImplementationType()));
            throw new RuntimeException("unknown map implementation: " + this.getMapImplementationType());
        }
        return mapPanel;
    }

    public native String getMapImplementationType();

    static interface LinkStyles
    extends CssResource {
        public String activeLink();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Binder
    extends UiBinder<DockLayoutPanel, Application> {
    }
}

