/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.tools;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.asteriskjava.live.DefaultAsteriskServer;
import org.asteriskjava.manager.ManagerEventListener;
import org.asteriskjava.manager.event.AbstractParkedCallEvent;
import org.asteriskjava.manager.event.BridgeEvent;
import org.asteriskjava.manager.event.DialEvent;
import org.asteriskjava.manager.event.HangupEvent;
import org.asteriskjava.manager.event.HoldEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.NewChannelEvent;
import org.asteriskjava.manager.event.NewExtenEvent;
import org.asteriskjava.manager.event.NewStateEvent;
import org.asteriskjava.manager.event.RenameEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlEventTracer
implements ManagerEventListener {
    private String filename = "trace.html";
    private PrintWriter writer;
    private final List<String> uniqueIds = new ArrayList<String>();
    private final List<ManagerEvent> events = new ArrayList<ManagerEvent>();
    private final Map<Class<? extends ManagerEvent>, String> colors = new HashMap<Class<? extends ManagerEvent>, String>();

    public HtmlEventTracer() {
        this.colors.put(NewChannelEvent.class, "#7cd300");
        this.colors.put(NewStateEvent.class, "#a4b6c8");
        this.colors.put(NewExtenEvent.class, "#efefef");
        this.colors.put(RenameEvent.class, "#ddeeff");
        this.colors.put(DialEvent.class, "#feec30");
        this.colors.put(BridgeEvent.class, "#fff8ae");
        this.colors.put(HangupEvent.class, "#ff6c17");
        try {
            this.writer = new PrintWriter(this.filename);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.err.println("Usage: java org.asteriskjava.tools.HtmlEventTracer host username password");
            System.exit(1);
        }
        final HtmlEventTracer tracer = new HtmlEventTracer();
        final DefaultAsteriskServer server = new DefaultAsteriskServer(args[0], args[1], args[2]);
        server.initialize();
        server.getManagerConnection().addEventListener(tracer);
        System.err.println("Event tracer successfully started. Press Ctrl-C to write trace file and exit.");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                tracer.write();
                server.shutdown();
            }
        });
        while (true) {
            Thread.sleep(1000L);
        }
    }

    @Override
    public void onManagerEvent(ManagerEvent event) {
        this.events.add(event);
        System.out.println("> " + event);
        for (String property : new String[]{"uniqueId", "uniqueId1", "uniqueId2", "srcUniqueId", "destUniqueId"}) {
            String uniqueId = this.getProperty(event, property);
            if (uniqueId == null || this.uniqueIds.contains(uniqueId)) continue;
            this.uniqueIds.add(uniqueId);
        }
    }

    public void write() {
        this.writer.append("<table border='1'><tr><td> </td>");
        for (String uniqueId : this.uniqueIds) {
            this.writer.append("<td><font size='-2'>");
            this.writer.append(uniqueId.substring(0, uniqueId.lastIndexOf(46) + 1));
            this.writer.append("</font>");
            this.writer.append(uniqueId.substring(uniqueId.lastIndexOf(46) + 1, uniqueId.length()));
            this.writer.append("</td>");
        }
        this.writer.append("</tr>");
        this.writer.println("");
        for (ManagerEvent event : this.events) {
            boolean print = false;
            StringBuilder line = new StringBuilder();
            line.append("<tr><td>");
            line.append(this.getLocalName(event.getClass()));
            line.append("<br><font size='-2'>");
            line.append(event.getDateReceived());
            line.append("</font></td>");
            for (String uniqueId : this.uniqueIds) {
                String text = this.getText(uniqueId, event);
                if (text == null) {
                    line.append("<td> </td>");
                    continue;
                }
                String color = this.getColor(event.getClass());
                line.append("<td bgcolor='").append(color).append("'><tt>").append(text).append("</tt></td>");
                print = true;
            }
            line.append("</tr>");
            if (!print) continue;
            this.writer.println(line.toString());
        }
        this.writer.append("</table>");
        this.writer.close();
        System.err.println("Trace file successfully written to " + this.filename + ".");
    }

    private String getColor(Class<? extends ManagerEvent> clazz) {
        for (Map.Entry<Class<? extends ManagerEvent>, String> entry : this.colors.entrySet()) {
            if (!entry.getKey().isAssignableFrom(clazz)) continue;
            return entry.getValue();
        }
        return "#ffffff";
    }

    protected String getProperty(Object obj, String property) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                if (!propertyDescriptor.getName().equals(property)) continue;
                return propertyDescriptor.getReadMethod().invoke(obj, new Object[0]).toString();
            }
        }
        catch (Exception e) {
            System.err.println("Unable to read property '" + property + "' from object " + obj + ": " + e.getMessage());
            return null;
        }
        return null;
    }

    protected String getLocalName(Class c) {
        String s = c.getName();
        return s.substring(s.lastIndexOf(".") + 1, s.length());
    }

    protected String getText(String uniqueId, ManagerEvent event) {
        String format = null;
        String[] properties = null;
        if (uniqueId.equals(this.getProperty(event, "uniqueId"))) {
            if (event instanceof NewChannelEvent) {
                format = "%s<br>%s";
                properties = new String[]{"channel", "state"};
            } else if (event instanceof NewStateEvent) {
                format = "%s";
                properties = new String[]{"state"};
            } else if (event instanceof NewExtenEvent) {
                format = "%s,%s,%s<br>%s(%s)";
                properties = new String[]{"context", "extension", "priority", "application", "appData"};
            } else if (event instanceof RenameEvent) {
                format = "old: %s<br>new: %s";
                properties = new String[]{"oldname", "newname"};
            } else if (event instanceof HoldEvent) {
                format = "%s";
                properties = new String[]{"status"};
            } else if (event instanceof AbstractParkedCallEvent) {
                format = "exten: %s<br>from: %s";
                properties = new String[]{"exten", "from"};
            } else if (event instanceof HangupEvent) {
                format = "%s<br>%s (%s)";
                properties = new String[]{"channel", "cause", "causeTxt"};
            }
        }
        if (event instanceof BridgeEvent) {
            if (uniqueId.equals(this.getProperty(event, "uniqueId1"))) {
                format = "%s<br>%s<br>%s";
                properties = new String[]{"uniqueId2", "channel2", "bridgeState"};
            } else if (uniqueId.equals(this.getProperty(event, "uniqueId2"))) {
                format = "%s<br>%s<br>%s";
                properties = new String[]{"uniqueId1", "channel1", "bridgeState"};
            }
        }
        if (event instanceof DialEvent) {
            if (uniqueId.equals(this.getProperty(event, "srcUniqueId"))) {
                format = "To: %s";
                properties = new String[]{"destination"};
            } else if (uniqueId.equals(this.getProperty(event, "destUniqueId"))) {
                format = "From: %s";
                properties = new String[]{"src"};
            }
        }
        if (format != null) {
            String[] args = new String[properties.length];
            for (int i = 0; i < properties.length; ++i) {
                String value = this.getProperty(event, properties[i]);
                if (value == null) {
                    args[i] = "";
                    continue;
                }
                value = value.replace("<", "&lt;");
                args[i] = value = value.replace(">", "&gt;");
            }
            return String.format(format, args);
        }
        return null;
    }
}

