/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.asteriskjava.AsteriskVersion;
import org.asteriskjava.manager.AuthenticationFailedException;
import org.asteriskjava.manager.EventTimeoutException;
import org.asteriskjava.manager.ExpectedResponse;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerConnectionState;
import org.asteriskjava.manager.ManagerEventListener;
import org.asteriskjava.manager.ResponseEvents;
import org.asteriskjava.manager.SendActionCallback;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.manager.action.ChallengeAction;
import org.asteriskjava.manager.action.CommandAction;
import org.asteriskjava.manager.action.EventGeneratingAction;
import org.asteriskjava.manager.action.LoginAction;
import org.asteriskjava.manager.action.LogoffAction;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.action.UserEventAction;
import org.asteriskjava.manager.event.ConnectEvent;
import org.asteriskjava.manager.event.DisconnectEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.ProtocolIdentifierReceivedEvent;
import org.asteriskjava.manager.event.ResponseEvent;
import org.asteriskjava.manager.internal.Dispatcher;
import org.asteriskjava.manager.internal.ManagerReader;
import org.asteriskjava.manager.internal.ManagerReaderImpl;
import org.asteriskjava.manager.internal.ManagerUtil;
import org.asteriskjava.manager.internal.ManagerWriter;
import org.asteriskjava.manager.internal.ManagerWriterImpl;
import org.asteriskjava.manager.internal.ResponseEventsImpl;
import org.asteriskjava.manager.response.ChallengeResponse;
import org.asteriskjava.manager.response.CommandResponse;
import org.asteriskjava.manager.response.ManagerError;
import org.asteriskjava.manager.response.ManagerResponse;
import org.asteriskjava.util.DateUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.SocketConnectionFacade;
import org.asteriskjava.util.internal.SocketConnectionFacadeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagerConnectionImpl
implements ManagerConnection,
Dispatcher {
    private static final int RECONNECTION_INTERVAL_1 = 50;
    private static final int RECONNECTION_INTERVAL_2 = 5000;
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final int DEFAULT_PORT = 5038;
    private static final int RECONNECTION_VERSION_INTERVAL = 500;
    private static final int MAX_VERSION_ATTEMPTS = 4;
    private static final AtomicLong idCounter = new AtomicLong(0L);
    private final Log logger = LogFactory.getLog(this.getClass());
    private final long id;
    private AtomicLong actionIdCounter = new AtomicLong(0L);
    private String hostname = "localhost";
    private int port = 5038;
    private boolean ssl = false;
    protected String username;
    protected String password;
    private long defaultResponseTimeout = 2000L;
    private long defaultEventTimeout = 5000L;
    private int socketTimeout = 0;
    private int socketReadTimeout = 0;
    private boolean keepAliveAfterAuthenticationFailure = true;
    private SocketConnectionFacade socket;
    private Thread readerThread;
    private final AtomicLong readerThreadCounter = new AtomicLong(0L);
    private final AtomicLong reconnectThreadCounter = new AtomicLong(0L);
    private ManagerReader reader;
    private ManagerWriter writer;
    private final ProtocolIdentifierWrapper protocolIdentifier;
    private AsteriskVersion version;
    private final Map<String, SendActionCallback> responseListeners;
    private final Map<String, ManagerEventListener> responseEventListeners;
    private final List<ManagerEventListener> eventListeners;
    protected ManagerConnectionState state = ManagerConnectionState.INITIAL;
    private String eventMask;

    public ManagerConnectionImpl() {
        this.id = idCounter.getAndIncrement();
        this.responseListeners = new HashMap<String, SendActionCallback>();
        this.responseEventListeners = new HashMap<String, ManagerEventListener>();
        this.eventListeners = new ArrayList<ManagerEventListener>();
        this.protocolIdentifier = new ProtocolIdentifierWrapper();
    }

    protected ManagerReader createReader(Dispatcher dispatcher, Object source) {
        return new ManagerReaderImpl(dispatcher, source);
    }

    protected ManagerWriter createWriter() {
        return new ManagerWriterImpl();
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port <= 0 ? 5038 : port;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDefaultResponseTimeout(long defaultResponseTimeout) {
        this.defaultResponseTimeout = defaultResponseTimeout;
    }

    public void setDefaultEventTimeout(long defaultEventTimeout) {
        this.defaultEventTimeout = defaultEventTimeout;
    }

    public void setKeepAliveAfterAuthenticationFailure(boolean keepAliveAfterAuthenticationFailure) {
        this.keepAliveAfterAuthenticationFailure = keepAliveAfterAuthenticationFailure;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public AsteriskVersion getVersion() {
        return this.version;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean isSsl() {
        return this.ssl;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.socket.getRemoteAddress();
    }

    @Override
    public int getRemotePort() {
        return this.socket.getRemotePort();
    }

    @Override
    public void registerUserEventClass(Class<? extends ManagerEvent> userEventClass) {
        if (this.reader == null) {
            this.reader = this.createReader(this, this);
        }
        this.reader.registerEventClass(userEventClass);
    }

    @Override
    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    @Override
    public void setSocketReadTimeout(int socketReadTimeout) {
        this.socketReadTimeout = socketReadTimeout;
    }

    @Override
    public synchronized void login() throws IOException, AuthenticationFailedException, TimeoutException {
        this.login(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void login(String eventMask) throws IOException, AuthenticationFailedException, TimeoutException {
        if (this.state != ManagerConnectionState.INITIAL && this.state != ManagerConnectionState.DISCONNECTED) {
            throw new IllegalStateException("Login may only be perfomed when in state INITIAL or DISCONNECTED, but connection is in state " + (Object)((Object)this.state));
        }
        this.state = ManagerConnectionState.CONNECTING;
        this.eventMask = eventMask;
        try {
            this.doLogin(this.defaultResponseTimeout, eventMask);
        }
        finally {
            if (this.state != ManagerConnectionState.CONNECTED) {
                this.state = ManagerConnectionState.DISCONNECTED;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doLogin(long timeout, String eventMask) throws IOException, AuthenticationFailedException, TimeoutException {
        ManagerResponse loginResponse;
        String key;
        ManagerResponse challengeResponse;
        if (this.socket == null) {
            this.connect();
        }
        ProtocolIdentifierWrapper protocolIdentifierWrapper = this.protocolIdentifier;
        synchronized (protocolIdentifierWrapper) {
            if (this.protocolIdentifier.value == null) {
                try {
                    this.protocolIdentifier.wait(timeout);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.protocolIdentifier.value == null) {
                this.disconnect();
                if (this.reader != null && this.reader.getTerminationException() != null) {
                    throw this.reader.getTerminationException();
                }
                throw new TimeoutException("Timeout waiting for protocol identifier");
            }
        }
        ChallengeAction challengeAction = new ChallengeAction("MD5");
        try {
            challengeResponse = this.sendAction(challengeAction);
        }
        catch (Exception e) {
            this.disconnect();
            throw new AuthenticationFailedException("Unable to send challenge action", e);
        }
        if (!(challengeResponse instanceof ChallengeResponse)) {
            this.disconnect();
            throw new AuthenticationFailedException("Unable to get challenge from Asterisk. ChallengeAction returned: " + challengeResponse.getMessage());
        }
        String challenge = ((ChallengeResponse)challengeResponse).getChallenge();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            if (challenge != null) {
                md.update(challenge.getBytes());
            }
            if (this.password != null) {
                md.update(this.password.getBytes());
            }
            key = ManagerUtil.toHexString(md.digest());
        }
        catch (NoSuchAlgorithmException ex) {
            this.disconnect();
            throw new AuthenticationFailedException("Unable to create login key using MD5 Message Digest", ex);
        }
        LoginAction loginAction = new LoginAction(this.username, "MD5", key, eventMask);
        try {
            loginResponse = this.sendAction(loginAction);
        }
        catch (Exception e) {
            this.disconnect();
            throw new AuthenticationFailedException("Unable to send login action", e);
        }
        if (loginResponse instanceof ManagerError) {
            this.disconnect();
            throw new AuthenticationFailedException(loginResponse.getMessage());
        }
        this.state = ManagerConnectionState.CONNECTED;
        this.logger.info("Successfully logged in");
        this.version = this.determineVersion();
        this.writer.setTargetVersion(this.version);
        this.logger.info("Determined Asterisk version: " + this.version);
        ConnectEvent connectEvent = new ConnectEvent(this);
        connectEvent.setProtocolIdentifier(this.getProtocolIdentifier());
        connectEvent.setDateReceived(DateUtil.getDate());
        this.fireEvent(connectEvent);
    }

    protected AsteriskVersion determineVersion() throws IOException, TimeoutException {
        ManagerResponse showVersionFilesResponse;
        int attempts = 0;
        if ("Asterisk Call Manager/1.1".equals(this.protocolIdentifier.value)) {
            return AsteriskVersion.ASTERISK_1_6;
        }
        while (attempts++ < 4 && (showVersionFilesResponse = this.sendAction((ManagerAction)new CommandAction("show version files pbx.c"), this.defaultResponseTimeout * 2L)) instanceof CommandResponse) {
            List<String> showVersionFilesResult = ((CommandResponse)showVersionFilesResponse).getResult();
            if (showVersionFilesResult == null || showVersionFilesResult.size() <= 0) continue;
            String line1 = showVersionFilesResult.get(0);
            if (line1 != null && line1.startsWith("File")) {
                String rawVersion = this.getRawVersion();
                if (rawVersion != null && rawVersion.startsWith("Asterisk 1.4")) {
                    return AsteriskVersion.ASTERISK_1_4;
                }
                return AsteriskVersion.ASTERISK_1_2;
            }
            if (line1 == null || !line1.contains("No such command")) break;
            try {
                Thread.sleep(500L);
            }
            catch (Exception ex) {}
        }
        return AsteriskVersion.ASTERISK_1_0;
    }

    protected String getRawVersion() {
        List<String> showVersionResult;
        ManagerResponse showVersionResponse;
        try {
            showVersionResponse = this.sendAction((ManagerAction)new CommandAction("show version"), this.defaultResponseTimeout * 2L);
        }
        catch (Exception e) {
            return null;
        }
        if (showVersionResponse instanceof CommandResponse && (showVersionResult = ((CommandResponse)showVersionResponse).getResult()) != null && showVersionResult.size() > 0) {
            return showVersionResult.get(0);
        }
        return null;
    }

    protected synchronized void connect() throws IOException {
        this.logger.info("Connecting to " + this.hostname + ":" + this.port);
        if (this.reader == null) {
            this.logger.debug("Creating reader for " + this.hostname + ":" + this.port);
            this.reader = this.createReader(this, this);
        }
        if (this.writer == null) {
            this.logger.debug("Creating writer");
            this.writer = this.createWriter();
        }
        this.logger.debug("Creating socket");
        this.socket = this.createSocket();
        this.logger.debug("Passing socket to reader");
        this.reader.setSocket(this.socket);
        if (this.readerThread == null || !this.readerThread.isAlive() || this.reader.isDead()) {
            this.logger.debug("Creating and starting reader thread");
            this.readerThread = new Thread(this.reader);
            this.readerThread.setName("Asterisk-Java ManagerConnection-" + this.id + "-Reader-" + this.readerThreadCounter.getAndIncrement());
            this.readerThread.setDaemon(true);
            this.readerThread.start();
        }
        this.logger.debug("Passing socket to writer");
        this.writer.setSocket(this.socket);
    }

    protected SocketConnectionFacade createSocket() throws IOException {
        return new SocketConnectionFacadeImpl(this.hostname, this.port, this.ssl, this.socketTimeout, this.socketReadTimeout);
    }

    @Override
    public synchronized void logoff() throws IllegalStateException {
        if (this.state != ManagerConnectionState.CONNECTED && this.state != ManagerConnectionState.RECONNECTING) {
            throw new IllegalStateException("Logoff may only be perfomed when in state CONNECTED or RECONNECTING, but connection is in state " + (Object)((Object)this.state));
        }
        this.state = ManagerConnectionState.DISCONNECTING;
        if (this.socket != null) {
            try {
                this.sendAction(new LogoffAction());
            }
            catch (Exception e) {
                this.logger.warn("Unable to send LogOff action", e);
            }
        }
        this.cleanup();
        this.state = ManagerConnectionState.DISCONNECTED;
    }

    protected synchronized void disconnect() {
        if (this.socket != null) {
            this.logger.info("Closing socket.");
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                this.logger.warn("Unable to close socket: " + ex.getMessage());
            }
            this.socket = null;
        }
        this.protocolIdentifier.value = null;
    }

    @Override
    public ManagerResponse sendAction(ManagerAction action) throws IOException, TimeoutException, IllegalArgumentException, IllegalStateException {
        return this.sendAction(action, this.defaultResponseTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagerResponse sendAction(ManagerAction action, long timeout) throws IOException, TimeoutException, IllegalArgumentException, IllegalStateException {
        ResponseHandlerResult result = new ResponseHandlerResult();
        DefaultSendActionCallback callbackHandler = new DefaultSendActionCallback(result);
        ResponseHandlerResult responseHandlerResult = result;
        synchronized (responseHandlerResult) {
            this.sendAction(action, callbackHandler);
            if (action instanceof UserEventAction) {
                return null;
            }
            if (result.getResponse() == null) {
                try {
                    result.wait(timeout);
                }
                catch (InterruptedException ex) {
                    this.logger.warn("Interrupted while waiting for result");
                }
            }
        }
        if (result.getResponse() == null) {
            throw new TimeoutException("Timeout waiting for response to " + action.getAction() + (action.getActionId() == null ? "" : " (actionId: " + action.getActionId() + ")"));
        }
        return result.getResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendAction(ManagerAction action, SendActionCallback callback) throws IOException, IllegalArgumentException, IllegalStateException {
        Class<? extends ManagerResponse> responseClass;
        if (action == null) {
            throw new IllegalArgumentException("Unable to send action: action is null.");
        }
        if (!((this.state == ManagerConnectionState.CONNECTING || this.state == ManagerConnectionState.RECONNECTING) && (action instanceof ChallengeAction || action instanceof LoginAction) || this.state == ManagerConnectionState.DISCONNECTING && action instanceof LogoffAction || this.state == ManagerConnectionState.CONNECTED)) {
            throw new IllegalStateException("Actions may only be sent when in state CONNECTED, but connection is in state " + (Object)((Object)this.state));
        }
        if (this.socket == null) {
            throw new IllegalStateException("Unable to send " + action.getAction() + " action: socket not connected.");
        }
        String internalActionId = this.createInternalActionId();
        if (callback != null) {
            Map<String, SendActionCallback> map = this.responseListeners;
            synchronized (map) {
                this.responseListeners.put(internalActionId, callback);
            }
        }
        if ((responseClass = this.getExpectedResponseClass(action.getClass())) != null) {
            this.reader.expectResponseClass(internalActionId, responseClass);
        }
        this.writer.sendAction(action, internalActionId);
    }

    private Class<? extends ManagerResponse> getExpectedResponseClass(Class<? extends ManagerAction> actionClass) {
        ExpectedResponse annotation = actionClass.getAnnotation(ExpectedResponse.class);
        if (annotation == null) {
            return null;
        }
        return annotation.value();
    }

    @Override
    public ResponseEvents sendEventGeneratingAction(EventGeneratingAction action) throws IOException, EventTimeoutException, IllegalArgumentException, IllegalStateException {
        return this.sendEventGeneratingAction(action, this.defaultEventTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseEvents sendEventGeneratingAction(EventGeneratingAction action, long timeout) throws IOException, EventTimeoutException, IllegalArgumentException, IllegalStateException {
        if (action == null) {
            throw new IllegalArgumentException("Unable to send action: action is null.");
        }
        if (action.getActionCompleteEventClass() == null) {
            throw new IllegalArgumentException("Unable to send action: actionCompleteEventClass for " + action.getClass().getName() + " is null.");
        }
        if (!ResponseEvent.class.isAssignableFrom(action.getActionCompleteEventClass())) {
            throw new IllegalArgumentException("Unable to send action: actionCompleteEventClass (" + action.getActionCompleteEventClass().getName() + ") for " + action.getClass().getName() + " is not a ResponseEvent.");
        }
        if (this.state != ManagerConnectionState.CONNECTED) {
            throw new IllegalStateException("Actions may only be sent when in state CONNECTED but connection is in state " + (Object)((Object)this.state));
        }
        ResponseEventsImpl responseEvents = new ResponseEventsImpl();
        ResponseEventHandler responseEventHandler = new ResponseEventHandler(responseEvents, action.getActionCompleteEventClass());
        String internalActionId = this.createInternalActionId();
        Map<String, ManagerEventListener> map = this.responseListeners;
        synchronized (map) {
            this.responseListeners.put(internalActionId, responseEventHandler);
        }
        map = this.responseEventListeners;
        synchronized (map) {
            this.responseEventListeners.put(internalActionId, responseEventHandler);
        }
        map = responseEvents;
        synchronized (map) {
            this.writer.sendAction(action, internalActionId);
            if (responseEvents.getResponse() == null || !responseEvents.isComplete()) {
                try {
                    responseEvents.wait(timeout);
                }
                catch (InterruptedException e) {
                    this.logger.warn("Interrupted while waiting for response events.");
                }
            }
        }
        if (responseEvents.getResponse() == null || !responseEvents.isComplete()) {
            map = this.responseEventListeners;
            synchronized (map) {
                this.responseEventListeners.remove(internalActionId);
            }
            throw new EventTimeoutException("Timeout waiting for response or response events to " + action.getAction() + (action.getActionId() == null ? "" : " (actionId: " + action.getActionId() + ")"), responseEvents);
        }
        map = this.responseEventListeners;
        synchronized (map) {
            this.responseEventListeners.remove(internalActionId);
        }
        return responseEvents;
    }

    private String createInternalActionId() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.hashCode());
        sb.append("_");
        sb.append(this.actionIdCounter.getAndIncrement());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventListener(ManagerEventListener listener) {
        List<ManagerEventListener> list = this.eventListeners;
        synchronized (list) {
            if (!this.eventListeners.contains(listener)) {
                this.eventListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEventListener(ManagerEventListener listener) {
        List<ManagerEventListener> list = this.eventListeners;
        synchronized (list) {
            if (this.eventListeners.contains(listener)) {
                this.eventListeners.remove(listener);
            }
        }
    }

    @Override
    public String getProtocolIdentifier() {
        return this.protocolIdentifier.value;
    }

    @Override
    public ManagerConnectionState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchResponse(ManagerResponse response) {
        if (response == null) {
            this.logger.error("Unable to dispatch null response. This should never happen. Please file a bug.");
            return;
        }
        String actionId = response.getActionId();
        String internalActionId = null;
        SendActionCallback listener = null;
        if (actionId != null) {
            internalActionId = ManagerUtil.getInternalActionId(actionId);
            response.setActionId(ManagerUtil.stripInternalActionId(actionId));
        }
        this.logger.debug("Dispatching response with internalActionId '" + internalActionId + "':\n" + response);
        if (internalActionId != null) {
            Map<String, SendActionCallback> map = this.responseListeners;
            synchronized (map) {
                listener = this.responseListeners.get(internalActionId);
                if (listener != null) {
                    this.responseListeners.remove(internalActionId);
                } else {
                    this.logger.debug("No response listener registered for internalActionId '" + internalActionId + "'");
                }
            }
        } else {
            this.logger.error("Unable to retrieve internalActionId from response: actionId '" + actionId + "':\n" + response);
        }
        if (listener != null) {
            try {
                listener.onResponse(response);
            }
            catch (Exception e) {
                this.logger.warn("Unexpected exception in response listener " + listener.getClass().getName(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchEvent(ManagerEvent event) {
        ResponseEvent responseEvent;
        String internalActionId;
        if (event == null) {
            this.logger.error("Unable to dispatch null event. This should never happen. Please file a bug.");
            return;
        }
        this.logger.debug("Dispatching event:\n" + event.toString());
        if (event instanceof ResponseEvent && (internalActionId = (responseEvent = (ResponseEvent)event).getInternalActionId()) != null) {
            Map<String, ManagerEventListener> map = this.responseEventListeners;
            synchronized (map) {
                ManagerEventListener listener = this.responseEventListeners.get(internalActionId);
                if (listener != null) {
                    try {
                        listener.onManagerEvent(event);
                    }
                    catch (Exception e) {
                        this.logger.warn("Unexpected exception in response event listener " + listener.getClass().getName(), e);
                    }
                }
            }
        }
        if (event instanceof DisconnectEvent) {
            if (this.state == ManagerConnectionState.CONNECTED) {
                this.state = ManagerConnectionState.RECONNECTING;
                this.cleanup();
                Thread reconnectThread = new Thread(new Runnable(){

                    public void run() {
                        ManagerConnectionImpl.this.reconnect();
                    }
                });
                reconnectThread.setName("Asterisk-Java ManagerConnection-" + this.id + "-Reconnect-" + this.reconnectThreadCounter.getAndIncrement());
                reconnectThread.setDaemon(true);
                reconnectThread.start();
            } else {
                return;
            }
        }
        if (event instanceof ProtocolIdentifierReceivedEvent) {
            ProtocolIdentifierReceivedEvent protocolIdentifierReceivedEvent = (ProtocolIdentifierReceivedEvent)event;
            String protocolIdentifier = protocolIdentifierReceivedEvent.getProtocolIdentifier();
            this.setProtocolIdentifier(protocolIdentifier);
            return;
        }
        this.fireEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(ManagerEvent event) {
        List<ManagerEventListener> list = this.eventListeners;
        synchronized (list) {
            for (ManagerEventListener listener : this.eventListeners) {
                try {
                    listener.onManagerEvent(event);
                }
                catch (RuntimeException e) {
                    this.logger.warn("Unexpected exception in eventHandler " + listener.getClass().getName(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProtocolIdentifier(String identifier) {
        this.logger.info("Connected via " + identifier);
        if (!("Asterisk Call Manager/1.0".equals(identifier) || "Asterisk Call Manager/1.1".equals(identifier) || "Asterisk Call Manager/1.2".equals(identifier) || "OpenPBX Call Manager/1.0".equals(identifier) || "CallWeaver Call Manager/1.0".equals(identifier) || identifier != null && identifier.startsWith("Asterisk Call Manager Proxy/"))) {
            this.logger.warn("Unsupported protocol version '" + identifier + "'. Use at your own risk.");
        }
        ProtocolIdentifierWrapper protocolIdentifierWrapper = this.protocolIdentifier;
        synchronized (protocolIdentifierWrapper) {
            this.protocolIdentifier.value = identifier;
            this.protocolIdentifier.notifyAll();
        }
    }

    private void reconnect() {
        int numTries = 0;
        while (this.state == ManagerConnectionState.RECONNECTING) {
            try {
                if (numTries < 10) {
                    Thread.sleep(50L);
                } else {
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            try {
                this.connect();
                try {
                    this.doLogin(this.defaultResponseTimeout, this.eventMask);
                    this.logger.info("Successfully reconnected.");
                    break;
                }
                catch (AuthenticationFailedException e1) {
                    if (this.keepAliveAfterAuthenticationFailure) {
                        this.logger.error("Unable to log in after reconnect: " + e1.getMessage());
                    } else {
                        this.logger.error("Unable to log in after reconnect: " + e1.getMessage() + ". Giving up.");
                        this.state = ManagerConnectionState.DISCONNECTED;
                    }
                }
                catch (TimeoutException e1) {
                    this.logger.error("TimeoutException while trying to log in after reconnect.");
                }
            }
            catch (IOException e) {
                this.logger.warn("Exception while trying to reconnect: " + e.getMessage());
            }
            ++numTries;
        }
    }

    private void cleanup() {
        this.disconnect();
        this.readerThread = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ManagerConnection[");
        sb.append("id='").append(this.id).append("',");
        sb.append("hostname='").append(this.hostname).append("',");
        sb.append("port=").append(this.port).append(",");
        sb.append("systemHashcode=").append(System.identityHashCode(this)).append("]");
        return sb.toString();
    }

    private static class ProtocolIdentifierWrapper {
        String value;

        private ProtocolIdentifierWrapper() {
        }
    }

    private static class ResponseEventHandler
    implements ManagerEventListener,
    SendActionCallback {
        private final ResponseEventsImpl events;
        private final Class actionCompleteEventClass;

        public ResponseEventHandler(ResponseEventsImpl events, Class actionCompleteEventClass) {
            this.events = events;
            this.actionCompleteEventClass = actionCompleteEventClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onManagerEvent(ManagerEvent event) {
            ResponseEventsImpl responseEventsImpl = this.events;
            synchronized (responseEventsImpl) {
                if (event instanceof ResponseEvent) {
                    ResponseEvent responseEvent = (ResponseEvent)event;
                    this.events.addEvent(responseEvent);
                }
                if (this.actionCompleteEventClass.isAssignableFrom(event.getClass())) {
                    this.events.setComplete(true);
                    if (this.events.getResponse() != null) {
                        this.events.notifyAll();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(ManagerResponse response) {
            ResponseEventsImpl responseEventsImpl = this.events;
            synchronized (responseEventsImpl) {
                this.events.setRepsonse(response);
                if (response instanceof ManagerError) {
                    this.events.setComplete(true);
                }
                if (this.events.isComplete()) {
                    this.events.notifyAll();
                }
            }
        }
    }

    private static class DefaultSendActionCallback
    implements SendActionCallback,
    Serializable {
        private static final long serialVersionUID = 2926598671855316803L;
        private final ResponseHandlerResult result;

        public DefaultSendActionCallback(ResponseHandlerResult result) {
            this.result = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(ManagerResponse response) {
            ResponseHandlerResult responseHandlerResult = this.result;
            synchronized (responseHandlerResult) {
                this.result.setResponse(response);
                this.result.notifyAll();
            }
        }
    }

    private static class ResponseHandlerResult
    implements Serializable {
        private static final long serialVersionUID = 7831097958568769220L;
        private ManagerResponse response;

        public ManagerResponse getResponse() {
            return this.response;
        }

        public void setResponse(ManagerResponse response) {
            this.response = response;
        }
    }
}

