/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.asteriskjava.manager.event.AgentCallbackLoginEvent;
import org.asteriskjava.manager.event.AgentCallbackLogoffEvent;
import org.asteriskjava.manager.event.AgentCalledEvent;
import org.asteriskjava.manager.event.AgentCompleteEvent;
import org.asteriskjava.manager.event.AgentConnectEvent;
import org.asteriskjava.manager.event.AgentDumpEvent;
import org.asteriskjava.manager.event.AgentLoginEvent;
import org.asteriskjava.manager.event.AgentLogoffEvent;
import org.asteriskjava.manager.event.AgentRingNoAnswerEvent;
import org.asteriskjava.manager.event.AgentsCompleteEvent;
import org.asteriskjava.manager.event.AgentsEvent;
import org.asteriskjava.manager.event.AgiExecEvent;
import org.asteriskjava.manager.event.AlarmClearEvent;
import org.asteriskjava.manager.event.AlarmEvent;
import org.asteriskjava.manager.event.AsyncAgiEvent;
import org.asteriskjava.manager.event.BridgeEvent;
import org.asteriskjava.manager.event.BridgeExecEvent;
import org.asteriskjava.manager.event.CdrEvent;
import org.asteriskjava.manager.event.ChannelReloadEvent;
import org.asteriskjava.manager.event.ChannelUpdateEvent;
import org.asteriskjava.manager.event.DbGetResponseEvent;
import org.asteriskjava.manager.event.DialEvent;
import org.asteriskjava.manager.event.DndStateEvent;
import org.asteriskjava.manager.event.DtmfEvent;
import org.asteriskjava.manager.event.ExtensionStatusEvent;
import org.asteriskjava.manager.event.FaxReceivedEvent;
import org.asteriskjava.manager.event.HangupEvent;
import org.asteriskjava.manager.event.HoldEvent;
import org.asteriskjava.manager.event.HoldedCallEvent;
import org.asteriskjava.manager.event.JabberEventEvent;
import org.asteriskjava.manager.event.JitterBufStatsEvent;
import org.asteriskjava.manager.event.JoinEvent;
import org.asteriskjava.manager.event.LeaveEvent;
import org.asteriskjava.manager.event.LinkEvent;
import org.asteriskjava.manager.event.ListDialplanEvent;
import org.asteriskjava.manager.event.LogChannelEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.MasqueradeEvent;
import org.asteriskjava.manager.event.MeetMeEndEvent;
import org.asteriskjava.manager.event.MeetMeJoinEvent;
import org.asteriskjava.manager.event.MeetMeLeaveEvent;
import org.asteriskjava.manager.event.MeetMeMuteEvent;
import org.asteriskjava.manager.event.MeetMeStopTalkingEvent;
import org.asteriskjava.manager.event.MeetMeTalkingEvent;
import org.asteriskjava.manager.event.MeetMeTalkingRequestEvent;
import org.asteriskjava.manager.event.MessageWaitingEvent;
import org.asteriskjava.manager.event.ModuleLoadReportEvent;
import org.asteriskjava.manager.event.MonitorStartEvent;
import org.asteriskjava.manager.event.MonitorStopEvent;
import org.asteriskjava.manager.event.MusicOnHoldEvent;
import org.asteriskjava.manager.event.NewAccountCodeEvent;
import org.asteriskjava.manager.event.NewCallerIdEvent;
import org.asteriskjava.manager.event.NewChannelEvent;
import org.asteriskjava.manager.event.NewExtenEvent;
import org.asteriskjava.manager.event.NewStateEvent;
import org.asteriskjava.manager.event.OriginateFailureEvent;
import org.asteriskjava.manager.event.OriginateResponseEvent;
import org.asteriskjava.manager.event.OriginateSuccessEvent;
import org.asteriskjava.manager.event.ParkedCallEvent;
import org.asteriskjava.manager.event.ParkedCallGiveUpEvent;
import org.asteriskjava.manager.event.ParkedCallTimeOutEvent;
import org.asteriskjava.manager.event.ParkedCallsCompleteEvent;
import org.asteriskjava.manager.event.PeerEntryEvent;
import org.asteriskjava.manager.event.PeerStatusEvent;
import org.asteriskjava.manager.event.PeerlistCompleteEvent;
import org.asteriskjava.manager.event.PriEventEvent;
import org.asteriskjava.manager.event.QueueCallerAbandonEvent;
import org.asteriskjava.manager.event.QueueEntryEvent;
import org.asteriskjava.manager.event.QueueMemberAddedEvent;
import org.asteriskjava.manager.event.QueueMemberEvent;
import org.asteriskjava.manager.event.QueueMemberPausedEvent;
import org.asteriskjava.manager.event.QueueMemberPenaltyEvent;
import org.asteriskjava.manager.event.QueueMemberRemovedEvent;
import org.asteriskjava.manager.event.QueueMemberStatusEvent;
import org.asteriskjava.manager.event.QueueParamsEvent;
import org.asteriskjava.manager.event.QueueStatusCompleteEvent;
import org.asteriskjava.manager.event.QueueSummaryCompleteEvent;
import org.asteriskjava.manager.event.QueueSummaryEvent;
import org.asteriskjava.manager.event.RegistrationsCompleteEvent;
import org.asteriskjava.manager.event.RegistryEntryEvent;
import org.asteriskjava.manager.event.RegistryEvent;
import org.asteriskjava.manager.event.ReloadEvent;
import org.asteriskjava.manager.event.RenameEvent;
import org.asteriskjava.manager.event.ResponseEvent;
import org.asteriskjava.manager.event.RtcpReceivedEvent;
import org.asteriskjava.manager.event.RtcpSentEvent;
import org.asteriskjava.manager.event.RtpReceiverStatEvent;
import org.asteriskjava.manager.event.RtpSenderStatEvent;
import org.asteriskjava.manager.event.ShowDialplanCompleteEvent;
import org.asteriskjava.manager.event.ShutdownEvent;
import org.asteriskjava.manager.event.StatusCompleteEvent;
import org.asteriskjava.manager.event.StatusEvent;
import org.asteriskjava.manager.event.TransferEvent;
import org.asteriskjava.manager.event.UnholdEvent;
import org.asteriskjava.manager.event.UnlinkEvent;
import org.asteriskjava.manager.event.UnparkedCallEvent;
import org.asteriskjava.manager.event.UserEvent;
import org.asteriskjava.manager.event.VarSetEvent;
import org.asteriskjava.manager.event.VoicemailUserEntryCompleteEvent;
import org.asteriskjava.manager.event.VoicemailUserEntryEvent;
import org.asteriskjava.manager.event.ZapShowChannelsCompleteEvent;
import org.asteriskjava.manager.event.ZapShowChannelsEvent;
import org.asteriskjava.manager.internal.AbstractBuilder;
import org.asteriskjava.manager.internal.EventBuilder;
import org.asteriskjava.manager.internal.ManagerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EventBuilderImpl
extends AbstractBuilder
implements EventBuilder {
    private static final Set<String> ignoredAttributes = new HashSet<String>(Arrays.asList("event"));
    private Map<String, Class> registeredEventClasses = new HashMap<String, Class>();

    EventBuilderImpl() {
        this.registerBuiltinEventClasses();
    }

    private void registerBuiltinEventClasses() {
        this.registerEventClass(AgentCallbackLoginEvent.class);
        this.registerEventClass(AgentCallbackLogoffEvent.class);
        this.registerEventClass(AgentCalledEvent.class);
        this.registerEventClass(AgentConnectEvent.class);
        this.registerEventClass(AgentCompleteEvent.class);
        this.registerEventClass(AgentDumpEvent.class);
        this.registerEventClass(AgentLoginEvent.class);
        this.registerEventClass(AgentLogoffEvent.class);
        this.registerEventClass(AgentRingNoAnswerEvent.class);
        this.registerEventClass(AgentsEvent.class);
        this.registerEventClass(AgentsCompleteEvent.class);
        this.registerEventClass(AgiExecEvent.class);
        this.registerEventClass(AsyncAgiEvent.class);
        this.registerEventClass(AlarmEvent.class);
        this.registerEventClass(AlarmClearEvent.class);
        this.registerEventClass(BridgeEvent.class);
        this.registerEventClass(BridgeExecEvent.class);
        this.registerEventClass(CdrEvent.class);
        this.registerEventClass(ChannelReloadEvent.class);
        this.registerEventClass(ChannelUpdateEvent.class);
        this.registerEventClass(DbGetResponseEvent.class);
        this.registerEventClass(DialEvent.class);
        this.registerEventClass(DndStateEvent.class);
        this.registerEventClass(DtmfEvent.class);
        this.registerEventClass(ExtensionStatusEvent.class);
        this.registerEventClass(FaxReceivedEvent.class);
        this.registerEventClass(HangupEvent.class);
        this.registerEventClass(HoldedCallEvent.class);
        this.registerEventClass(HoldEvent.class);
        this.registerEventClass(JabberEventEvent.class);
        this.registerEventClass(JitterBufStatsEvent.class);
        this.registerEventClass(JoinEvent.class);
        this.registerEventClass(LeaveEvent.class);
        this.registerEventClass(LinkEvent.class);
        this.registerEventClass(ListDialplanEvent.class);
        this.registerEventClass(LogChannelEvent.class);
        this.registerEventClass(MasqueradeEvent.class);
        this.registerEventClass(MeetMeEndEvent.class);
        this.registerEventClass(MeetMeJoinEvent.class);
        this.registerEventClass(MeetMeLeaveEvent.class);
        this.registerEventClass(MeetMeMuteEvent.class);
        this.registerEventClass(MeetMeTalkingEvent.class);
        this.registerEventClass(MeetMeTalkingRequestEvent.class);
        this.registerEventClass(MeetMeStopTalkingEvent.class);
        this.registerEventClass(MessageWaitingEvent.class);
        this.registerEventClass(ModuleLoadReportEvent.class);
        this.registerEventClass(MonitorStartEvent.class);
        this.registerEventClass(MonitorStopEvent.class);
        this.registerEventClass(MusicOnHoldEvent.class);
        this.registerEventClass(NewAccountCodeEvent.class);
        this.registerEventClass(NewCallerIdEvent.class);
        this.registerEventClass(NewChannelEvent.class);
        this.registerEventClass(NewExtenEvent.class);
        this.registerEventClass(NewStateEvent.class);
        this.registerEventClass(OriginateFailureEvent.class);
        this.registerEventClass(OriginateSuccessEvent.class);
        this.registerEventClass(OriginateResponseEvent.class);
        this.registerEventClass(ParkedCallGiveUpEvent.class);
        this.registerEventClass(ParkedCallEvent.class);
        this.registerEventClass(ParkedCallTimeOutEvent.class);
        this.registerEventClass(ParkedCallsCompleteEvent.class);
        this.registerEventClass(PeerEntryEvent.class);
        this.registerEventClass(PeerlistCompleteEvent.class);
        this.registerEventClass(PeerStatusEvent.class);
        this.registerEventClass(PriEventEvent.class);
        this.registerEventClass(QueueCallerAbandonEvent.class);
        this.registerEventClass(QueueEntryEvent.class);
        this.registerEventClass(QueueMemberAddedEvent.class);
        this.registerEventClass(QueueMemberEvent.class);
        this.registerEventClass(QueueMemberPausedEvent.class);
        this.registerEventClass(QueueMemberPenaltyEvent.class);
        this.registerEventClass(QueueMemberRemovedEvent.class);
        this.registerEventClass(QueueMemberStatusEvent.class);
        this.registerEventClass(QueueParamsEvent.class);
        this.registerEventClass(QueueStatusCompleteEvent.class);
        this.registerEventClass(QueueSummaryCompleteEvent.class);
        this.registerEventClass(QueueSummaryEvent.class);
        this.registerEventClass(RegistrationsCompleteEvent.class);
        this.registerEventClass(RegistryEntryEvent.class);
        this.registerEventClass(RegistryEvent.class);
        this.registerEventClass(ReloadEvent.class);
        this.registerEventClass(RenameEvent.class);
        this.registerEventClass(RtcpReceivedEvent.class);
        this.registerEventClass(RtcpSentEvent.class);
        this.registerEventClass(RtpReceiverStatEvent.class);
        this.registerEventClass(RtpSenderStatEvent.class);
        this.registerEventClass(ShowDialplanCompleteEvent.class);
        this.registerEventClass(ShutdownEvent.class);
        this.registerEventClass(StatusEvent.class);
        this.registerEventClass(StatusCompleteEvent.class);
        this.registerEventClass(TransferEvent.class);
        this.registerEventClass(UnholdEvent.class);
        this.registerEventClass(UnlinkEvent.class);
        this.registerEventClass(UnparkedCallEvent.class);
        this.registerEventClass(VarSetEvent.class);
        this.registerEventClass(VoicemailUserEntryCompleteEvent.class);
        this.registerEventClass(VoicemailUserEntryEvent.class);
        this.registerEventClass(ZapShowChannelsEvent.class);
        this.registerEventClass(ZapShowChannelsCompleteEvent.class);
    }

    @Override
    public final void registerEventClass(Class<? extends ManagerEvent> clazz) throws IllegalArgumentException {
        String className = clazz.getName();
        String eventType = className.substring(className.lastIndexOf(46) + 1).toLowerCase(Locale.ENGLISH);
        if (eventType.endsWith("event")) {
            eventType = eventType.substring(0, eventType.length() - "event".length());
        }
        if (UserEvent.class.isAssignableFrom(clazz) && !eventType.startsWith("userevent")) {
            eventType = "userevent" + eventType;
        }
        this.registerEventClass(eventType, clazz);
    }

    public final void registerEventClass(String eventType, Class<? extends ManagerEvent> clazz) throws IllegalArgumentException {
        Constructor<? extends ManagerEvent> defaultConstructor;
        if (!ManagerEvent.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is not a ManagerEvent");
        }
        if ((clazz.getModifiers() & 0x400) != 0) {
            throw new IllegalArgumentException(clazz + " is abstract");
        }
        try {
            defaultConstructor = clazz.getConstructor(Object.class);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(clazz + " has no usable constructor");
        }
        if ((defaultConstructor.getModifiers() & 1) == 0) {
            throw new IllegalArgumentException(clazz + " has no public default constructor");
        }
        this.registeredEventClasses.put(eventType.toLowerCase(Locale.US), clazz);
        this.logger.debug("Registered event type '" + eventType + "' (" + clazz + ")");
    }

    @Override
    public ManagerEvent buildEvent(Object source, Map<String, Object> attributes) {
        ResponseEvent responseEvent;
        String actionId;
        ManagerEvent event;
        Constructor constructor;
        Class eventClass;
        if (attributes.get("event") == null) {
            this.logger.error("No event type in properties");
            return null;
        }
        if (!(attributes.get("event") instanceof String)) {
            this.logger.error("Event type is not a String");
            return null;
        }
        String eventType = ((String)attributes.get("event")).toLowerCase(Locale.US);
        if ("userevent".equals(eventType)) {
            if (attributes.get("userevent") == null) {
                this.logger.error("No user event type in properties");
                return null;
            }
            if (!(attributes.get("userevent") instanceof String)) {
                this.logger.error("User event type is not a String");
                return null;
            }
            String userEventType = ((String)attributes.get("userevent")).toLowerCase(Locale.US);
            eventType = eventType + userEventType;
        }
        if ((eventClass = this.registeredEventClasses.get(eventType)) == null) {
            this.logger.info("No event class registered for event type '" + eventType + "', attributes: " + attributes + ". Please report at http://jira.reucon.org/browse/AJ");
            return null;
        }
        try {
            constructor = eventClass.getConstructor(Object.class);
        }
        catch (NoSuchMethodException ex) {
            this.logger.error("Unable to get constructor of " + eventClass.getName(), ex);
            return null;
        }
        try {
            event = (ManagerEvent)constructor.newInstance(source);
        }
        catch (Exception ex) {
            this.logger.error("Unable to create new instance of " + eventClass.getName(), ex);
            return null;
        }
        this.setAttributes(event, attributes, ignoredAttributes);
        if (event instanceof ResponseEvent && (actionId = (responseEvent = (ResponseEvent)event).getActionId()) != null) {
            responseEvent.setActionId(ManagerUtil.stripInternalActionId(actionId));
            responseEvent.setInternalActionId(ManagerUtil.getInternalActionId(actionId));
        }
        return event;
    }
}

