/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.event;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.asteriskjava.manager.event.ResponseEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncAgiEvent
extends ResponseEvent {
    static final long serialVersionUID = 0L;
    public static final String SUB_EVENT_START = "Start";
    public static final String SUB_EVENT_EXEC = "Exec";
    public static final String SUB_EVENT_END = "End";
    private String channel;
    private String subEvent;
    private String commandId;
    private String result;
    private String env;

    public AsyncAgiEvent(Object source) {
        super(source);
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getSubEvent() {
        return this.subEvent;
    }

    public void setSubEvent(String subEvent) {
        this.subEvent = subEvent;
    }

    public String getCommandId() {
        return this.commandId;
    }

    public void setCommandId(String commandId) {
        this.commandId = commandId;
    }

    public String getResult() {
        return this.result;
    }

    public List<String> decodeResult() {
        return this.decode(this.getResult());
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getEnv() {
        return this.env;
    }

    public List<String> decodeEnv() {
        return this.decode(this.getEnv());
    }

    private List<String> decode(String s) {
        ArrayList<String> result = new ArrayList<String>();
        if (s == null) {
            return result;
        }
        try {
            for (String line : s.split("\n")) {
                String decodedLine = URLDecoder.decode(line, "ISO-8859-1");
                result.add(decodedLine);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("This JDK does not support ISO-8859-1 encoding", e);
        }
        return result;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public boolean isStart() {
        return this.isSubEvent(SUB_EVENT_START);
    }

    public boolean isExec() {
        return this.isSubEvent(SUB_EVENT_EXEC);
    }

    public boolean isEnd() {
        return this.isSubEvent(SUB_EVENT_END);
    }

    protected boolean isSubEvent(String subEvent) {
        return this.subEvent != null && this.subEvent.equalsIgnoreCase(subEvent);
    }
}

