/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerConnectionState;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.action.PingAction;
import org.asteriskjava.manager.response.ManagerResponse;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class PingThread
extends Thread {
    private static final long DEFAULT_INTERVAL = 20000L;
    private static final long DEFAULT_TIMEOUT = 0L;
    private static final AtomicLong idCounter = new AtomicLong(0L);
    private final Log logger = LogFactory.getLog(this.getClass());
    private long interval = 20000L;
    private long timeout = 0L;
    private volatile boolean die = false;
    private final Set<ManagerConnection> connections = new HashSet<ManagerConnection>();

    public PingThread() {
        long id = idCounter.getAndIncrement();
        this.setName("Asterisk-Java Ping-" + id);
        this.setDaemon(true);
    }

    public PingThread(ManagerConnection connection) {
        this();
        this.connections.add(connection);
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(ManagerConnection connection) {
        Set<ManagerConnection> set = this.connections;
        synchronized (set) {
            this.connections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(ManagerConnection connection) {
        Set<ManagerConnection> set = this.connections;
        synchronized (set) {
            this.connections.remove(connection);
        }
    }

    public void die() {
        this.die = true;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.die) {
            try {
                PingThread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.die) break;
            Set<ManagerConnection> set = this.connections;
            synchronized (set) {
                for (ManagerConnection c : this.connections) {
                    if (c.getState() != ManagerConnectionState.CONNECTED) continue;
                    this.ping(c);
                }
            }
        }
    }

    protected void ping(ManagerConnection c) {
        try {
            if (this.timeout <= 0L) {
                c.sendAction((ManagerAction)new PingAction(), null);
            } else {
                ManagerResponse response = c.sendAction((ManagerAction)new PingAction(), this.timeout);
                this.logger.debug("Ping response '" + response + "' for " + c.toString());
            }
        }
        catch (Exception e) {
            this.logger.warn("Exception on sending Ping to " + c.toString(), e);
        }
    }
}

