/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.asteriskjava.live.ManagerCommunicationException;
import org.asteriskjava.live.internal.ManagerCommunicationExceptionMapper;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ResponseEvents;
import org.asteriskjava.manager.action.EventGeneratingAction;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.response.ManagerResponse;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

class ManagerConnectionPool {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final BlockingQueue<ManagerConnection> connections;

    ManagerConnectionPool(int size) {
        this.connections = new ArrayBlockingQueue<ManagerConnection>(size);
    }

    void clear() {
        this.connections.clear();
    }

    void add(ManagerConnection connection) {
        this.put(connection);
    }

    ManagerResponse sendAction(ManagerAction action) throws ManagerCommunicationException {
        ManagerResponse response;
        ManagerConnection connection = this.get();
        try {
            response = connection.sendAction(action);
        }
        catch (Exception e) {
            throw ManagerCommunicationExceptionMapper.mapSendActionException(action.getAction(), e);
        }
        finally {
            this.put(connection);
        }
        return response;
    }

    ResponseEvents sendEventGeneratingAction(EventGeneratingAction action) throws ManagerCommunicationException {
        return this.sendEventGeneratingAction(action, -1L);
    }

    ResponseEvents sendEventGeneratingAction(EventGeneratingAction action, long timeout) throws ManagerCommunicationException {
        ResponseEvents responseEvents;
        ManagerConnection connection = this.get();
        try {
            responseEvents = timeout > 0L ? connection.sendEventGeneratingAction(action, timeout) : connection.sendEventGeneratingAction(action);
        }
        catch (Exception e) {
            throw ManagerCommunicationExceptionMapper.mapSendActionException(action.getAction(), e);
        }
        finally {
            this.put(connection);
        }
        return responseEvents;
    }

    private ManagerConnection get() {
        try {
            return this.connections.take();
        }
        catch (InterruptedException e) {
            this.logger.error("Interrupted while waiting for ManagerConnection to become available", e);
            return null;
        }
    }

    private void put(ManagerConnection connection) {
        try {
            this.connections.put(connection);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to add connection to pool");
        }
    }
}

