/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.asteriskjava.live.AgentState;
import org.asteriskjava.live.AsteriskAgent;
import org.asteriskjava.live.ManagerCommunicationException;
import org.asteriskjava.live.internal.AsteriskAgentImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.manager.ResponseEvents;
import org.asteriskjava.manager.action.AgentsAction;
import org.asteriskjava.manager.event.AgentCallbackLoginEvent;
import org.asteriskjava.manager.event.AgentCallbackLogoffEvent;
import org.asteriskjava.manager.event.AgentCalledEvent;
import org.asteriskjava.manager.event.AgentCompleteEvent;
import org.asteriskjava.manager.event.AgentConnectEvent;
import org.asteriskjava.manager.event.AgentLoginEvent;
import org.asteriskjava.manager.event.AgentLogoffEvent;
import org.asteriskjava.manager.event.AgentsEvent;
import org.asteriskjava.manager.event.ResponseEvent;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentManager {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final AsteriskServerImpl server;
    private final Map<String, AsteriskAgentImpl> agents;
    private final Map<String, AsteriskAgentImpl> ringingAgents;

    AgentManager(AsteriskServerImpl asteriskServerImpl) {
        this.server = asteriskServerImpl;
        this.agents = new HashMap<String, AsteriskAgentImpl>();
        this.ringingAgents = new HashMap<String, AsteriskAgentImpl>();
    }

    void initialize() throws ManagerCommunicationException {
        ResponseEvents re = this.server.sendEventGeneratingAction(new AgentsAction());
        for (ResponseEvent event : re.getEvents()) {
            if (!(event instanceof AgentsEvent)) continue;
            System.out.println(event);
            this.handleAgentsEvent((AgentsEvent)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnected() {
        Map<String, AsteriskAgentImpl> map = this.agents;
        synchronized (map) {
            this.agents.clear();
        }
    }

    void handleAgentsEvent(AgentsEvent event) {
        AsteriskAgentImpl agent = new AsteriskAgentImpl(this.server, event.getName(), "Agent/" + event.getAgent(), AgentState.valueOf(event.getStatus()));
        this.logger.info("Adding agent " + agent.getName() + "(" + agent.getAgentId() + ")");
        this.addAgent(agent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAgent(AsteriskAgentImpl agent) {
        Map<String, AsteriskAgentImpl> map = this.agents;
        synchronized (map) {
            this.agents.put(agent.getAgentId(), agent);
        }
        this.server.fireNewAgent(agent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsteriskAgentImpl getAgentByAgentId(String agentId) {
        Map<String, AsteriskAgentImpl> map = this.agents;
        synchronized (map) {
            return this.agents.get(agentId);
        }
    }

    void handleAgentCalledEvent(AgentCalledEvent event) {
        AsteriskAgentImpl agent = this.getAgentByAgentId(event.getAgentCalled());
        if (agent == null) {
            this.logger.error("Ignored AgentCalledEvent for unknown agent " + event.getAgentCalled());
            return;
        }
        this.updateRingingAgents(event.getChannelCalling(), agent);
        this.updateAgentState(agent, AgentState.AGENT_RINGING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAgentState(AsteriskAgentImpl agent, AgentState newState) {
        this.logger.info("Set state of agent " + agent.getAgentId() + " to " + (Object)((Object)newState));
        AsteriskAgentImpl asteriskAgentImpl = agent;
        synchronized (asteriskAgentImpl) {
            agent.updateState(newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRingingAgents(String channelCalling, AsteriskAgentImpl agent) {
        Map<String, AsteriskAgentImpl> map = this.ringingAgents;
        synchronized (map) {
            if (this.ringingAgents.containsKey(channelCalling)) {
                this.updateAgentState(this.ringingAgents.get(channelCalling), AgentState.AGENT_IDLE);
            }
            this.ringingAgents.put(channelCalling, agent);
        }
    }

    void handleAgentConnectEvent(AgentConnectEvent event) {
        AsteriskAgentImpl agent = this.getAgentByAgentId(event.getChannel());
        if (agent == null) {
            this.logger.error("Ignored AgentConnectEvent for unknown agent " + event.getChannel());
            return;
        }
        agent.updateState(AgentState.AGENT_ONCALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleAgentLoginEvent(AgentLoginEvent event) {
        AsteriskAgentImpl agent = this.getAgentByAgentId("Agent/" + event.getAgent());
        if (agent == null) {
            Map<String, AsteriskAgentImpl> map = this.agents;
            synchronized (map) {
                this.logger.error("Ignored AgentLoginEvent for unknown agent " + event.getAgent() + ". Agents: " + this.agents.values().toString());
            }
            return;
        }
        agent.updateState(AgentState.AGENT_IDLE);
    }

    void handleAgentLogoffEvent(AgentLogoffEvent event) {
        AsteriskAgentImpl agent = this.getAgentByAgentId("Agent/" + event.getAgent());
        if (agent == null) {
            this.logger.error("Ignored AgentLogoffEvent for unknown agent " + event.getAgent() + ". Agents: " + this.agents.values().toString());
            return;
        }
        agent.updateState(AgentState.AGENT_LOGGEDOFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleAgentCallbackLoginEvent(AgentCallbackLoginEvent event) {
        AsteriskAgentImpl agent = this.getAgentByAgentId("Agent/" + event.getAgent());
        if (agent == null) {
            Map<String, AsteriskAgentImpl> map = this.agents;
            synchronized (map) {
                this.logger.error("Ignored AgentCallbackLoginEvent for unknown agent " + event.getAgent() + ". Agents: " + this.agents.values().toString());
            }
            return;
        }
        agent.updateState(AgentState.AGENT_IDLE);
    }

    void handleAgentCallbackLogoffEvent(AgentCallbackLogoffEvent event) {
        AsteriskAgentImpl agent = this.getAgentByAgentId("Agent/" + event.getAgent());
        if (agent == null) {
            this.logger.error("Ignored AgentCallbackLogoffEvent for unknown agent " + event.getAgent() + ". Agents: " + this.agents.values().toString());
            return;
        }
        agent.updateState(AgentState.AGENT_LOGGEDOFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<AsteriskAgent> getAgents() {
        ArrayList<AsteriskAgent> copy;
        Map<String, AsteriskAgentImpl> map = this.agents;
        synchronized (map) {
            copy = new ArrayList<AsteriskAgent>(this.agents.values());
        }
        return copy;
    }

    void handleAgentCompleteEvent(AgentCompleteEvent event) {
        AsteriskAgentImpl agent = this.getAgentByAgentId(event.getChannel());
        if (agent == null) {
            this.logger.error("Ignored AgentCompleteEvent for unknown agent " + event.getChannel());
            return;
        }
        agent.updateState(AgentState.AGENT_IDLE);
    }
}

