/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi;

import java.util.HashMap;
import java.util.Map;
import org.asteriskjava.fastagi.AbstractAgiServer;
import org.asteriskjava.fastagi.AgiScript;
import org.asteriskjava.fastagi.MappingStrategy;
import org.asteriskjava.fastagi.StaticMappingStrategy;
import org.asteriskjava.fastagi.internal.AsyncAgiConnectionHandler;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerEventListener;
import org.asteriskjava.manager.event.AsyncAgiEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.RenameEvent;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class AsyncAgiServer
extends AbstractAgiServer
implements ManagerEventListener {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Map<Integer, AsyncAgiConnectionHandler> connectionHandlers = new HashMap<Integer, AsyncAgiConnectionHandler>();

    public AsyncAgiServer() {
    }

    public AsyncAgiServer(MappingStrategy mappingStrategy) {
        this();
        this.setMappingStrategy(mappingStrategy);
    }

    public AsyncAgiServer(AgiScript agiScript) {
        this();
        this.setMappingStrategy(new StaticMappingStrategy(agiScript));
    }

    public void onManagerEvent(ManagerEvent event) {
        if (event instanceof AsyncAgiEvent) {
            this.handleAsyncAgiEvent((AsyncAgiEvent)event);
        } else if (event instanceof RenameEvent) {
            this.handleRenameEvent((RenameEvent)event);
        }
    }

    private void handleAsyncAgiEvent(AsyncAgiEvent asyncAgiEvent) {
        ManagerConnection connection = (ManagerConnection)asyncAgiEvent.getSource();
        String channelName = asyncAgiEvent.getChannel();
        if (asyncAgiEvent.isStart()) {
            AsyncAgiConnectionHandler connectionHandler = new AsyncAgiConnectionHandler(this.getMappingStrategy(), asyncAgiEvent);
            this.setConnectionHandler(connection, channelName, connectionHandler);
            this.execute(connectionHandler);
        } else {
            AsyncAgiConnectionHandler connectionHandler = this.getConnectionHandler(connection, channelName);
            if (connectionHandler == null) {
                this.logger.info("No AsyncAgiConnectionHandler registered for channel " + channelName + ": Ignoring AsyncAgiEvent");
                return;
            }
            if (asyncAgiEvent.isExec()) {
                connectionHandler.onAsyncAgiExecEvent(asyncAgiEvent);
            } else if (asyncAgiEvent.isEnd()) {
                connectionHandler.onAsyncAgiEndEvent(asyncAgiEvent);
                this.removeConnectionHandler(connection, channelName);
            } else {
                this.logger.warn("Ignored unknown AsyncAgiEvent of sub type '" + asyncAgiEvent.getSubEvent() + "'");
            }
        }
    }

    private void handleRenameEvent(RenameEvent renameEvent) {
        ManagerConnection connection = (ManagerConnection)renameEvent.getSource();
        AsyncAgiConnectionHandler connectionHandler = this.getConnectionHandler(connection, renameEvent.getChannel());
        if (connectionHandler == null) {
            return;
        }
        this.removeConnectionHandler(connection, renameEvent.getChannel());
        this.setConnectionHandler(connection, renameEvent.getNewname(), connectionHandler);
        connectionHandler.updateChannelName(renameEvent.getNewname());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncAgiConnectionHandler getConnectionHandler(ManagerConnection connection, String channelName) {
        Map<Integer, AsyncAgiConnectionHandler> map = this.connectionHandlers;
        synchronized (map) {
            return this.connectionHandlers.get(this.calculateHashKey(connection, channelName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConnectionHandler(ManagerConnection connection, String channelName, AsyncAgiConnectionHandler connectionHandler) {
        Map<Integer, AsyncAgiConnectionHandler> map = this.connectionHandlers;
        synchronized (map) {
            this.connectionHandlers.put(this.calculateHashKey(connection, channelName), connectionHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnectionHandler(ManagerConnection connection, String channelName) {
        Map<Integer, AsyncAgiConnectionHandler> map = this.connectionHandlers;
        synchronized (map) {
            this.connectionHandlers.remove(this.calculateHashKey(connection, channelName));
        }
    }

    private Integer calculateHashKey(ManagerConnection connection, String channelName) {
        return connection.hashCode() * 31 + channelName.hashCode();
    }
}

