/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.type1;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.type1.PFMInputStream;
import org.apache.xmlgraphics.fonts.Glyphs;

public class PFMFile {
    private String windowsName;
    private String postscriptName;
    private short dfItalic;
    private int dfWeight;
    private short dfCharSet;
    private short dfPitchAndFamily;
    private int dfAvgWidth;
    private int dfMaxWidth;
    private int dfMinWidth;
    private short dfFirstChar;
    private short dfLastChar;
    private int etmCapHeight;
    private int etmXHeight;
    private int etmLowerCaseAscent;
    private int etmLowerCaseDescent;
    private int[] extentTable;
    private Map kerningTab = new HashMap();
    protected Log log = LogFactory.getLog((Class)PFMFile.class);

    public void load(InputStream inStream) throws IOException {
        byte[] pfmBytes = IOUtils.toByteArray((InputStream)inStream);
        InputStream bufin = inStream;
        bufin = new ByteArrayInputStream(pfmBytes);
        PFMInputStream in = new PFMInputStream(bufin);
        bufin.mark(512);
        short sh1 = in.readByte();
        short sh2 = in.readByte();
        if (sh1 == 128 && sh2 == 1) {
            throw new IOException("Cannot parse PFM file. You probably specified the PFB file of a Type 1 font as parameter instead of the PFM.");
        }
        bufin.reset();
        byte[] b = new byte[16];
        bufin.read(b);
        if (new String(b, "US-ASCII").equalsIgnoreCase("StartFontMetrics")) {
            throw new IOException("Cannot parse PFM file. You probably specified the AFM file of a Type 1 font as parameter instead of the PFM.");
        }
        bufin.reset();
        int version = in.readShort();
        if (version != 256) {
            this.log.warn((Object)("PFM version expected to be '256' but got '" + version + "'." + " Please make sure you specify the PFM as parameter" + " and not the PFB or the AFM."));
        }
        bufin.reset();
        this.loadHeader(in);
        this.loadExtension(in);
    }

    private void loadHeader(PFMInputStream inStream) throws IOException {
        inStream.skip(80L);
        this.dfItalic = inStream.readByte();
        inStream.skip(2L);
        this.dfWeight = inStream.readShort();
        this.dfCharSet = inStream.readByte();
        inStream.skip(4L);
        this.dfPitchAndFamily = inStream.readByte();
        this.dfAvgWidth = inStream.readShort();
        this.dfMaxWidth = inStream.readShort();
        this.dfFirstChar = inStream.readByte();
        this.dfLastChar = inStream.readByte();
        inStream.skip(8L);
        long faceOffset = inStream.readInt();
        inStream.reset();
        inStream.skip(faceOffset);
        this.windowsName = inStream.readString();
        inStream.reset();
        inStream.skip(117L);
    }

    private void loadExtension(PFMInputStream inStream) throws IOException {
        int size = inStream.readShort();
        if (size != 30) {
            this.log.warn((Object)("Size of extension block was expected to be 30 bytes, but was " + size + " bytes."));
        }
        long extMetricsOffset = inStream.readInt();
        long extentTableOffset = inStream.readInt();
        inStream.skip(4L);
        long kernPairOffset = inStream.readInt();
        inStream.skip(4L);
        long driverInfoOffset = inStream.readInt();
        if (kernPairOffset > 0L) {
            inStream.reset();
            inStream.skip(kernPairOffset);
            this.loadKernPairs(inStream);
        }
        inStream.reset();
        inStream.skip(driverInfoOffset);
        this.postscriptName = inStream.readString();
        if (extMetricsOffset != 0L) {
            inStream.reset();
            inStream.skip(extMetricsOffset);
            this.loadExtMetrics(inStream);
        }
        if (extentTableOffset != 0L) {
            inStream.reset();
            inStream.skip(extentTableOffset);
            this.loadExtentTable(inStream);
        }
    }

    private void loadKernPairs(PFMInputStream inStream) throws IOException {
        int i = inStream.readShort();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(i + " kerning pairs"));
        }
        while (i > 0) {
            HashMap<Integer, Integer> adjTab;
            short g1 = inStream.readByte();
            --i;
            short g2 = inStream.readByte();
            int adj = inStream.readShort();
            if (adj > 32768) {
                adj = -(65536 - adj);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Char no: (" + g1 + ", " + g2 + ") kern: " + adj));
                String glyph1 = Glyphs.TEX8R_GLYPH_NAMES[g1];
                String glyph2 = Glyphs.TEX8R_GLYPH_NAMES[g2];
                this.log.trace((Object)("glyphs: " + glyph1 + ", " + glyph2));
            }
            if ((adjTab = (HashMap<Integer, Integer>)this.kerningTab.get(new Integer(g1))) == null) {
                adjTab = new HashMap<Integer, Integer>();
            }
            adjTab.put(new Integer(g2), new Integer(adj));
            this.kerningTab.put(new Integer(g1), adjTab);
        }
    }

    private void loadExtMetrics(PFMInputStream inStream) throws IOException {
        int size = inStream.readShort();
        if (size != 52) {
            this.log.warn((Object)("Size of extension block was expected to be 52 bytes, but was " + size + " bytes."));
        }
        inStream.skip(12L);
        this.etmCapHeight = inStream.readShort();
        this.etmXHeight = inStream.readShort();
        this.etmLowerCaseAscent = inStream.readShort();
        this.etmLowerCaseDescent = -inStream.readShort();
    }

    private void loadExtentTable(PFMInputStream inStream) throws IOException {
        this.extentTable = new int[this.dfLastChar - this.dfFirstChar + 1];
        this.dfMinWidth = this.dfMaxWidth;
        for (short i = this.dfFirstChar; i <= this.dfLastChar; i = (short)(i + 1)) {
            this.extentTable[i - this.dfFirstChar] = inStream.readShort();
            if (this.extentTable[i - this.dfFirstChar] >= this.dfMinWidth) continue;
            this.dfMinWidth = this.extentTable[i - this.dfFirstChar];
        }
    }

    public String getWindowsName() {
        return this.windowsName;
    }

    public Map getKerning() {
        return this.kerningTab;
    }

    public String getPostscriptName() {
        return this.postscriptName;
    }

    public short getCharSet() {
        return this.dfCharSet;
    }

    public String getCharSetName() {
        switch (this.dfCharSet) {
            case 0: {
                return "WinAnsi";
            }
            case 2: {
                if (!"Symbol".equals(this.getPostscriptName())) break;
                return "Symbol";
            }
            case 128: {
                return "Shift-JIS (Japanese)";
            }
            default: {
                this.log.warn((Object)("Unknown charset detected (" + this.dfCharSet + ", 0x" + Integer.toHexString(this.dfCharSet) + "). Trying fallback to WinAnsi."));
            }
        }
        return "WinAnsi";
    }

    public short getFirstChar() {
        return this.dfFirstChar;
    }

    public short getLastChar() {
        return this.dfLastChar;
    }

    public int getCapHeight() {
        return this.etmCapHeight;
    }

    public int getXHeight() {
        return this.etmXHeight;
    }

    public int getLowerCaseAscent() {
        return this.etmLowerCaseAscent;
    }

    public int getLowerCaseDescent() {
        return this.etmLowerCaseDescent;
    }

    public boolean getIsProportional() {
        return (this.dfPitchAndFamily & 1) == 1;
    }

    public int[] getFontBBox() {
        int[] bbox = new int[]{!this.getIsProportional() && this.dfAvgWidth == this.dfMaxWidth ? -20 : -100, this.getLowerCaseDescent() - 5, this.dfMaxWidth + 10, this.getLowerCaseAscent() + 5};
        return bbox;
    }

    public boolean isNonSymbolic() {
        return this.dfCharSet != 2;
    }

    public int getFlags() {
        int flags = 0;
        if (!this.getIsProportional()) {
            flags |= 1;
        }
        flags = this.isNonSymbolic() ? (flags |= 0x20) : (flags |= 4);
        if ((this.dfPitchAndFamily & 0x10) != 0) {
            flags |= 2;
        }
        if ((this.dfPitchAndFamily & 0x40) != 0) {
            flags |= 8;
        }
        if (this.dfItalic != 0) {
            flags |= 0x40;
        }
        return flags;
    }

    public int getStemV() {
        if (this.dfItalic != 0) {
            return (int)Math.round((double)this.dfMinWidth * 0.25);
        }
        return (int)Math.round((double)this.dfMinWidth * 0.6);
    }

    public int getItalicAngle() {
        if (this.dfItalic != 0) {
            return -16;
        }
        return 0;
    }

    public int getCharWidth(short which) {
        return this.extentTable[which - this.dfFirstChar];
    }
}

