/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.fop.fo.flow.table.BorderResolver;
import org.apache.fop.fo.flow.table.ConditionalBorder;
import org.apache.fop.fo.flow.table.GridUnit;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableBody;
import org.apache.fop.fo.flow.table.TableCellContainer;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TableRow;

class CollapsingBorderResolver
implements BorderResolver {
    private Table table;
    private List previousRow;
    private boolean firstInTable;
    private List footerFirstRow;
    private List footerLastRow;
    private Resolver delegate;
    private Resolver resolverInBody = new ResolverInBody();
    private Resolver resolverInFooter;
    private List leadingBorders;
    private List trailingBorders;
    private List headerLastRow = null;
    static /* synthetic */ Class class$org$apache$fop$fo$flow$table$CollapsingBorderResolver;

    CollapsingBorderResolver(Table table) {
        this.table = table;
        this.firstInTable = true;
    }

    public void endRow(List row, TableCellContainer container) {
        this.delegate.endRow(row, container);
    }

    public void startPart(TableBody part) {
        if (part.isTableHeader()) {
            this.delegate = new ResolverInHeader();
        } else {
            ConditionalBorder border;
            Iterator colIter;
            if (this.leadingBorders == null || this.table.omitHeaderAtBreak()) {
                this.leadingBorders = new ArrayList(this.table.getNumberOfColumns());
                colIter = this.table.getColumns().iterator();
                while (colIter.hasNext()) {
                    border = ((TableColumn)colIter.next()).borderBefore;
                    border.leadingTrailing = border.rest;
                    this.leadingBorders.add(border);
                }
            }
            if (part.isTableFooter()) {
                this.delegate = this.resolverInFooter = new ResolverInFooter();
            } else {
                if (this.trailingBorders == null || this.table.omitFooterAtBreak()) {
                    this.trailingBorders = new ArrayList(this.table.getNumberOfColumns());
                    colIter = this.table.getColumns().iterator();
                    while (colIter.hasNext()) {
                        border = ((TableColumn)colIter.next()).borderAfter;
                        border.leadingTrailing = border.rest;
                        this.trailingBorders.add(border);
                    }
                }
                this.delegate = this.resolverInBody;
            }
        }
        this.delegate.startPart(part);
    }

    public void endPart() {
        this.delegate.endPart();
    }

    public void endTable() {
        GridUnit gu;
        Iterator iter;
        this.delegate.endTable();
        this.delegate = null;
        if (this.headerLastRow != null) {
            iter = this.headerLastRow.iterator();
            while (iter.hasNext()) {
                gu = (GridUnit)iter.next();
                gu.borderAfter.leadingTrailing = gu.borderAfter.nonLeadingTrailing;
            }
        }
        if (this.footerLastRow != null) {
            iter = this.footerLastRow.iterator();
            while (iter.hasNext()) {
                gu = (GridUnit)iter.next();
                gu.borderAfter.leadingTrailing = gu.borderAfter.nonLeadingTrailing;
            }
        }
    }

    private class ResolverInBody
    extends Resolver {
        private boolean firstInBody;

        private ResolverInBody() {
            this.firstInBody = true;
        }

        void endRow(List row, TableCellContainer container) {
            super.endRow(row, container);
            if (CollapsingBorderResolver.this.firstInTable) {
                this.resolveBordersFirstRowInTable(row, true, true, true);
            } else {
                this.resolveBordersBetweenRows(CollapsingBorderResolver.this.previousRow, row);
                this.integrateLeadingBorders(row);
            }
            this.integrateTrailingBorders(row);
            CollapsingBorderResolver.this.previousRow = row;
            if (this.firstInBody) {
                this.firstInBody = false;
                Iterator iter = row.iterator();
                while (iter.hasNext()) {
                    GridUnit gu = (GridUnit)iter.next();
                    gu.borderBefore.leadingTrailing = gu.borderBefore.nonLeadingTrailing;
                }
            }
        }

        void endTable() {
            if (CollapsingBorderResolver.this.resolverInFooter != null) {
                CollapsingBorderResolver.this.resolverInFooter.endTable();
            } else {
                this.resolveBordersLastRowInTable(CollapsingBorderResolver.this.previousRow, false, true, false);
            }
            Iterator iter = CollapsingBorderResolver.this.previousRow.iterator();
            while (iter.hasNext()) {
                GridUnit gu = (GridUnit)iter.next();
                gu.borderAfter.leadingTrailing = gu.borderAfter.nonLeadingTrailing;
            }
        }
    }

    private class ResolverInFooter
    extends Resolver {
        private ResolverInFooter() {
        }

        void endRow(List row, TableCellContainer container) {
            super.endRow(row, container);
            if (CollapsingBorderResolver.this.footerFirstRow == null) {
                CollapsingBorderResolver.this.footerFirstRow = row;
            } else {
                this.resolveBordersBetweenRows(CollapsingBorderResolver.this.footerLastRow, row);
            }
            CollapsingBorderResolver.this.footerLastRow = row;
        }

        void endPart() {
            this.resolveBordersLastRowInPart(CollapsingBorderResolver.this.footerLastRow, true, true, true);
            CollapsingBorderResolver.this.trailingBorders = new ArrayList(CollapsingBorderResolver.this.table.getNumberOfColumns());
            Iterator guIter = CollapsingBorderResolver.this.footerFirstRow.iterator();
            while (guIter.hasNext()) {
                ConditionalBorder borderBefore = ((GridUnit)guIter.next()).borderBefore;
                borderBefore.leadingTrailing = borderBefore.nonLeadingTrailing;
                borderBefore.rest = borderBefore.nonLeadingTrailing;
                CollapsingBorderResolver.this.trailingBorders.add(borderBefore);
            }
        }

        void endTable() {
            this.resolveBordersBetweenRows(CollapsingBorderResolver.this.previousRow, CollapsingBorderResolver.this.footerFirstRow);
            Iterator guIter = CollapsingBorderResolver.this.footerLastRow.iterator();
            while (guIter.hasNext()) {
                ConditionalBorder borderAfter = ((GridUnit)guIter.next()).borderAfter;
                borderAfter.leadingTrailing = borderAfter.nonLeadingTrailing;
                borderAfter.rest = borderAfter.nonLeadingTrailing;
            }
            this.resolveBordersLastRowInTable(CollapsingBorderResolver.this.footerLastRow, false, true, true);
        }
    }

    private class ResolverInHeader
    extends Resolver {
        private ResolverInHeader() {
        }

        void endRow(List row, TableCellContainer container) {
            super.endRow(row, container);
            if (CollapsingBorderResolver.this.previousRow != null) {
                this.resolveBordersBetweenRows(CollapsingBorderResolver.this.previousRow, row);
            } else {
                Iterator guIter = row.iterator();
                while (guIter.hasNext()) {
                    ConditionalBorder borderBefore = ((GridUnit)guIter.next()).borderBefore;
                    borderBefore.leadingTrailing = borderBefore.nonLeadingTrailing;
                    borderBefore.rest = borderBefore.nonLeadingTrailing;
                }
                this.resolveBordersFirstRowInTable(row, false, true, true);
            }
            CollapsingBorderResolver.this.previousRow = row;
        }

        void endPart() {
            super.endPart();
            CollapsingBorderResolver.this.leadingBorders = new ArrayList(CollapsingBorderResolver.this.table.getNumberOfColumns());
            Iterator guIter = CollapsingBorderResolver.this.previousRow.iterator();
            while (guIter.hasNext()) {
                ConditionalBorder borderAfter = ((GridUnit)guIter.next()).borderAfter;
                borderAfter.leadingTrailing = borderAfter.nonLeadingTrailing;
                borderAfter.rest = borderAfter.nonLeadingTrailing;
                CollapsingBorderResolver.this.leadingBorders.add(borderAfter);
            }
            CollapsingBorderResolver.this.headerLastRow = CollapsingBorderResolver.this.previousRow;
        }

        void endTable() {
            throw new IllegalStateException();
        }
    }

    private abstract class Resolver {
        protected TableBody tablePart;
        protected boolean firstInPart;
        static final /* synthetic */ boolean $assertionsDisabled;

        private Resolver() {
        }

        void resolveBordersFirstRowInTable(List row, boolean withLeadingTrailing, boolean withNonLeadingTrailing, boolean withRest) {
            if (!$assertionsDisabled && !CollapsingBorderResolver.this.firstInTable) {
                throw new AssertionError();
            }
            for (int i = 0; i < row.size(); ++i) {
                TableColumn column = CollapsingBorderResolver.this.table.getColumn(i);
                ((GridUnit)row.get(i)).integrateBorderSegment(0, column, withLeadingTrailing, withNonLeadingTrailing, withRest);
            }
            CollapsingBorderResolver.this.firstInTable = false;
        }

        void resolveBordersBetweenRows(List rowBefore, List rowAfter) {
            if (!($assertionsDisabled || rowBefore != null && rowAfter != null)) {
                throw new AssertionError();
            }
            for (int i = 0; i < rowAfter.size(); ++i) {
                GridUnit gu = (GridUnit)rowAfter.get(i);
                if (gu.getRowSpanIndex() != 0) continue;
                GridUnit beforeGU = (GridUnit)rowBefore.get(i);
                gu.resolveBorder(beforeGU, 0);
            }
        }

        void resolveBordersLastRowInPart(List row, boolean withLeadingTrailing, boolean withNonLeadingTrailing, boolean withRest) {
            for (int i = 0; i < row.size(); ++i) {
                ((GridUnit)row.get(i)).integrateBorderSegment(1, this.tablePart, withLeadingTrailing, withNonLeadingTrailing, withRest);
            }
        }

        void resolveBordersLastRowInTable(List row, boolean withLeadingTrailing, boolean withNonLeadingTrailing, boolean withRest) {
            for (int i = 0; i < row.size(); ++i) {
                TableColumn column = CollapsingBorderResolver.this.table.getColumn(i);
                ((GridUnit)row.get(i)).integrateBorderSegment(1, column, withLeadingTrailing, withNonLeadingTrailing, withRest);
            }
        }

        void integrateLeadingBorders(List row) {
            for (int i = 0; i < CollapsingBorderResolver.this.table.getNumberOfColumns(); ++i) {
                GridUnit gu = (GridUnit)row.get(i);
                ConditionalBorder border = (ConditionalBorder)CollapsingBorderResolver.this.leadingBorders.get(i);
                gu.integrateCompetingBorder(0, border, true, false, true);
            }
        }

        void integrateTrailingBorders(List row) {
            for (int i = 0; i < CollapsingBorderResolver.this.table.getNumberOfColumns(); ++i) {
                GridUnit gu = (GridUnit)row.get(i);
                ConditionalBorder border = (ConditionalBorder)CollapsingBorderResolver.this.trailingBorders.get(i);
                gu.integrateCompetingBorder(1, border, true, false, true);
            }
        }

        void startPart(TableBody part) {
            this.tablePart = part;
            this.firstInPart = true;
        }

        void endRow(List row, TableCellContainer container) {
            if (container instanceof TableRow) {
                TableRow tableRow = (TableRow)container;
                Iterator iter = row.iterator();
                while (iter.hasNext()) {
                    GridUnit gu = (GridUnit)iter.next();
                    boolean first = gu.getRowSpanIndex() == 0;
                    boolean last = gu.isLastGridUnitRowSpan();
                    gu.integrateBorderSegment(0, tableRow, first, first, true);
                    gu.integrateBorderSegment(1, tableRow, last, last, true);
                }
            }
            if (this.firstInPart) {
                for (int i = 0; i < row.size(); ++i) {
                    ((GridUnit)row.get(i)).integrateBorderSegment(0, this.tablePart, true, true, true);
                }
                this.firstInPart = false;
            }
            Iterator guIter = row.iterator();
            GridUnit gu = (GridUnit)guIter.next();
            Iterator colIter = CollapsingBorderResolver.this.table.getColumns().iterator();
            TableColumn col = (TableColumn)colIter.next();
            gu.integrateBorderSegment(2, col);
            gu.integrateBorderSegment(2, container);
            while (guIter.hasNext()) {
                GridUnit nextGU = (GridUnit)guIter.next();
                TableColumn nextCol = (TableColumn)colIter.next();
                if (gu.isLastGridUnitColSpan()) {
                    gu.integrateBorderSegment(3, col);
                    nextGU.integrateBorderSegment(2, nextCol);
                    gu.resolveBorder(nextGU, 3);
                }
                gu = nextGU;
                col = nextCol;
            }
            gu.integrateBorderSegment(3, col);
            gu.integrateBorderSegment(3, container);
        }

        void endPart() {
            this.resolveBordersLastRowInPart(CollapsingBorderResolver.this.previousRow, true, true, true);
        }

        abstract void endTable();

        static {
            $assertionsDisabled = !(class$org$apache$fop$fo$flow$table$CollapsingBorderResolver == null ? (class$org$apache$fop$fo$flow$table$CollapsingBorderResolver = CollapsingBorderResolver.class$("org.apache.fop.fo.flow.table.CollapsingBorderResolver")) : class$org$apache$fop$fo$flow$table$CollapsingBorderResolver).desiredAssertionStatus();
        }
    }
}

