/*
 * Decompiled with CFR 0.152.
 */
package simple.http.session;

import java.util.HashMap;
import java.util.Map;
import simple.http.session.Module;
import simple.http.session.ModuleFactory;
import simple.http.session.StoreException;
import simple.util.lease.Cleaner;
import simple.util.net.Cookie;

final class Registry
implements Cleaner {
    private ModuleFactory factory = new ModuleFactory(this);
    private Map registry;

    public Registry() {
        this(new HashMap());
    }

    public Registry(Map registry) {
        this.registry = registry;
    }

    public synchronized Module lookup(Cookie cookie) {
        return this.lookup(cookie, null);
    }

    public synchronized Module lookup(Cookie cookie, Object data) {
        String name = cookie.getValue();
        Object module = this.registry.get(name);
        if (module == null) {
            module = this.create(cookie, data);
            this.registry.put(name, module);
        }
        return (Module)module;
    }

    private synchronized Module create(Cookie cookie, Object data) {
        return this.factory.getInstance(cookie, data);
    }

    private synchronized Module remove(String name) {
        return (Module)this.registry.remove(name);
    }

    public synchronized void clean(String name) {
        Module module = this.remove(name);
        try {
            module.getStore().destroy();
        }
        catch (StoreException e) {
            return;
        }
    }
}

