/*
 * Decompiled with CFR 0.152.
 */
package simple.http.load;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.Vector;
import simple.http.load.LoadingException;
import simple.http.load.Service;
import simple.http.serve.Context;

final class Registry {
    private ClassLoader loader = Registry.class.getClassLoader();
    private Hashtable loaded = new Hashtable();
    private Context context;
    private URL[] codebase;
    private Vector classes;
    private Vector names = new Vector();

    public Registry(Context context, URL[] codebase) {
        this.classes = new Vector();
        this.codebase = codebase;
        this.context = context;
    }

    public Service load(String name, String className) throws LoadingException {
        try {
            this.loaded.put(name, this.load(className));
            this.names.add(name);
            this.classes.add(className);
            return this.retrieve(name);
        }
        catch (Exception cause) {
            throw new LoadingException(cause);
        }
    }

    private Object load(String className) throws Exception {
        Class[] types = new Class[]{Context.class};
        Class<?> type = this.getClassLoader().loadClass(className);
        Constructor<?> target = type.getDeclaredConstructor(types);
        return target.newInstance(this.context);
    }

    private ClassLoader getClassLoader() throws Exception {
        return this.getClassLoader(this.loader);
    }

    private ClassLoader getClassLoader(ClassLoader parent) throws Exception {
        return new URLClassLoader(this.codebase, parent);
    }

    public String[] getClassNames() {
        String[] list = new String[this.names.size()];
        return this.classes.toArray(list);
    }

    public String[] getNames() {
        String[] list = new String[this.names.size()];
        return this.names.toArray(list);
    }

    public Service retrieve(String name) {
        return (Service)this.loaded.get(name);
    }

    public boolean contains(String name) {
        return name != null && this.loaded.containsKey(name);
    }

    public void remove(String name) {
        int pos = this.names.indexOf(name);
        if (pos >= 0) {
            this.classes.removeElementAt(pos);
            this.names.removeElementAt(pos);
        }
        this.loaded.remove(name);
    }
}

