/*
 * Decompiled with CFR 0.152.
 */
package simple.http;

import java.io.IOException;
import java.lang.reflect.Constructor;
import simple.http.DefaultPoller;
import simple.http.Pipeline;
import simple.http.Poller;

final class PollerFactory {
    private static Constructor factory;

    static {
        try {
            factory = PollerFactory.getConstructor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    PollerFactory() {
    }

    public static Poller getInstance(Pipeline pipe) throws IOException {
        if (factory == null) {
            return new DefaultPoller(pipe);
        }
        try {
            return PollerFactory.getInstance(new Object[]{pipe});
        }
        catch (Exception e) {
            return new DefaultPoller(pipe);
        }
    }

    private static Poller getInstance(Object[] list) throws Exception {
        return (Poller)factory.newInstance(list);
    }

    private static Constructor getConstructor() throws Exception {
        String property = "simple.http.poller";
        String className = System.getProperty(property);
        if (className != null) {
            return PollerFactory.getConstructor(className);
        }
        return null;
    }

    private static Constructor getConstructor(String className) throws Exception {
        return PollerFactory.getConstructor(Class.forName(className, false, PollerFactory.class.getClassLoader()));
    }

    private static Constructor getConstructor(Class type) throws Exception {
        Class[] types = new Class[]{Pipeline.class};
        return type.getDeclaredConstructor(types);
    }
}

