/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.importer.specification;

import java.io.IOException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.modelimport.Asset;
import org.opennms.netmgt.config.modelimport.Category;
import org.opennms.netmgt.config.modelimport.Interface;
import org.opennms.netmgt.config.modelimport.ModelImport;
import org.opennms.netmgt.config.modelimport.MonitoredService;
import org.opennms.netmgt.config.modelimport.Node;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.importer.ModelImportException;
import org.opennms.netmgt.importer.specification.ImportVisitor;
import org.springframework.core.io.Resource;

public class SpecFile {
    private ModelImport m_mi;

    public void loadResource(Resource resource) throws ModelImportException, IOException {
        try {
            this.m_mi = (ModelImport)CastorUtils.unmarshal(ModelImport.class, (Resource)resource);
        }
        catch (MarshalException e) {
            throw new ModelImportException("Exception while marshalling import: " + (Object)((Object)e), e);
        }
        catch (ValidationException e) {
            throw new ModelImportException("Exception while validating import " + (Object)((Object)e));
        }
    }

    public void visitImport(ImportVisitor visitor) {
        this.doVisitImport(visitor);
    }

    private void doVisitImport(ImportVisitor visitor) {
        visitor.visitModelImport(this.m_mi);
        for (Node node : this.m_mi.getNodeCollection()) {
            this.visitNode(visitor, node);
        }
        visitor.completeModelImport(this.m_mi);
    }

    private void visitNode(ImportVisitor visitor, Node node) {
        this.doVisitNode(visitor, node);
    }

    private void doVisitNode(ImportVisitor visitor, Node node) {
        visitor.visitNode(node);
        for (Category category : node.getCategoryCollection()) {
            this.visitCategory(visitor, category);
        }
        for (Interface iface : node.getInterfaceCollection()) {
            this.visitInterface(visitor, iface);
        }
        for (Asset asset : node.getAssetCollection()) {
            this.visitAsset(visitor, asset);
        }
        visitor.completeNode(node);
    }

    private void visitAsset(ImportVisitor visitor, Asset asset) {
        this.doVisitAsset(visitor, asset);
    }

    private void doVisitAsset(ImportVisitor visitor, Asset asset) {
        visitor.visitAsset(asset);
        visitor.completeAsset(asset);
    }

    private void visitCategory(ImportVisitor visitor, Category category) {
        this.doVisitCategory(visitor, category);
    }

    private void doVisitCategory(ImportVisitor visitor, Category category) {
        visitor.visitCategory(category);
        visitor.completeCategory(category);
    }

    private void visitInterface(ImportVisitor visitor, Interface iface) {
        this.doVisitInterface(visitor, iface);
    }

    private void doVisitInterface(ImportVisitor visitor, Interface iface) {
        visitor.visitInterface(iface);
        for (MonitoredService svc : iface.getMonitoredServiceCollection()) {
            this.visitMonitoredService(visitor, svc);
        }
        visitor.completeInterface(iface);
    }

    private void visitMonitoredService(ImportVisitor visitor, MonitoredService svc) {
        this.doVisitMonitoredService(visitor, svc);
    }

    private void doVisitMonitoredService(ImportVisitor visitor, MonitoredService svc) {
        visitor.visitMonitoredService(svc);
        visitor.completeMonitoredService(svc);
    }

    public String getForeignSource() {
        return this.m_mi.getForeignSource();
    }

    public void setForeignSource(String foreignSource) {
        this.m_mi.setForeignSource(foreignSource);
    }
}

