/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.importer.operations;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.netmgt.importer.operations.AbstractSaveOrUpdateOperation;
import org.opennms.netmgt.importer.operations.AddEventVisitor;
import org.opennms.netmgt.importer.operations.DeleteEventVisitor;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.xml.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateOperation
extends AbstractSaveOrUpdateOperation {
    public UpdateOperation(Integer nodeId, String foreignSource, String foreignId, String nodeLabel, String building, String city) {
        super(nodeId, foreignSource, foreignId, nodeLabel, building, city);
    }

    @Override
    public List<Event> doPersist() {
        OnmsNode imported = this.getNode();
        OnmsNode db = this.getNodeDao().getHierarchy(imported.getId());
        LinkedList<Event> events = new LinkedList<Event>();
        if (!db.getLabel().equals(imported.getLabel())) {
            db.setLabel(imported.getLabel());
        }
        if (!this.nullSafeEquals(db.getForeignSource(), imported.getForeignSource())) {
            db.setForeignSource(imported.getForeignSource());
        }
        if (!this.nullSafeEquals(db.getForeignId(), imported.getForeignId())) {
            db.setForeignId(imported.getForeignId());
        }
        if (this.isSnmpDataForNodeUpToDate()) {
            if (!this.nullSafeEquals(db.getSysContact(), imported.getSysContact())) {
                db.setSysContact(imported.getSysContact());
            }
            if (!this.nullSafeEquals(db.getSysDescription(), imported.getSysDescription())) {
                db.setSysDescription(imported.getSysDescription());
            }
            if (!this.nullSafeEquals(db.getSysLocation(), imported.getSysLocation())) {
                db.setSysLocation(imported.getSysLocation());
            }
            if (!this.nullSafeEquals(db.getSysName(), imported.getSysName())) {
                db.setSysName(imported.getSysName());
            }
            if (!this.nullSafeEquals(db.getSysObjectId(), imported.getSysObjectId())) {
                db.setSysObjectId(imported.getSysObjectId());
            }
        }
        if (this.isSnmpDataForInterfacesUpToDate()) {
            this.updateSnmpInterfaces(db, imported);
        }
        this.updateInterfaces(db, imported, events);
        this.updateCategories(db, imported);
        this.getNodeDao().update((Object)db);
        return events;
    }

    private void updateSnmpInterfaces(OnmsNode db, OnmsNode imported) {
        new SnmpInterfaceUpdater(db, imported).execute();
    }

    private void updateCategories(OnmsNode db, OnmsNode imported) {
        if (!((Object)db.getCategories()).equals(imported.getCategories())) {
            db.setCategories(imported.getCategories());
        }
    }

    private void updateInterfaces(OnmsNode db, OnmsNode imported, List<Event> events) {
        new InterfaceUpdater(db, imported).execute(events);
    }

    public String toString() {
        return "UPDATE: Node: " + this.getNode().getId() + ": " + this.getNode().getLabel();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SnmpInterfaceUpdater {
        OnmsNode m_dbNode;
        Map<Integer, OnmsSnmpInterface> m_ifIndexToSnmpInterface;

        public SnmpInterfaceUpdater(OnmsNode db, OnmsNode imported) {
            this.m_dbNode = db;
            this.m_ifIndexToSnmpInterface = this.mapIfIndexToSnmpInterface(imported.getSnmpInterfaces());
        }

        private Map<Integer, OnmsSnmpInterface> mapIfIndexToSnmpInterface(Set<OnmsSnmpInterface> snmpInterfaces) {
            HashMap<Integer, OnmsSnmpInterface> map = new HashMap<Integer, OnmsSnmpInterface>();
            for (OnmsSnmpInterface snmpIface : snmpInterfaces) {
                if (snmpIface.getIfIndex() == null) continue;
                map.put(snmpIface.getIfIndex(), snmpIface);
            }
            return map;
        }

        public void execute() {
            Iterator<OnmsSnmpInterface> it = this.getExistingInterfaces().iterator();
            while (it.hasNext()) {
                OnmsSnmpInterface iface = it.next();
                OnmsSnmpInterface imported = this.getImportedVersion(iface);
                if (imported == null) {
                    it.remove();
                    this.markAsProcessed(iface);
                    continue;
                }
                this.update(imported, iface);
                this.markAsProcessed(iface);
            }
            this.addNewInterfaces();
        }

        private void update(OnmsSnmpInterface importedSnmpIface, OnmsSnmpInterface snmpIface) {
            if (!UpdateOperation.this.nullSafeEquals(snmpIface.getIfAdminStatus(), importedSnmpIface.getIfAdminStatus())) {
                snmpIface.setIfAdminStatus(importedSnmpIface.getIfAdminStatus());
            }
            if (!UpdateOperation.this.nullSafeEquals(snmpIface.getIfAlias(), importedSnmpIface.getIfAlias())) {
                snmpIface.setIfAlias(importedSnmpIface.getIfAlias());
            }
            if (!UpdateOperation.this.nullSafeEquals(snmpIface.getIfDescr(), importedSnmpIface.getIfDescr())) {
                snmpIface.setIfDescr(importedSnmpIface.getIfDescr());
            }
            if (!UpdateOperation.this.nullSafeEquals(snmpIface.getIfName(), importedSnmpIface.getIfName())) {
                snmpIface.setIfName(importedSnmpIface.getIfName());
            }
            if (!UpdateOperation.this.nullSafeEquals(snmpIface.getIfOperStatus(), importedSnmpIface.getIfOperStatus())) {
                snmpIface.setIfOperStatus(importedSnmpIface.getIfOperStatus());
            }
            if (!UpdateOperation.this.nullSafeEquals(snmpIface.getIfSpeed(), importedSnmpIface.getIfSpeed())) {
                snmpIface.setIfSpeed(importedSnmpIface.getIfSpeed());
            }
            if (!UpdateOperation.this.nullSafeEquals(snmpIface.getIfType(), importedSnmpIface.getIfType())) {
                snmpIface.setIfType(importedSnmpIface.getIfType());
            }
            if (!UpdateOperation.this.nullSafeEquals(snmpIface.getIpAddress(), importedSnmpIface.getIpAddress())) {
                snmpIface.setIpAddress(importedSnmpIface.getIpAddress());
            }
            if (!UpdateOperation.this.nullSafeEquals(snmpIface.getNetMask(), importedSnmpIface.getNetMask())) {
                snmpIface.setNetMask(importedSnmpIface.getNetMask());
            }
            if (!UpdateOperation.this.nullSafeEquals(snmpIface.getPhysAddr(), importedSnmpIface.getPhysAddr())) {
                snmpIface.setPhysAddr(importedSnmpIface.getPhysAddr());
            }
        }

        private void markAsProcessed(OnmsSnmpInterface iface) {
            this.m_ifIndexToSnmpInterface.remove(iface.getIfIndex());
        }

        private OnmsSnmpInterface getImportedVersion(OnmsSnmpInterface iface) {
            return this.m_ifIndexToSnmpInterface.get(iface.getIfIndex());
        }

        private Set<OnmsSnmpInterface> getExistingInterfaces() {
            return this.m_dbNode.getSnmpInterfaces();
        }

        private void addNewInterfaces() {
            for (OnmsSnmpInterface snmpIface : this.getNewInterfaces()) {
                this.m_dbNode.addSnmpInterface(snmpIface);
            }
        }

        private Collection<OnmsSnmpInterface> getNewInterfaces() {
            return this.m_ifIndexToSnmpInterface.values();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class InterfaceUpdater {
        private OnmsNode m_node;
        private Map<String, OnmsIpInterface> m_ipAddrToImportIfs;

        public InterfaceUpdater(OnmsNode node, OnmsNode imported) {
            this.m_node = node;
            this.m_ipAddrToImportIfs = UpdateOperation.this.getIpAddrToInterfaceMap(imported);
        }

        public void execute(List<Event> events) {
            Iterator<OnmsIpInterface> it = this.getExistingInterfaces().iterator();
            while (it.hasNext()) {
                OnmsIpInterface iface = it.next();
                OnmsIpInterface imported = this.getImportedVersion(iface);
                if (imported == null) {
                    it.remove();
                    iface.visit((EntityVisitor)new DeleteEventVisitor(events));
                    this.markAsProcessed(iface);
                    continue;
                }
                this.update(imported, iface, events);
                this.markAsProcessed(iface);
            }
            this.addNewInterfaces(events);
        }

        private void addNewInterfaces(List<Event> events) {
            for (OnmsIpInterface iface : this.getNewInterfaces()) {
                this.m_node.addIpInterface(iface);
                if (iface.getIfIndex() != null) {
                    iface.setSnmpInterface(this.m_node.getSnmpInterfaceWithIfIndex(iface.getIfIndex().intValue()));
                }
                iface.visit((EntityVisitor)new AddEventVisitor(events));
            }
        }

        private OnmsIpInterface getImportedVersion(OnmsIpInterface iface) {
            return this.m_ipAddrToImportIfs.get(iface.getIpAddress());
        }

        private Collection<OnmsIpInterface> getNewInterfaces() {
            return this.m_ipAddrToImportIfs.values();
        }

        private void markAsProcessed(OnmsIpInterface iface) {
            this.m_ipAddrToImportIfs.remove(iface.getIpAddress());
        }

        private void update(OnmsIpInterface imported, OnmsIpInterface iface, List<Event> events) {
            if (!UpdateOperation.this.nullSafeEquals(iface.getIsManaged(), imported.getIsManaged())) {
                iface.setIsManaged(imported.getIsManaged());
            }
            if (!UpdateOperation.this.nullSafeEquals(iface.getIsSnmpPrimary(), imported.getIsSnmpPrimary())) {
                iface.setIsSnmpPrimary(imported.getIsSnmpPrimary());
            }
            if (UpdateOperation.this.isSnmpDataForInterfacesUpToDate()) {
                this.updateSnmpInterface(imported, iface);
            }
            if (!UpdateOperation.this.nullSafeEquals(iface.getIpHostName(), imported.getIpHostName())) {
                iface.setIpHostName(imported.getIpHostName());
            }
            this.updateServices(iface, imported, events);
        }

        private void updateSnmpInterface(OnmsIpInterface imported, OnmsIpInterface iface) {
            if (UpdateOperation.this.nullSafeEquals(iface.getIfIndex(), imported.getIfIndex())) {
                return;
            }
            if (imported.getSnmpInterface() == null) {
                iface.setSnmpInterface(null);
            } else {
                OnmsSnmpInterface snmpIface = this.m_node.getSnmpInterfaceWithIfIndex(imported.getIfIndex().intValue());
                iface.setSnmpInterface(snmpIface);
            }
        }

        private void updateServices(OnmsIpInterface iface, OnmsIpInterface imported, List<Event> events) {
            new ServiceUpdater(iface, imported).execute(events);
        }

        private Set<OnmsIpInterface> getExistingInterfaces() {
            return this.m_node.getIpInterfaces();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ServiceUpdater {
        private OnmsIpInterface m_iface;
        Map<OnmsServiceType, OnmsMonitoredService> m_svcTypToSvcMap;

        public ServiceUpdater(OnmsIpInterface iface, OnmsIpInterface imported) {
            this.m_iface = iface;
            this.createSvcTypeToSvcMap(imported);
        }

        private void createSvcTypeToSvcMap(OnmsIpInterface imported) {
            this.m_svcTypToSvcMap = new HashMap<OnmsServiceType, OnmsMonitoredService>();
            for (OnmsMonitoredService svc : imported.getMonitoredServices()) {
                this.m_svcTypToSvcMap.put(svc.getServiceType(), svc);
            }
        }

        public void execute(List<Event> events) {
            Iterator<OnmsMonitoredService> it = this.getExisting().iterator();
            while (it.hasNext()) {
                OnmsMonitoredService svc = it.next();
                OnmsMonitoredService imported = this.getImportedVersion(svc);
                if (imported == null) {
                    it.remove();
                    svc.visit((EntityVisitor)new DeleteEventVisitor(events));
                } else {
                    this.update(svc, events);
                }
                this.markAsProcessed(svc);
            }
            this.addNewServices(events);
        }

        private void addNewServices(List<Event> events) {
            Collection<OnmsMonitoredService> newServices = this.getNewServices();
            UpdateOperation.this.log().debug(UpdateOperation.this.getNode().getLabel() + " has " + newServices.size() + " new services.");
            for (OnmsMonitoredService svc : newServices) {
                svc.setIpInterface(this.m_iface);
                this.m_iface.getMonitoredServices().add(svc);
                svc.visit((EntityVisitor)new AddEventVisitor(events));
            }
        }

        private Collection<OnmsMonitoredService> getNewServices() {
            return this.m_svcTypToSvcMap.values();
        }

        private void markAsProcessed(OnmsMonitoredService svc) {
            this.m_svcTypToSvcMap.remove(svc.getServiceType());
        }

        private void update(OnmsMonitoredService svc, List<Event> events) {
        }

        private OnmsMonitoredService getImportedVersion(OnmsMonitoredService svc) {
            return this.m_svcTypToSvcMap.get(svc.getServiceType());
        }

        Set<OnmsMonitoredService> getExisting() {
            return this.m_iface.getMonitoredServices();
        }
    }
}

