/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class StreamUtils {
    public static void streamToStream(Reader in, Writer out) throws IOException {
        StreamUtils.streamToStream(in, out, 1024);
    }

    public static void streamToStream(Reader in, Writer out, int bufferSize) throws IOException {
        int length;
        if (in == null || out == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Cannot take negative buffer size.");
        }
        char[] b = new char[bufferSize];
        while ((length = in.read(b)) != -1) {
            out.write(b, 0, length);
        }
    }

    public static void streamToStream(InputStream in, OutputStream out) throws IOException {
        StreamUtils.streamToStream(in, out, 1024);
    }

    public static void streamToStream(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int length;
        byte[] b = new byte[bufferSize];
        while ((length = in.read(b)) != -1) {
            out.write(b, 0, length);
        }
    }
}

