/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jradiusclient;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import net.sourceforge.jradiusclient.RadiusAttribute;
import net.sourceforge.jradiusclient.RadiusClient;
import net.sourceforge.jradiusclient.RadiusPacket;
import net.sourceforge.jradiusclient.exception.InvalidParameterException;
import net.sourceforge.jradiusclient.exception.RadiusException;
import net.sourceforge.jradiusclient.packets.AccountingRequest;
import net.sourceforge.jradiusclient.packets.ChapAccessRequest;
import net.sourceforge.jradiusclient.packets.PapAccessRequest;
import net.sourceforge.jradiusclient.util.ChapUtil;

public class TestRadiusClient {
    public static String getUsage() {
        return "usage: TestRadiusClient -s RadiusServer -S sharedSecret [--authPort=1812] [--acctPort=1813]";
    }

    public static void main(String[] stringArray) {
        int n;
        int n2 = 1812;
        int n3 = 1813;
        String string = "localhost";
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        LongOpt[] longOptArray = new LongOpt[]{new LongOpt("authPort", 1, stringBuffer, 1), new LongOpt("acctPort", 1, stringBuffer, 2)};
        Getopt getopt = new Getopt("TestRadiusClient", stringArray, "s:S:", longOptArray, false);
        getopt.setOpterr(true);
        while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 115: {
                    string = getopt.getOptarg();
                    break;
                }
                case 83: {
                    string2 = getopt.getOptarg();
                    break;
                }
                case 1: {
                    n2 = new Integer(stringBuffer.toString());
                    break;
                }
                case 2: {
                    n3 = new Integer(stringBuffer.toString());
                    break;
                }
                case 63: {
                    break;
                }
                default: {
                    System.err.println(TestRadiusClient.getUsage());
                }
            }
        }
        RadiusClient radiusClient = null;
        try {
            radiusClient = new RadiusClient(string, n2, n3, string2);
        }
        catch (RadiusException radiusException) {
            TestRadiusClient.log(radiusException.getMessage());
            TestRadiusClient.log(TestRadiusClient.getUsage());
            System.exit(4);
        }
        catch (InvalidParameterException invalidParameterException) {
            TestRadiusClient.log("Unable to create Radius Client due to invalid parameter!");
            TestRadiusClient.log(invalidParameterException.getMessage());
            TestRadiusClient.log(TestRadiusClient.getUsage());
            System.exit(5);
        }
        ChapUtil chapUtil = new ChapUtil();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        TestRadiusClient.basicAuthenticate(radiusClient, chapUtil, bufferedReader);
        TestRadiusClient.advAuthenticate(radiusClient, chapUtil, bufferedReader);
    }

    private static void basicAuthenticate(RadiusClient radiusClient, ChapUtil chapUtil, BufferedReader bufferedReader) {
        try {
            boolean bl = false;
            boolean bl2 = true;
            String string = null;
            String string2 = null;
            String string3 = null;
            System.out.println("Performing tests using basic classes: ");
            while (bl2) {
                Object object;
                bl = false;
                RadiusPacket radiusPacket = new RadiusPacket(1);
                System.out.print("Username: ");
                string = bufferedReader.readLine();
                RadiusAttribute radiusAttribute = new RadiusAttribute(1, string.getBytes());
                radiusPacket.setAttribute(radiusAttribute);
                System.out.print("Password: ");
                string2 = bufferedReader.readLine();
                System.out.print("Authentication method [PAP | chap]: ");
                string3 = bufferedReader.readLine();
                if (string3.equalsIgnoreCase("chap")) {
                    byte[] byArray = chapUtil.getNextChapChallenge(16);
                    radiusPacket.setAttribute(new RadiusAttribute(3, TestRadiusClient.chapEncrypt(string2, byArray, chapUtil)));
                    radiusPacket.setAttribute(new RadiusAttribute(60, byArray));
                } else {
                    radiusPacket.setAttribute(new RadiusAttribute(2, string2.getBytes()));
                }
                System.out.print("Additional Attributes? [y|N]:");
                boolean bl3 = bufferedReader.readLine().equalsIgnoreCase("y");
                while (bl3) {
                    System.out.print("Attribute Type:");
                    int n = Integer.parseInt(bufferedReader.readLine());
                    System.out.print("AttributeValue:");
                    object = bufferedReader.readLine().getBytes();
                    radiusPacket.setAttribute(new RadiusAttribute(n, (byte[])object));
                    System.out.print("Additional Attributes? [y|N]:");
                    boolean bl4 = bl3 = bufferedReader.readLine().equalsIgnoreCase("y");
                }
                RadiusPacket radiusPacket2 = radiusClient.authenticate(radiusPacket);
                switch (radiusPacket2.getPacketType()) {
                    case 2: {
                        TestRadiusClient.log("User " + string + " authenticated");
                        TestRadiusClient.printAttributes(radiusPacket2);
                        TestRadiusClient.basicAccount(radiusClient, string);
                        break;
                    }
                    case 3: {
                        TestRadiusClient.log("User " + string + " NOT authenticated");
                        TestRadiusClient.printAttributes(radiusPacket2);
                        break;
                    }
                    case 11: {
                        object = new String(radiusPacket2.getAttribute(18).getValue());
                        TestRadiusClient.log("User " + string + " Challenged with " + (String)object);
                        break;
                    }
                    default: {
                        TestRadiusClient.log("Whoa, what kind of RadiusPacket is this " + radiusPacket2.getPacketType());
                    }
                }
                System.out.print("Another Basic Test [ Y | n ]: ");
                string3 = bufferedReader.readLine();
                if (!string3.equalsIgnoreCase("n")) continue;
                bl2 = false;
            }
        }
        catch (InvalidParameterException invalidParameterException) {
            TestRadiusClient.log(invalidParameterException.getMessage());
        }
        catch (RadiusException radiusException) {
            TestRadiusClient.log(radiusException.getMessage());
        }
        catch (IOException iOException) {
            TestRadiusClient.log(iOException.getMessage());
        }
    }

    private static byte[] chapEncrypt(String string, byte[] byArray, ChapUtil chapUtil) {
        byte by = chapUtil.getNextChapIdentifier();
        byte[] byArray2 = new byte[17];
        byArray2[0] = by;
        System.arraycopy(ChapUtil.chapEncrypt(by, string.getBytes(), byArray), 0, byArray2, 1, 16);
        return byArray2;
    }

    private static void basicAccount(RadiusClient radiusClient, String string) throws InvalidParameterException, RadiusException {
        RadiusPacket radiusPacket = new RadiusPacket(4);
        radiusPacket.setAttribute(new RadiusAttribute(1, string.getBytes()));
        radiusPacket.setAttribute(new RadiusAttribute(40, new byte[]{0, 0, 0, 1}));
        radiusPacket.setAttribute(new RadiusAttribute(44, "bob".getBytes()));
        radiusPacket.setAttribute(new RadiusAttribute(6, new byte[]{0, 0, 0, 1}));
        RadiusPacket radiusPacket2 = radiusClient.account(radiusPacket);
        switch (radiusPacket2.getPacketType()) {
            case 10: {
                TestRadiusClient.log("User " + string + " got ACCOUNTING_MESSAGE response");
                break;
            }
            case 5: {
                TestRadiusClient.log("User " + string + " got ACCOUNTING_RESPONSE response");
                break;
            }
            case 6: {
                TestRadiusClient.log("User " + string + " got ACCOUNTING_STATUS response");
                break;
            }
            default: {
                TestRadiusClient.log("User " + string + " got invalid response " + radiusPacket2.getPacketType());
            }
        }
        TestRadiusClient.printAttributes(radiusPacket2);
    }

    private static void advAuthenticate(RadiusClient radiusClient, ChapUtil chapUtil, BufferedReader bufferedReader) {
        try {
            boolean bl = false;
            boolean bl2 = true;
            String string = null;
            String string2 = null;
            String string3 = null;
            System.out.println("Performing tests using advanced classes: ");
            while (bl2) {
                Object object;
                bl = false;
                RadiusPacket radiusPacket = null;
                System.out.print("Username: ");
                string = bufferedReader.readLine();
                System.out.print("Password: ");
                string2 = bufferedReader.readLine();
                System.out.print("Authentication method [PAP | chap]: ");
                string3 = bufferedReader.readLine();
                radiusPacket = string3.equalsIgnoreCase("chap") ? new ChapAccessRequest(string, string2) : new PapAccessRequest(string, string2);
                System.out.print("Additional Attributes? [y|N]:");
                boolean bl3 = bufferedReader.readLine().equalsIgnoreCase("y");
                while (bl3) {
                    System.out.print("Attribute Type:");
                    int n = Integer.parseInt(bufferedReader.readLine());
                    System.out.print("AttributeValue:");
                    object = bufferedReader.readLine().getBytes();
                    radiusPacket.setAttribute(new RadiusAttribute(n, (byte[])object));
                    System.out.print("Additional Attributes? [y|N]:");
                    boolean bl4 = bl3 = bufferedReader.readLine().equalsIgnoreCase("y");
                }
                RadiusPacket radiusPacket2 = radiusClient.authenticate(radiusPacket);
                switch (radiusPacket2.getPacketType()) {
                    case 2: {
                        TestRadiusClient.log("User " + string + " authenticated");
                        TestRadiusClient.printAttributes(radiusPacket2);
                        TestRadiusClient.advAccount(radiusClient, string);
                        break;
                    }
                    case 3: {
                        TestRadiusClient.log("User " + string + " NOT authenticated");
                        TestRadiusClient.printAttributes(radiusPacket2);
                        break;
                    }
                    case 11: {
                        object = new String(radiusPacket2.getAttribute(18).getValue());
                        TestRadiusClient.log("User " + string + " Challenged with " + (String)object);
                        break;
                    }
                    default: {
                        TestRadiusClient.log("Whoa, what kind of RadiusPacket is this " + radiusPacket2.getPacketType());
                    }
                }
                System.out.print("Another Advanced Test [ Y | n ]: ");
                string3 = bufferedReader.readLine();
                if (!string3.equalsIgnoreCase("n")) continue;
                bl2 = false;
            }
        }
        catch (InvalidParameterException invalidParameterException) {
            TestRadiusClient.log(invalidParameterException.getMessage());
        }
        catch (RadiusException radiusException) {
            TestRadiusClient.log(radiusException.getMessage());
        }
        catch (IOException iOException) {
            TestRadiusClient.log(iOException.getMessage());
        }
    }

    private static void advAccount(RadiusClient radiusClient, String string) throws InvalidParameterException, RadiusException {
        AccountingRequest accountingRequest = new AccountingRequest(string, new byte[]{0, 0, 0, 1}, string);
        RadiusPacket radiusPacket = radiusClient.account(accountingRequest);
        switch (radiusPacket.getPacketType()) {
            case 10: {
                TestRadiusClient.log("User " + string + " got ACCOUNTING_MESSAGE response");
                break;
            }
            case 5: {
                TestRadiusClient.log("User " + string + " got ACCOUNTING_RESPONSE response");
                break;
            }
            case 6: {
                TestRadiusClient.log("User " + string + " got ACCOUNTING_STATUS response");
                break;
            }
            default: {
                TestRadiusClient.log("User " + string + " got invalid response " + radiusPacket.getPacketType());
            }
        }
        TestRadiusClient.printAttributes(radiusPacket);
    }

    private static void printAttributes(RadiusPacket radiusPacket) {
        Iterator iterator = radiusPacket.getAttributes().iterator();
        System.out.println("Response Packet Attributes");
        System.out.println("\tType\tValue");
        while (iterator.hasNext()) {
            RadiusAttribute radiusAttribute = (RadiusAttribute)iterator.next();
            System.out.println("\t" + radiusAttribute.getType() + "\t" + new String(radiusAttribute.getValue()));
        }
    }

    private static void log(String string) {
        System.out.print("TestRadiusClient: ");
        System.out.println(string);
    }
}

