/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.service;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.springframework.binding.convert.ConversionException;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionExecutorNotFoundException;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.converters.ArrayToArray;
import org.springframework.binding.convert.converters.ArrayToCollection;
import org.springframework.binding.convert.converters.CollectionToCollection;
import org.springframework.binding.convert.converters.Converter;
import org.springframework.binding.convert.converters.ObjectToArray;
import org.springframework.binding.convert.converters.ObjectToCollection;
import org.springframework.binding.convert.converters.ReverseConverter;
import org.springframework.binding.convert.converters.TwoWayConverter;
import org.springframework.binding.convert.service.NoOpConverter;
import org.springframework.binding.convert.service.StaticConversionExecutor;
import org.springframework.binding.convert.service.TwoWayCapableConversionExecutor;
import org.springframework.util.Assert;

public class GenericConversionService
implements ConversionService {
    private final Map sourceClassConverters = new HashMap();
    private final Map customConverters = new HashMap();
    private final Map aliasMap = new HashMap();
    private ConversionService parent;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;

    public ConversionService getParent() {
        return this.parent;
    }

    public void setParent(ConversionService parent) {
        this.parent = parent;
    }

    public void addConverter(Converter converter) {
        Class sourceClass = converter.getSourceClass();
        Class targetClass = converter.getTargetClass();
        Map sourceMap = this.getSourceMap(sourceClass);
        sourceMap.put(targetClass, converter);
        if (converter instanceof TwoWayConverter) {
            sourceMap = this.getSourceMap(targetClass);
            sourceMap.put(sourceClass, new ReverseConverter((TwoWayConverter)converter));
        }
    }

    public void addConverter(String id, Converter converter) {
        this.customConverters.put(id, converter);
    }

    public void addAlias(String alias, Class targetType) {
        this.aliasMap.put(alias, targetType);
    }

    private Map getSourceMap(Class sourceClass) {
        HashMap sourceMap = (HashMap)this.sourceClassConverters.get(sourceClass);
        if (sourceMap == null) {
            sourceMap = new HashMap();
            this.sourceClassConverters.put(sourceClass, sourceMap);
        }
        return sourceMap;
    }

    public ConversionExecutor getConversionExecutor(Class sourceClass, Class targetClass) throws ConversionExecutorNotFoundException {
        Assert.notNull((Object)sourceClass, (String)"The source class to convert from is required");
        Assert.notNull((Object)targetClass, (String)"The target class to convert to is required");
        sourceClass = this.convertToWrapperClassIfNecessary(sourceClass);
        targetClass = this.convertToWrapperClassIfNecessary(targetClass);
        if (targetClass.isAssignableFrom(sourceClass)) {
            return new StaticConversionExecutor(sourceClass, targetClass, new NoOpConverter(sourceClass, targetClass));
        }
        if (sourceClass.isArray()) {
            if (targetClass.isArray()) {
                return new StaticConversionExecutor(sourceClass, targetClass, new ArrayToArray(this));
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.util.Collection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(targetClass)) {
                if (!targetClass.isInterface() && Modifier.isAbstract(targetClass.getModifiers())) {
                    throw new IllegalArgumentException("Conversion target class [" + targetClass.getName() + "] is invalid; cannot convert to abstract collection types--" + "request an interface or concrete implementation instead");
                }
                return new StaticConversionExecutor(sourceClass, targetClass, new ArrayToCollection(this));
            }
        }
        if (targetClass.isArray()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.util.Collection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(sourceClass)) {
                ReverseConverter collectionToArray = new ReverseConverter(new ArrayToCollection(this));
                return new StaticConversionExecutor(sourceClass, targetClass, collectionToArray);
            }
            return new StaticConversionExecutor(sourceClass, targetClass, new ObjectToArray(this));
        }
        Converter converter = this.findRegisteredConverter(sourceClass, targetClass);
        if (converter != null) {
            return new StaticConversionExecutor(sourceClass, targetClass, converter);
        }
        if (this.parent != null) {
            return this.parent.getConversionExecutor(sourceClass, targetClass);
        }
        throw new ConversionExecutorNotFoundException(sourceClass, targetClass, "No ConversionExecutor found for converting from sourceClass [" + sourceClass.getName() + "] to target class [" + targetClass.getName() + "]");
    }

    public ConversionExecutor getConversionExecutor(String id, Class sourceClass, Class targetClass) throws ConversionExecutorNotFoundException {
        Class<?> clazz;
        Assert.hasText((String)id, (String)"The id of the custom converter is required");
        Assert.notNull((Object)sourceClass, (String)"The source class to convert from is required");
        Assert.notNull((Object)targetClass, (String)"The target class to convert to is required");
        Converter converter = (Converter)this.customConverters.get(id);
        if (converter == null) {
            if (this.parent != null) {
                return this.parent.getConversionExecutor(id, sourceClass, targetClass);
            }
            throw new ConversionExecutorNotFoundException(sourceClass, targetClass, "No custom ConversionExecutor found with id '" + id + "' for converting from sourceClass [" + sourceClass.getName() + "] to targetClass [" + targetClass.getName() + "]");
        }
        sourceClass = this.convertToWrapperClassIfNecessary(sourceClass);
        targetClass = this.convertToWrapperClassIfNecessary(targetClass);
        if (sourceClass.isArray()) {
            Class<?> sourceComponentType = sourceClass.getComponentType();
            if (targetClass.isArray()) {
                Class<?> targetComponentType = targetClass.getComponentType();
                if (converter.getSourceClass().isAssignableFrom(sourceComponentType)) {
                    if (!converter.getTargetClass().isAssignableFrom(targetComponentType)) {
                        throw new ConversionExecutorNotFoundException(sourceClass, targetClass, "Custom ConversionExecutor with id '" + id + "' cannot convert from an array storing elements of type [" + sourceComponentType.getName() + "] to an array of storing elements of type [" + targetComponentType.getName() + "]");
                    }
                    StaticConversionExecutor elementConverter = new StaticConversionExecutor(sourceComponentType, targetComponentType, converter);
                    return new StaticConversionExecutor(sourceClass, targetClass, new ArrayToArray(elementConverter));
                }
                if (converter.getTargetClass().isAssignableFrom(sourceComponentType) && converter instanceof TwoWayConverter) {
                    TwoWayConverter twoWay = (TwoWayConverter)converter;
                    StaticConversionExecutor elementConverter = new StaticConversionExecutor(sourceComponentType, targetComponentType, new ReverseConverter(twoWay));
                    return new StaticConversionExecutor(sourceClass, targetClass, new ArrayToArray(elementConverter));
                }
                throw new ConversionExecutorNotFoundException(sourceClass, targetClass, "Custom ConversionExecutor with id '" + id + "' cannot convert from an array storing elements of type [" + sourceComponentType.getName() + "] to an array storing elements of type [" + targetComponentType.getName() + "]");
            }
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.util.Collection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz2.isAssignableFrom(targetClass)) {
                if (!targetClass.isInterface() && Modifier.isAbstract(targetClass.getModifiers())) {
                    throw new IllegalArgumentException("Conversion target class [" + targetClass.getName() + "] is invalid; cannot convert to abstract collection types--" + "request an interface or concrete implementation instead");
                }
                if (converter.getSourceClass().isAssignableFrom(sourceComponentType)) {
                    StaticConversionExecutor elementConverter = new StaticConversionExecutor(sourceComponentType, converter.getTargetClass(), converter);
                    return new StaticConversionExecutor(sourceClass, targetClass, new ArrayToCollection(elementConverter));
                }
                if (converter.getTargetClass().isAssignableFrom(sourceComponentType) && converter instanceof TwoWayConverter) {
                    TwoWayConverter twoWay = (TwoWayConverter)converter;
                    StaticConversionExecutor elementConverter = new StaticConversionExecutor(sourceComponentType, converter.getSourceClass(), new ReverseConverter(twoWay));
                    return new StaticConversionExecutor(sourceClass, targetClass, new ArrayToCollection(elementConverter));
                }
                throw new ConversionExecutorNotFoundException(sourceClass, targetClass, "Custom ConversionExecutor with id '" + id + "' cannot convert from array an storing elements type [" + sourceComponentType.getName() + "] to a collection of type [" + targetClass.getName() + "]");
            }
        }
        if (targetClass.isArray()) {
            Class<?> targetComponentType = targetClass.getComponentType();
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("java.util.Collection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz3.isAssignableFrom(sourceClass)) {
                if (converter.getTargetClass().isAssignableFrom(targetComponentType)) {
                    StaticConversionExecutor elementConverter = new StaticConversionExecutor(converter.getSourceClass(), targetComponentType, converter);
                    ReverseConverter collectionToArray = new ReverseConverter(new ArrayToCollection(elementConverter));
                    return new StaticConversionExecutor(sourceClass, targetClass, collectionToArray);
                }
                if (converter.getSourceClass().isAssignableFrom(targetComponentType) && converter instanceof TwoWayConverter) {
                    TwoWayConverter twoWay = (TwoWayConverter)converter;
                    StaticConversionExecutor elementConverter = new StaticConversionExecutor(converter.getTargetClass(), targetComponentType, new ReverseConverter(twoWay));
                    ReverseConverter collectionToArray = new ReverseConverter(new ArrayToCollection(elementConverter));
                    return new StaticConversionExecutor(sourceClass, targetClass, collectionToArray);
                }
                throw new ConversionExecutorNotFoundException(sourceClass, targetClass, "Custom ConversionExecutor with id '" + id + "' cannot convert from collection of type [" + sourceClass.getName() + "] to an array storing elements of type [" + targetComponentType.getName() + "]");
            }
            if (converter.getSourceClass().isAssignableFrom(sourceClass)) {
                if (!converter.getTargetClass().isAssignableFrom(targetComponentType)) {
                    throw new ConversionExecutorNotFoundException(sourceClass, targetClass, "Custom ConversionExecutor with id '" + id + "' cannot convert from sourceClass [" + sourceClass.getName() + "] to array holding elements of type [" + targetComponentType.getName() + "]");
                }
                StaticConversionExecutor elementConverter = new StaticConversionExecutor(sourceClass, targetComponentType, converter);
                return new StaticConversionExecutor(sourceClass, targetClass, new ObjectToArray(elementConverter));
            }
            if (converter.getTargetClass().isAssignableFrom(sourceClass) && converter instanceof TwoWayConverter) {
                if (!converter.getSourceClass().isAssignableFrom(targetComponentType)) {
                    throw new ConversionExecutorNotFoundException(sourceClass, targetClass, "Custom ConversionExecutor with id '" + id + "' cannot convert from sourceClass [" + sourceClass.getName() + "] to array holding elements of type [" + targetComponentType.getName() + "]");
                }
                TwoWayConverter twoWay = (TwoWayConverter)converter;
                StaticConversionExecutor elementConverter = new StaticConversionExecutor(sourceClass, targetComponentType, new ReverseConverter(twoWay));
                return new StaticConversionExecutor(sourceClass, targetClass, new ObjectToArray(elementConverter));
            }
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Collection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(targetClass)) {
            ConversionExecutor elementConverter;
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("java.util.Collection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz4.isAssignableFrom(sourceClass)) {
                elementConverter = converter instanceof TwoWayConverter ? new TwoWayCapableConversionExecutor(converter.getSourceClass(), converter.getTargetClass(), (TwoWayConverter)converter) : new StaticConversionExecutor(converter.getSourceClass(), converter.getTargetClass(), converter);
                return new StaticConversionExecutor(sourceClass, targetClass, new CollectionToCollection(elementConverter));
            }
            elementConverter = converter instanceof TwoWayConverter ? new TwoWayCapableConversionExecutor(sourceClass, converter.getTargetClass(), (TwoWayConverter)converter) : new StaticConversionExecutor(sourceClass, converter.getTargetClass(), converter);
            Class<?> clazz5 = class$0;
            if (clazz5 == null) {
                try {
                    clazz5 = class$0 = Class.forName("java.util.Collection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz5.isAssignableFrom(converter.getTargetClass())) {
                elementConverter = new StaticConversionExecutor(sourceClass, targetClass, new ObjectToCollection(elementConverter));
            }
            return elementConverter;
        }
        if (converter.getSourceClass().isAssignableFrom(sourceClass)) {
            if (!converter.getTargetClass().isAssignableFrom(targetClass)) {
                throw new ConversionExecutorNotFoundException(sourceClass, targetClass, "Custom ConversionExecutor with id '" + id + "' cannot convert from sourceClass [" + sourceClass.getName() + "] to targetClass [" + targetClass.getName() + "]");
            }
            return new StaticConversionExecutor(sourceClass, targetClass, converter);
        }
        if (converter.getTargetClass().isAssignableFrom(sourceClass) && converter instanceof TwoWayConverter) {
            if (!converter.getSourceClass().isAssignableFrom(targetClass)) {
                throw new ConversionExecutorNotFoundException(sourceClass, targetClass, "Custom ConversionExecutor with id '" + id + "' cannot convert from sourceClass [" + sourceClass.getName() + "] to targetClass [" + targetClass.getName() + "]");
            }
            TwoWayConverter twoWay = (TwoWayConverter)converter;
            return new StaticConversionExecutor(sourceClass, targetClass, new ReverseConverter(twoWay));
        }
        throw new ConversionExecutorNotFoundException(sourceClass, targetClass, "Custom ConversionExecutor with id '" + id + "' cannot convert from sourceClass [" + sourceClass.getName() + "] to targetClass [" + targetClass.getName() + "]");
    }

    private Converter findRegisteredConverter(Class sourceClass, Class targetClass) {
        if (sourceClass.isInterface()) {
            LinkedList classQueue = new LinkedList();
            classQueue.addFirst(sourceClass);
            while (!classQueue.isEmpty()) {
                Class currentClass = (Class)classQueue.removeLast();
                Map sourceTargetConverters = this.findConvertersForSource(currentClass);
                Converter converter = this.findTargetConverter(sourceTargetConverters, targetClass);
                if (converter != null) {
                    return converter;
                }
                Class<?>[] interfaces = currentClass.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    classQueue.addFirst(interfaces[i]);
                    ++i;
                }
            }
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Map objectConverters = this.findConvertersForSource(clazz);
            return this.findTargetConverter(objectConverters, targetClass);
        }
        LinkedList classQueue = new LinkedList();
        classQueue.addFirst(sourceClass);
        while (!classQueue.isEmpty()) {
            Class currentClass = (Class)classQueue.removeLast();
            Map sourceTargetConverters = this.findConvertersForSource(currentClass);
            Converter converter = this.findTargetConverter(sourceTargetConverters, targetClass);
            if (converter != null) {
                return converter;
            }
            if (currentClass.getSuperclass() != null) {
                classQueue.addFirst(currentClass.getSuperclass());
            }
            Class<?>[] interfaces = currentClass.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                classQueue.addFirst(interfaces[i]);
                ++i;
            }
        }
        return null;
    }

    public Object executeConversion(Object source, Class targetClass) throws ConversionException {
        if (source != null) {
            ConversionExecutor conversionExecutor = this.getConversionExecutor(source.getClass(), targetClass);
            return conversionExecutor.execute(source);
        }
        return null;
    }

    public Object executeConversion(String converterId, Object source, Class targetClass) throws ConversionException {
        if (source != null) {
            ConversionExecutor conversionExecutor = this.getConversionExecutor(converterId, source.getClass(), targetClass);
            return conversionExecutor.execute(source);
        }
        return null;
    }

    public Class getClassForAlias(String name) throws IllegalArgumentException {
        Class clazz = (Class)this.aliasMap.get(name);
        if (clazz != null) {
            return clazz;
        }
        if (this.parent != null) {
            return this.parent.getClassForAlias(name);
        }
        return null;
    }

    public Set getConversionExecutors(Class sourceClass) {
        Set parentExecutors = this.parent != null ? this.parent.getConversionExecutors(sourceClass) : Collections.EMPTY_SET;
        Map sourceMap = this.getSourceMap(sourceClass);
        if (parentExecutors.isEmpty() && sourceMap.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Set entries = sourceMap.entrySet();
        HashSet<StaticConversionExecutor> conversionExecutors = new HashSet<StaticConversionExecutor>(entries.size() + parentExecutors.size());
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Class targetClass = (Class)entry.getKey();
            Converter converter = (Converter)entry.getValue();
            conversionExecutors.add(new StaticConversionExecutor(sourceClass, targetClass, converter));
        }
        conversionExecutors.addAll(parentExecutors);
        return conversionExecutors;
    }

    protected Map getSourceClassConverters() {
        return this.sourceClassConverters;
    }

    protected Converter getConverter(Class sourceClass, Class targetClass) {
        Map sourceTargetConverters = this.findConvertersForSource(sourceClass);
        return this.findTargetConverter(sourceTargetConverters, targetClass);
    }

    private Map findConvertersForSource(Class sourceClass) {
        Map sourceConverters = (Map)this.sourceClassConverters.get(sourceClass);
        return sourceConverters != null ? sourceConverters : Collections.EMPTY_MAP;
    }

    private Converter findTargetConverter(Map sourceTargetConverters, Class targetClass) {
        if (sourceTargetConverters.isEmpty()) {
            return null;
        }
        if (targetClass.isInterface()) {
            LinkedList classQueue = new LinkedList();
            classQueue.addFirst(targetClass);
            while (!classQueue.isEmpty()) {
                Class currentClass = (Class)classQueue.removeLast();
                Converter converter = (Converter)sourceTargetConverters.get(currentClass);
                if (converter != null) {
                    return converter;
                }
                Class<?>[] interfaces = currentClass.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    classQueue.addFirst(interfaces[i]);
                    ++i;
                }
            }
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (Converter)sourceTargetConverters.get(clazz);
        }
        LinkedList classQueue = new LinkedList();
        classQueue.addFirst(targetClass);
        while (!classQueue.isEmpty()) {
            Class currentClass = (Class)classQueue.removeLast();
            Converter converter = (Converter)sourceTargetConverters.get(currentClass);
            if (converter != null) {
                return converter;
            }
            if (currentClass.getSuperclass() != null) {
                classQueue.addFirst(currentClass.getSuperclass());
            }
            Class<?>[] interfaces = currentClass.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                classQueue.addFirst(interfaces[i]);
                ++i;
            }
        }
        return null;
    }

    private Class convertToWrapperClassIfNecessary(Class targetType) {
        if (targetType.isPrimitive()) {
            if (targetType.equals(Integer.TYPE)) {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (targetType.equals(Short.TYPE)) {
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = class$5 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (targetType.equals(Long.TYPE)) {
                Class<?> clazz = class$7;
                if (clazz == null) {
                    try {
                        clazz = class$7 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (targetType.equals(Float.TYPE)) {
                Class<?> clazz = class$9;
                if (clazz == null) {
                    try {
                        clazz = class$9 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (targetType.equals(Double.TYPE)) {
                Class<?> clazz = class$11;
                if (clazz == null) {
                    try {
                        clazz = class$11 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (targetType.equals(Byte.TYPE)) {
                Class<?> clazz = class$13;
                if (clazz == null) {
                    try {
                        clazz = class$13 = Class.forName("java.lang.Byte");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (targetType.equals(Boolean.TYPE)) {
                Class<?> clazz = class$15;
                if (clazz == null) {
                    try {
                        clazz = class$15 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (targetType.equals(Character.TYPE)) {
                Class<?> clazz = class$17;
                if (clazz == null) {
                    try {
                        clazz = class$17 = Class.forName("java.lang.Character");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            throw new IllegalStateException("Should never happen - primitive type is not a primitive?");
        }
        return targetType;
    }
}

