/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.asterisk.agi.scripts;

import org.asteriskjava.fastagi.AgiChannel;
import org.asteriskjava.fastagi.AgiException;
import org.asteriskjava.fastagi.AgiRequest;
import org.opennms.netmgt.asterisk.agi.scripts.BaseOnmsAgiScript;

public class ReadNoticeDetailsAgiScript
extends BaseOnmsAgiScript {
    public void service(AgiRequest req, AgiChannel chan) throws AgiException {
        this.authenticateUser();
        this.sayNode();
        this.sayServiceName();
        this.streamFile("silence/1");
        this.sayIpAddr();
    }

    public void authenticateUser() throws AgiException {
        String actualPin = this.getVariable("OPENNMS_USER_PIN");
        if (actualPin == null || "".equals(actualPin)) {
            this.log().info("User has no TUI PIN, so proceeding without authentication");
            return;
        }
        String inputPin = null;
        for (int attempts = 0; !String.valueOf(inputPin).equals(String.valueOf(actualPin)) && attempts < 3; ++attempts) {
            if (attempts > 0) {
                this.streamFile("auth-incorrect");
            }
            inputPin = this.getData("enter-password");
        }
        if (String.valueOf(inputPin).equals(String.valueOf(actualPin))) {
            return;
        }
        this.log().warn("User " + this.getVariable("OPENNMS_USERNAME") + " failed authentication");
        this.streamFile("auth-incorrect");
        this.streamFile("goodbye");
        this.hangup();
    }

    public void sayNode() throws AgiException {
        String nodeID = null;
        String nodeLabel = null;
        nodeID = this.getVariable("OPENNMS_NODEID");
        nodeLabel = this.getVariable("OPENNMS_NODELABEL");
        if (!"".equals(nodeLabel)) {
            this.log().debug("Reading node label to user: " + nodeLabel);
            this.streamFileInterruptible("node");
            try {
                this.streamFileInterruptible(nodeLabel.toLowerCase());
            }
            catch (AgiException e) {
                this.sayAlphaInterruptible(nodeLabel);
            }
        } else if (!"".equals(nodeID)) {
            this.log().debug("Reading node ID to user: " + nodeID);
            this.streamFileInterruptible("node");
            this.streamFileInterruptible("number");
            this.sayDigitsInterruptible(nodeID);
        } else {
            this.log().debug("No node label or node ID available");
        }
    }

    public void sayIpAddr() throws AgiException {
        String ipAddr = null;
        ipAddr = this.getVariable("OPENNMS_INTERFACE");
        if (ipAddr != null && !"".equals(ipAddr)) {
            this.log().debug("Reading IP address to user: " + ipAddr);
            this.streamFileInterruptible("letters/i");
            this.streamFileInterruptible("letters/p");
            this.streamFileInterruptible("address");
            this.sayIpAddressInterruptible(ipAddr);
        }
    }

    public void sayServiceName() throws AgiException {
        String svcName = null;
        svcName = this.getVariable("OPENNMS_SERVICE");
        if (svcName != null && !"".equals(svcName)) {
            this.log().debug("Reading service name to user: " + svcName);
            this.streamFileInterruptible("service");
            try {
                this.streamFileInterruptible(svcName.toLowerCase());
            }
            catch (AgiException e) {
                this.sayAlphaInterruptible(svcName);
            }
        } else {
            this.log().debug("No service name available");
        }
    }
}

