/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.urlrewrite;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tuckey.web.filters.urlrewrite.RewrittenUrl;
import org.tuckey.web.filters.urlrewrite.RuleBase;
import org.tuckey.web.filters.urlrewrite.RuleExecutionOutput;
import org.tuckey.web.filters.urlrewrite.utils.Log;
import org.tuckey.web.filters.urlrewrite.utils.StringUtils;

public final class Rule
extends RuleBase {
    private static Log log = Log.getLog(class$org$tuckey$web$filters$urlrewrite$Rule == null ? (class$org$tuckey$web$filters$urlrewrite$Rule = Rule.class$("org.tuckey.web.filters.urlrewrite.Rule")) : class$org$tuckey$web$filters$urlrewrite$Rule);
    private short toType = 1;
    private static final short TO_TYPE_REDIRECT = 0;
    private static final short TO_TYPE_FORWARD = 1;
    private static final short TO_TYPE_PERMANENT_REDIRECT = 2;
    private static final short TO_TYPE_TEMPORARY_REDIRECT = 3;
    private static final short TO_TYPE_PRE_INCLUDE = 4;
    private static final short TO_TYPE_POST_INCLUDE = 5;
    private boolean encodeToUrl = false;
    static /* synthetic */ Class class$org$tuckey$web$filters$urlrewrite$Rule;

    public RewrittenUrl execute(String url, HttpServletRequest hsRequest, HttpServletResponse hsResponse) {
        RuleExecutionOutput ruleExecutionOutput = super.executeBase(url, hsRequest, hsResponse);
        if (ruleExecutionOutput == null || !ruleExecutionOutput.isRuleMatched()) {
            return null;
        }
        return this.rewriteRequest(ruleExecutionOutput);
    }

    private RewrittenUrl rewriteRequest(RuleExecutionOutput ruleExecutionOutput) {
        RewrittenUrl rewrittenRequest = new RewrittenUrl(ruleExecutionOutput);
        String toUrl = ruleExecutionOutput.getReplacedUrl();
        if (this.toType == 0) {
            if (log.isDebugEnabled()) {
                log.debug("needs to be redirected to " + toUrl);
            }
            rewrittenRequest.setRedirect(true);
        } else if (this.toType == 2) {
            if (log.isDebugEnabled()) {
                log.debug("needs to be permanentely redirected to " + toUrl);
            }
            rewrittenRequest.setPermanentRedirect(true);
        } else if (this.toType == 3) {
            if (log.isDebugEnabled()) {
                log.debug("needs to be temporarily redirected to " + toUrl);
            }
            rewrittenRequest.setTemporaryRedirect(true);
        } else if (this.toType == 4) {
            if (log.isDebugEnabled()) {
                log.debug(toUrl + " needs to be pre included");
            }
            rewrittenRequest.setPreInclude(true);
        } else if (this.toType == 5) {
            if (log.isDebugEnabled()) {
                log.debug(toUrl + " needs to be post included");
            }
            rewrittenRequest.setPostInclude(true);
        } else if (this.toType == 1) {
            if (log.isDebugEnabled()) {
                log.debug("needs to be forwarded to " + toUrl);
            }
            rewrittenRequest.setForward(true);
        }
        if (this.encodeToUrl) {
            rewrittenRequest.setEncode(true);
        } else {
            rewrittenRequest.setEncode(false);
        }
        return rewrittenRequest;
    }

    public boolean initialise(ServletContext context) {
        boolean ok = super.initialise(context);
        this.initialised = true;
        if (!ok) {
            log.debug("failed to load rule");
        } else {
            log.debug("loaded rule " + this.getDisplayName() + " (" + this.from + ", " + this.to + " " + this.toType + ")");
        }
        if (this.errors.size() > 0) {
            ok = false;
        }
        this.valid = ok;
        return ok;
    }

    public void setToType(String toTypeStr) {
        if ("redirect".equals(toTypeStr)) {
            this.toType = 0;
        } else if ("permanent-redirect".equals(toTypeStr)) {
            this.toType = (short)2;
        } else if ("temporary-redirect".equals(toTypeStr)) {
            this.toType = (short)3;
        } else if ("pre-include".equals(toTypeStr)) {
            this.toType = (short)4;
        } else if ("post-include".equals(toTypeStr)) {
            this.toType = (short)5;
        } else if ("forward".equals(toTypeStr) || "passthrough".equals(toTypeStr) || StringUtils.isBlank(toTypeStr)) {
            this.toType = 1;
        } else {
            this.addError("type (" + toTypeStr + ") is not valid");
        }
    }

    public String getToType() {
        if (this.toType == 0) {
            return "redirect";
        }
        if (this.toType == 2) {
            return "permanent-redirect";
        }
        if (this.toType == 3) {
            return "temporary-redirect";
        }
        if (this.toType == 4) {
            return "pre-include";
        }
        if (this.toType == 5) {
            return "post-include";
        }
        return "forward";
    }

    protected void addError(String s) {
        log.error("Rule " + this.getDisplayName() + " had error: " + s);
        super.addError(s);
    }

    public String getDisplayName() {
        if (this.name != null) {
            return this.name + " (rule " + this.id + ")";
        }
        return "Rule " + this.id;
    }

    public String getFullDisplayName() {
        return this.getDisplayName() + " (" + this.from + ", " + this.to + " " + this.toType + ")";
    }

    public boolean isEncodeToUrl() {
        return this.encodeToUrl;
    }

    public void setEncodeToUrl(boolean encodeToUrl) {
        this.encodeToUrl = encodeToUrl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

