/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.soa.support;

import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import org.opennms.core.soa.Registration;
import org.opennms.core.soa.RegistrationListener;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistrationListenerBean
implements RegistrationListener<Object>,
InitializingBean {
    private Class<?> m_serviceInterface;
    private Object m_target;
    private String m_bindMethod;
    private String m_unbindMethod;

    public Class<?> getServiceInterface() {
        return this.m_serviceInterface;
    }

    public void setServiceInterface(Class<?> serviceInterface) {
        this.m_serviceInterface = serviceInterface;
    }

    public Object getTarget() {
        return this.m_target;
    }

    public void setTarget(Object target) {
        this.m_target = target;
    }

    public String getBindMethod() {
        return this.m_bindMethod;
    }

    public void setBindMethod(String bindMethod) {
        this.m_bindMethod = bindMethod;
    }

    public String getUnbindMethod() {
        return this.m_unbindMethod;
    }

    public void setUnbindMethod(String unbindMethod) {
        this.m_unbindMethod = unbindMethod;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.m_serviceInterface, (String)"serviceInterface must not be null");
        Assert.notNull((Object)this.m_target, (String)"target may not be null");
        Assert.isTrue((StringUtils.hasText((String)this.m_bindMethod) || StringUtils.hasText((String)this.m_unbindMethod) ? 1 : 0) != 0, (String)"at least one of the bind or unbind methods must be set");
        if (StringUtils.hasText((String)this.m_bindMethod)) {
            this.getMethod(this.m_bindMethod);
        }
        if (StringUtils.hasText((String)this.m_unbindMethod)) {
            this.getMethod(this.m_unbindMethod);
        }
    }

    private Method getMethod(String name) throws SecurityException, NoSuchMethodException {
        Method method = this.m_target.getClass().getMethod(name, this.m_serviceInterface, Map.class);
        Assert.notNull((Object)name, (String)("Unable to find method named " + name));
        return method;
    }

    private void invokeMethod(String methodName, Registration registration) {
        try {
            Method method = this.getMethod(methodName);
            method.invoke(this.m_target, registration.getProvider(this.m_serviceInterface), registration.getProperties());
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e, "Unexexpected exception invoking method " + methodName);
        }
    }

    @Override
    public void providerRegistered(Registration registration, Object provider) {
        if (StringUtils.hasText((String)this.m_bindMethod)) {
            this.invokeMethod(this.m_bindMethod, registration);
        }
    }

    @Override
    public void providerUnregistered(Registration registration, Object provider) {
        if (StringUtils.hasText((String)this.m_unbindMethod)) {
            this.invokeMethod(this.m_unbindMethod, registration);
        }
    }
}

