/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.soa.support;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opennms.core.soa.Registration;
import org.opennms.core.soa.RegistrationListener;
import org.opennms.core.soa.ServiceRegistry;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceListFactoryBean
implements FactoryBean,
InitializingBean,
RegistrationListener {
    private ServiceRegistry m_serviceRegistry;
    private Class<?> m_serviceInterface;
    private List<RegistrationListener<Object>> m_listeners = new CopyOnWriteArrayList<RegistrationListener<Object>>();
    private List<Object> m_providerRegistrations = new CopyOnWriteArrayList<Object>();

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.m_serviceRegistry = serviceRegistry;
    }

    public void setServiceInterface(Class<?> serviceInterface) {
        this.m_serviceInterface = serviceInterface;
    }

    public Object getObject() throws Exception {
        return this.m_providerRegistrations;
    }

    public Class<?> getObjectType() {
        return List.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_serviceRegistry, (String)"The serviceRegistry must be set");
        Assert.notNull(this.m_serviceInterface, (String)"The serviceInterface must be set");
        this.m_serviceRegistry.addListener(this.m_serviceInterface, this, true);
    }

    public void providerRegistered(Registration registration, Object provider) {
        this.m_providerRegistrations.add(provider);
        for (RegistrationListener<Object> listener : this.m_listeners) {
            listener.providerRegistered(registration, provider);
        }
    }

    public void providerUnregistered(Registration registration, Object provider) {
        this.m_providerRegistrations.remove(provider);
        for (RegistrationListener<Object> listener : this.m_listeners) {
            listener.providerUnregistered(registration, provider);
        }
    }

    public void setListener(RegistrationListener<?> listener) {
        this.addListener(listener);
    }

    public void addListener(RegistrationListener<?> listener) {
        this.m_listeners.add(listener);
    }

    public void removeListener(RegistrationListener<?> listener) {
        this.m_listeners.remove(listener);
    }
}

