/*
 * Decompiled with CFR 0.152.
 */
package simple.http;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Locale;
import simple.http.Attributes;
import simple.http.Authenticator;
import simple.http.ChunkedInputStream;
import simple.http.FixedInputStream;
import simple.http.InputMonitor;
import simple.http.NullInputStream;
import simple.http.ParameterList;
import simple.http.Pipeline;
import simple.http.PlainAttributes;
import simple.http.PlainState;
import simple.http.RequestHeader;
import simple.http.State;
import simple.http.session.Manager;
import simple.http.session.Session;
import simple.util.ByteStore;
import simple.util.net.ContentType;
import simple.util.net.Cookie;
import simple.util.net.Parameters;
import simple.util.net.Path;
import simple.util.net.Principal;
import simple.util.parse.ContentParser;
import simple.util.parse.LanguageParser;
import simple.util.parse.URIParser;

final class MonitoredRequest
extends RequestHeader {
    private InputMonitor mon;
    private InputStream in;
    private Parameters data;
    private Attributes local;
    private Pipeline pipe;
    private State state;
    private Session session;

    public MonitoredRequest(ByteStore buf, Pipeline pipe, InputMonitor mon) throws IOException {
        super(buf);
        this.in = pipe.getInputStream();
        this.mon = mon;
        this.pipe = pipe;
        this.doConfigure();
    }

    public Attributes getAttributes() {
        if (this.local == null) {
            this.local = new PlainAttributes(this.pipe);
        }
        return this.local;
    }

    public Object getAttribute(String name) {
        return this.getAttributes().get(name);
    }

    public InetAddress getInetAddress() {
        return this.pipe.getInetAddress();
    }

    public Cookie getCookie(String name) {
        return this.getState().getCookie(name);
    }

    public State getState() {
        if (this.state == null) {
            String[] list = this.getValues("Cookie");
            this.state = new PlainState(list);
        }
        return this.state;
    }

    public Session getSession() {
        if (this.session == null) {
            State state = this.getState();
            this.session = Manager.getSession(state);
        }
        return this.session;
    }

    public Principal getPrincipal() {
        String text = this.getValue("Authorization");
        if (text != null) {
            return Authenticator.getPrincipal(text);
        }
        return null;
    }

    public boolean isKeepAlive() {
        if (this.contains("Connection")) {
            return !this.contains("Connection", "close");
        }
        if (this.getMajor() > 1) {
            return true;
        }
        if (this.getMajor() == 1) {
            return this.getMinor() > 0;
        }
        return false;
    }

    private int parseLength() throws NumberFormatException {
        int index = this.indexOf("Content-Length");
        if (index >= 0) {
            String text = this.getValue(index).trim();
            return Integer.parseInt(text);
        }
        return -1;
    }

    public int getContentLength() {
        try {
            return this.parseLength();
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private boolean isChunked() {
        return this.contains("Transfer-Encoding", "chunked");
    }

    public InputStream getInputStream() throws IOException {
        return new DataInputStream(this.in);
    }

    private DataInputStream getDataInputStream() throws IOException {
        return new DataInputStream(this.in);
    }

    public Path getPath() {
        return this.getPath(this.getURI());
    }

    private Path getPath(String target) {
        return new URIParser(target).getPath();
    }

    public ContentType getContentType() {
        int index = this.indexOf("Content-Type");
        if (index >= 0) {
            String text = this.getValue(index);
            return new ContentParser(text);
        }
        return null;
    }

    public Locale getLanguage() {
        int index = this.indexOf("Accept-Language");
        if (index >= 0) {
            String text = this.getValue(index);
            return new LanguageParser(text).getLocale();
        }
        return Locale.getDefault();
    }

    private String getQueryString() {
        String path = this.getURI();
        int index = path.indexOf("?");
        if (index >= 0) {
            return path.substring(index + 1);
        }
        return null;
    }

    public Parameters getParameters() throws IOException {
        if (this.data == null) {
            this.data = this.readParameters();
        }
        return this.data;
    }

    private Parameters readParameters() throws IOException {
        ContentType type = this.getContentType();
        String query = this.getQueryString();
        String text = null;
        if (type != null && this.isPosting(type)) {
            text = this.readContent(type);
        }
        return new ParameterList(query, text);
    }

    private String readContent(ContentType type) throws IOException {
        String charset = type.getCharset();
        int size = this.getContentLength();
        if (charset == null) {
            charset = "iso-8859-1";
        }
        return this.readContent(charset, size);
    }

    public String getParameter(String name) throws IOException {
        return this.getParameters().getParameter(name);
    }

    private boolean isPosting(ContentType type) {
        return type.getPrimary().equals("application") && type.getSecondary().equals("x-www-form-urlencoded");
    }

    private String readContent(String charset, int size) throws IOException {
        byte[] buf = new byte[Math.max(size, 0)];
        this.getDataInputStream().readFully(buf);
        return new String(buf, charset);
    }

    private void doConfigure() throws IOException {
        boolean trailer = this.contains("Trailer");
        int length = this.parseLength();
        this.in = this.isChunked() ? new ChunkedInputStream(this.in, this.mon, trailer) : (length >= 0 ? new FixedInputStream(this.in, this.mon, length) : new NullInputStream(this.in, this.mon));
    }

    protected void finalize() throws Throwable {
        this.in.close();
    }
}

