/*
 * Decompiled with CFR 0.152.
 */
package simple.http;

import java.io.IOException;
import java.io.OutputStream;
import simple.http.OutputMonitor;

abstract class MonitoredOutputStream
extends OutputStream {
    protected OutputMonitor mon;
    protected OutputStream out;
    protected byte[] temp = new byte[1];
    protected boolean open = true;

    protected MonitoredOutputStream(OutputStream out, OutputMonitor mon) {
        this.mon = mon;
        this.out = out;
    }

    public synchronized void write(int octet) throws IOException {
        this.temp[0] = (byte)octet;
        this.write(this.temp, 0, 1);
    }

    public synchronized void write(byte[] buf, int off, int len) throws IOException {
        this.ensureOpen();
        try {
            this.writeBytes(buf, off, len);
        }
        catch (IOException e) {
            this.mon.notifyError(this.out);
            this.destroy();
        }
    }

    public synchronized void flush() throws IOException {
        this.ensureOpen();
        try {
            this.flushBytes();
        }
        catch (IOException e) {
            this.mon.notifyError(this.out);
            this.destroy();
        }
    }

    protected void ensureOpen() throws IOException {
        if (!this.open) {
            throw new IOException("Stream closed");
        }
    }

    protected void destroy() throws IOException {
        try {
            throw new IOException("Broken pipe");
        }
        catch (Throwable throwable) {
            this.open = false;
            throw throwable;
        }
    }

    public synchronized void close() throws IOException {
        try {
            try {
                if (this.open) {
                    this.doClose();
                }
            }
            catch (IOException e) {
                this.mon.notifyError(this.out);
            }
        }
        finally {
            this.open = false;
        }
    }

    protected abstract void flushBytes() throws IOException;

    protected abstract void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    protected abstract void doClose() throws IOException;
}

