/*
 * Decompiled with CFR 0.152.
 */
package org.gwtwidgets.server.spring.gilead;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import java.lang.reflect.Method;
import javax.servlet.http.HttpSession;
import net.sf.gilead.core.IPersistenceUtil;
import net.sf.gilead.core.PersistentBeanManager;
import net.sf.gilead.core.hibernate.HibernateUtil;
import net.sf.gilead.gwt.GileadRPCHelper;
import net.sf.gilead.gwt.GwtConfigurationHelper;
import org.gwtwidgets.server.spring.GWTRPCServiceExporter;
import org.hibernate.SessionFactory;

public class GileadRPCServiceExporter
extends GWTRPCServiceExporter {
    private ThreadLocal<ClassLoader> tmpClassloader;
    private boolean createSessionIfNotExists = true;
    private boolean usingProxyClassLoader = false;
    private SessionFactory sessionFactory;
    private PersistentBeanManager beanManager;

    public boolean isUsingProxyClassLoader() {
        return this.usingProxyClassLoader;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.sessionFactory == null && this.beanManager == null) {
            throw new IllegalArgumentException("You must provide either a SessionFactory or a PersistentBeanManager");
        }
        if (this.usingProxyClassLoader) {
            this.tmpClassloader = new ThreadLocal();
        }
        if (this.beanManager == null) {
            this.beanManager = GwtConfigurationHelper.initGwtStatelessBeanManager((IPersistenceUtil)new HibernateUtil(this.sessionFactory));
        }
        super.afterPropertiesSet();
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public PersistentBeanManager getBeanManager() {
        return this.beanManager;
    }

    public void setBeanManager(PersistentBeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public void setUsingProxyClassLoader(boolean usingProxyClassLoader) {
        this.usingProxyClassLoader = usingProxyClassLoader;
    }

    public void setCreateSessionIfNotExists(boolean createSessionIfNotExists) {
        this.createSessionIfNotExists = createSessionIfNotExists;
    }

    protected void onBeforeRequestDeserialized(String serializedRequest) {
        super.onBeforeRequestDeserialized(serializedRequest);
        if (this.isUsingProxyClassLoader()) {
            Thread currentThread = Thread.currentThread();
            ClassLoader oldContextClassLoader = currentThread.getContextClassLoader();
            this.logger.info((Object)("Classloader before invocation: " + oldContextClassLoader));
            this.logger.info((Object)("Replacing with classloader   : " + this.getClass().getClassLoader()));
            this.tmpClassloader.set(oldContextClassLoader);
            currentThread.setContextClassLoader(this.getClass().getClassLoader());
            GileadRPCHelper.initClassLoader();
            this.logger.info((Object)("New classloader              : " + this.getClass().getClassLoader()));
        }
    }

    protected void onAfterResponseSerialized(String serializedResponse) {
        super.onAfterResponseSerialized(serializedResponse);
        if (this.isUsingProxyClassLoader()) {
            Thread currentThread = Thread.currentThread();
            ClassLoader oldContextClassLoader = this.tmpClassloader.get();
            currentThread.setContextClassLoader(oldContextClassLoader);
            this.logger.info((Object)"reinstating old classloader");
        }
    }

    public String invokeMethodOnService(Object service, Method targetMethod, Object[] targetParameters, RPCRequest rpcRequest) throws Exception {
        GileadRPCHelper.parseInputParameters((RPCRequest)rpcRequest, (PersistentBeanManager)this.beanManager, (HttpSession)this.getThreadLocalRequest().getSession(this.createSessionIfNotExists));
        Object result = targetMethod.invoke(service, targetParameters);
        result = GileadRPCHelper.parseReturnValue((Object)result, (PersistentBeanManager)this.beanManager);
        String encodedResult = RPC.encodeResponseForSuccess((Method)rpcRequest.getMethod(), (Object)result, (SerializationPolicy)rpcRequest.getSerializationPolicy());
        return encodedResult;
    }

    protected String encodeResponseForFailure(Throwable cause) throws SerializationException {
        Throwable throwable = (Throwable)GileadRPCHelper.parseReturnValue((Object)cause, (PersistentBeanManager)this.beanManager);
        return super.encodeResponseForFailure(throwable);
    }

    protected String encodeResponseForFailure(RPCRequest rpcRequest, Throwable cause) throws SerializationException {
        Throwable throwable = (Throwable)GileadRPCHelper.parseReturnValue((Object)cause, (PersistentBeanManager)this.beanManager);
        return super.encodeResponseForFailure(rpcRequest, throwable);
    }
}

