/*
 * Decompiled with CFR 0.152.
 */
package org.gwtwidgets.server.spring;

import com.google.gwt.user.client.rpc.RemoteService;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import org.gwtwidgets.server.spring.DefaultRPCServiceExporterFactory;
import org.gwtwidgets.server.spring.GWTRequestMapping;
import org.gwtwidgets.server.spring.RPCServiceExporter;
import org.gwtwidgets.server.spring.RPCServiceExporterFactory;
import org.gwtwidgets.server.spring.ReflectionUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ServletConfigAware;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWTHandler
extends AbstractUrlHandlerMapping
implements HandlerMapping,
InitializingBean,
ServletContextAware,
ServletConfigAware {
    private Map<String, Object> _mapping = new HashMap<String, Object>();
    protected RPCServiceExporterFactory factory;
    protected boolean disableResponseCaching = false;
    protected boolean throwUndeclaredExceptionToServletContainer = false;
    protected boolean scanParentApplicationContext = false;
    protected ServletConfig servletConfig;

    private void scanForAnnotatedBeans(ApplicationContext appContext) {
        if (appContext == null) {
            return;
        }
        for (String beanName : appContext.getBeanNamesForType(RemoteService.class)) {
            Class<?> beanClass;
            GWTRequestMapping requestMapping;
            Object service = appContext.getBean(beanName);
            if (service == null || (requestMapping = ReflectionUtils.findAnnotation(beanClass = service.getClass(), GWTRequestMapping.class)) == null) continue;
            String mapping = requestMapping.value();
            if (this.getMappings().containsKey(mapping)) {
                this.logger.warn((Object)("Bean '" + mapping + "' already in mapping, skipping."));
                continue;
            }
            this.getMappings().put(mapping, service);
        }
        if (this.scanParentApplicationContext) {
            this.scanForAnnotatedBeans(appContext.getParent());
        }
    }

    public void setScanParentApplicationContext(boolean scanParentApplicationContext) {
        this.scanParentApplicationContext = scanParentApplicationContext;
    }

    private RPCServiceExporter initServiceInstance(RPCServiceExporter exporter, Object service, Class<RemoteService>[] serviceInterfaces) {
        try {
            exporter.setResponseCachingDisabled(this.disableResponseCaching);
            exporter.setServletContext(this.getServletContext());
            exporter.setServletConfig(this.servletConfig);
            exporter.setService(service);
            exporter.setServiceInterfaces(serviceInterfaces);
            exporter.setThrowUndeclaredExceptionToServletContainer(this.throwUndeclaredExceptionToServletContainer);
            exporter.afterPropertiesSet();
            return exporter;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Map<String, Object> getMappings() {
        return this._mapping;
    }

    public void setMappings(Map<String, Object> mapping) {
        this._mapping = mapping;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.factory == null) {
            this.factory = new DefaultRPCServiceExporterFactory();
        }
        this.scanForAnnotatedBeans(this.getApplicationContext());
        for (Map.Entry<String, Object> entry : this._mapping.entrySet()) {
            RPCServiceExporter exporter = this.factory.create();
            this.registerHandler(entry.getKey(), this.initServiceInstance(exporter, entry.getValue(), ReflectionUtils.getExposedInterfaces(entry.getValue().getClass())));
        }
        this._mapping = null;
    }

    public void setServiceExporterFactory(RPCServiceExporterFactory factory) {
        this.factory = factory;
    }

    public void setDisableResponseCaching(boolean disableResponseCaching) {
        this.disableResponseCaching = disableResponseCaching;
    }

    public void setThrowUndeclaredExceptionToServletContainer(boolean throwUndeclaredExceptionToServletContainer) {
        this.throwUndeclaredExceptionToServletContainer = throwUndeclaredExceptionToServletContainer;
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }
}

