/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.bean;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.MorpherRegistry;
import net.sf.ezmorph.ObjectMorpher;
import net.sf.ezmorph.object.IdentityObjectMorpher;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class BeanMorpher
implements ObjectMorpher {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$ezmorph$bean$BeanMorpher == null ? (class$net$sf$ezmorph$bean$BeanMorpher = BeanMorpher.class$("net.sf.ezmorph.bean.BeanMorpher")) : class$net$sf$ezmorph$bean$BeanMorpher));
    private final Class beanClass;
    private boolean lenient;
    private final MorpherRegistry morpherRegistry;
    static /* synthetic */ Class class$net$sf$ezmorph$bean$BeanMorpher;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$apache$commons$beanutils$DynaBean;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Map;

    public BeanMorpher(Class beanClass, MorpherRegistry morpherRegistry) {
        this(beanClass, morpherRegistry, false);
    }

    public BeanMorpher(Class beanClass, MorpherRegistry morpherRegistry, boolean lenient) {
        this.validateClass(beanClass);
        if (morpherRegistry == null) {
            throw new MorphException("morpherRegistry is null");
        }
        this.beanClass = beanClass;
        this.morpherRegistry = morpherRegistry;
        this.lenient = lenient;
    }

    public Object morph(Object sourceBean) {
        if (sourceBean == null) {
            return null;
        }
        if (!this.supports(sourceBean.getClass())) {
            throw new MorphException("unsupported class: " + sourceBean.getClass().getName());
        }
        Object targetBean = null;
        try {
            targetBean = this.beanClass.newInstance();
            PropertyDescriptor[] targetPds = PropertyUtils.getPropertyDescriptors((Class)this.beanClass);
            for (int i = 0; i < targetPds.length; ++i) {
                PropertyDescriptor targetPd = targetPds[i];
                String name = targetPd.getName();
                if (targetPd.getWriteMethod() == null) {
                    log.info((Object)("Property '" + this.beanClass.getName() + "." + name + "' has no write method. SKIPPED."));
                    continue;
                }
                Class sourceType = null;
                if (sourceBean instanceof DynaBean) {
                    DynaBean dynaBean = (DynaBean)sourceBean;
                    DynaProperty dynaProperty = dynaBean.getDynaClass().getDynaProperty(name);
                    sourceType = dynaProperty.getType();
                } else {
                    PropertyDescriptor sourcePd = PropertyUtils.getPropertyDescriptor((Object)sourceBean, (String)name);
                    if (sourcePd.getReadMethod() == null) {
                        log.warn((Object)("Property '" + sourceBean.getClass().getName() + "." + name + "' has no read method. SKIPPED."));
                        continue;
                    }
                    sourceType = sourcePd.getPropertyType();
                }
                Class<?> targetType = targetPd.getPropertyType();
                Object value = PropertyUtils.getProperty((Object)sourceBean, (String)name);
                this.setProperty(targetBean, name, sourceType, targetType, value);
            }
        }
        catch (MorphException me) {
            throw me;
        }
        catch (Exception e) {
            throw new MorphException(e);
        }
        return targetBean;
    }

    public Class morphsTo() {
        return this.beanClass;
    }

    public boolean supports(Class clazz) {
        return !clazz.isArray();
    }

    private void setProperty(Object targetBean, String name, Class sourceType, Class targetType, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (targetType.isAssignableFrom(sourceType)) {
            if (value == null && targetType.isPrimitive()) {
                value = this.morpherRegistry.morph(targetType, value);
            }
            PropertyUtils.setProperty((Object)targetBean, (String)name, (Object)value);
        } else if (targetType.equals(class$java$lang$Object == null ? (class$java$lang$Object = BeanMorpher.class$("java.lang.Object")) : class$java$lang$Object)) {
            PropertyUtils.setProperty((Object)targetBean, (String)name, (Object)value);
        } else if (value == null) {
            if (targetType.isPrimitive()) {
                PropertyUtils.setProperty((Object)targetBean, (String)name, (Object)this.morpherRegistry.morph(targetType, value));
            }
        } else if (IdentityObjectMorpher.getInstance() == this.morpherRegistry.getMorpherFor(targetType)) {
            if (!this.lenient) {
                throw new MorphException("Can't find a morpher for target class " + targetType.getName() + " (" + name + ")");
            }
            log.info((Object)("Can't find a morpher for target class " + targetType.getName() + " (" + name + ") SKIPPED"));
        } else {
            PropertyUtils.setProperty((Object)targetBean, (String)name, (Object)this.morpherRegistry.morph(targetType, value));
        }
    }

    private void validateClass(Class clazz) {
        if (clazz == null) {
            throw new MorphException("target class is null");
        }
        if (clazz.isPrimitive()) {
            throw new MorphException("target class is a primitive");
        }
        if (clazz.isArray()) {
            throw new MorphException("target class is an array");
        }
        if (clazz.isInterface()) {
            throw new MorphException("target class is an interface");
        }
        if ((class$org$apache$commons$beanutils$DynaBean == null ? (class$org$apache$commons$beanutils$DynaBean = BeanMorpher.class$("org.apache.commons.beanutils.DynaBean")) : class$org$apache$commons$beanutils$DynaBean).isAssignableFrom(clazz)) {
            throw new MorphException("target class is a DynaBean");
        }
        if ((class$java$lang$Number == null ? (class$java$lang$Number = BeanMorpher.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = BeanMorpher.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(clazz) || (class$java$lang$Character == null ? (class$java$lang$Character = BeanMorpher.class$("java.lang.Character")) : class$java$lang$Character).isAssignableFrom(clazz)) {
            throw new MorphException("target class is a wrapper");
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = BeanMorpher.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz)) {
            throw new MorphException("target class is a String");
        }
        if ((class$java$util$Collection == null ? (class$java$util$Collection = BeanMorpher.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz)) {
            throw new MorphException("target class is a Collection");
        }
        if ((class$java$util$Map == null ? (class$java$util$Map = BeanMorpher.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(clazz)) {
            throw new MorphException("target class is a Map");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

