/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.DecryptParams;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.Salt;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class Priv3DES
implements PrivacyProtocol {
    public static final OID ID = new OID("1.3.6.1.6.3.10.1.2.3");
    private static final int DECRYPT_PARAMS_LENGTH = 8;
    protected Salt salt = Salt.getInstance();
    private static final LogAdapter logger = LogFactory.getLogger(class$org$snmp4j$security$Priv3DES == null ? (class$org$snmp4j$security$Priv3DES = Priv3DES.class$("org.snmp4j.security.Priv3DES")) : class$org$snmp4j$security$Priv3DES);
    static /* synthetic */ Class class$org$snmp4j$security$Priv3DES;

    public byte[] encrypt(byte[] unencryptedData, int offset, int length, byte[] encryptionKey, long engineBoots, long engineTime, DecryptParams decryptParams) {
        byte[] encryptedData;
        block12: {
            int mySalt = (int)this.salt.getNext();
            if (encryptionKey.length < 32) {
                logger.error("Wrong Key length: need at least 32 bytes, is " + encryptionKey.length + " bytes.");
                throw new IllegalArgumentException("encryptionKey has illegal length " + encryptionKey.length + " (should be at least 32).");
            }
            if (decryptParams.array == null || decryptParams.length < 8) {
                decryptParams.array = new byte[8];
            }
            decryptParams.length = 8;
            decryptParams.offset = 0;
            if (logger.isDebugEnabled()) {
                logger.debug("Preparing decrypt_params.");
            }
            for (int i = 0; i < 4; ++i) {
                decryptParams.array[3 - i] = (byte)(0xFFL & engineBoots >> 8 * i);
                decryptParams.array[7 - i] = (byte)(0xFF & mySalt >> 8 * i);
            }
            byte[] iv = new byte[8];
            if (logger.isDebugEnabled()) {
                logger.debug("Preparing iv for encryption.");
            }
            for (int i = 0; i < 8; ++i) {
                iv[i] = (byte)(encryptionKey[24 + i] ^ decryptParams.array[i]);
            }
            encryptedData = null;
            try {
                Cipher alg = Cipher.getInstance("DESede/CBC/NoPadding");
                SecretKeySpec key = new SecretKeySpec(encryptionKey, 0, 24, "DESede");
                IvParameterSpec ivSpec = new IvParameterSpec(iv);
                alg.init(1, (Key)key, ivSpec);
                if (length % 8 == 0) {
                    encryptedData = alg.doFinal(unencryptedData, offset, length);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Using padding.");
                    }
                    encryptedData = new byte[8 * (length / 8 + 1)];
                    byte[] tmp = new byte[8];
                    int encryptedLength = alg.update(unencryptedData, offset, length, encryptedData);
                    encryptedLength += alg.doFinal(tmp, 0, 8 - length % 8, encryptedData, encryptedLength);
                }
            }
            catch (Exception e) {
                logger.error(e);
                if (!logger.isDebugEnabled()) break block12;
                e.printStackTrace();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Encryption finished.");
        }
        return encryptedData;
    }

    public byte[] decrypt(byte[] cryptedData, int offset, int length, byte[] decryptionKey, long engineBoots, long engineTime, DecryptParams decryptParams) {
        byte[] decryptedData;
        block5: {
            if (length % 8 != 0 || length < 8 || decryptParams.length != 8) {
                throw new IllegalArgumentException("Length (" + length + ") is not multiple of 8 or decrypt " + "params has not length 8 (" + decryptParams.length + ").");
            }
            if (decryptionKey.length < 32) {
                logger.error("Wrong Key length: need at least 32 bytes, is " + decryptionKey.length + " bytes.");
                throw new IllegalArgumentException("decryptionKey has illegal length " + decryptionKey.length + " (should be at least 32).");
            }
            byte[] iv = new byte[8];
            for (int i = 0; i < 8; ++i) {
                iv[i] = (byte)(decryptionKey[24 + i] ^ decryptParams.array[i]);
            }
            decryptedData = null;
            try {
                Cipher alg = Cipher.getInstance("DESede/CBC/NoPadding");
                SecretKeySpec key = new SecretKeySpec(decryptionKey, 0, 24, "DESede");
                IvParameterSpec ivSpec = new IvParameterSpec(iv);
                alg.init(2, (Key)key, ivSpec);
                decryptedData = alg.doFinal(cryptedData, offset, length);
            }
            catch (Exception e) {
                logger.error(e);
                if (!logger.isDebugEnabled()) break block5;
                e.printStackTrace();
            }
        }
        return decryptedData;
    }

    public OID getID() {
        return (OID)ID.clone();
    }

    public int getEncryptedLength(int scopedPDULength) {
        if (scopedPDULength % 8 == 0) {
            return scopedPDULength;
        }
        return 8 * (scopedPDULength / 8 + 1);
    }

    public int getMinKeyLength() {
        return 32;
    }

    public int getDecryptParamsLength() {
        return 8;
    }

    public int getMaxKeyLength() {
        return this.getMinKeyLength();
    }

    public byte[] extendShortKey(byte[] shortKey, OctetString password, byte[] engineID, AuthenticationProtocol authProtocol) {
        int copyBytes;
        byte[] extendedKey = new byte[this.getMinKeyLength()];
        System.arraycopy(shortKey, 0, extendedKey, 0, shortKey.length);
        for (int length = shortKey.length; length < this.getMinKeyLength(); length += copyBytes) {
            byte[] key = authProtocol.passwordToKey(new OctetString(extendedKey, 0, length), engineID);
            copyBytes = Math.min(this.getMinKeyLength() - length, authProtocol.getDigestLength());
            System.arraycopy(key, 0, extendedKey, length, copyBytes);
        }
        return extendedKey;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

