/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.mvc.view;

import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.util.StringUtils;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.webflow.engine.builder.BinderConfiguration;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.View;
import org.springframework.webflow.execution.ViewFactory;
import org.springframework.webflow.mvc.view.AbstractMvcView;
import org.springframework.webflow.mvc.view.FlowViewResolver;
import org.springframework.webflow.mvc.view.ViewActionStateHolder;

public abstract class AbstractMvcViewFactory
implements ViewFactory {
    private Expression viewId;
    private FlowViewResolver viewResolver;
    private ExpressionParser expressionParser;
    private ConversionService conversionService;
    private BinderConfiguration binderConfiguration;
    private String eventIdParameterName;
    private String fieldMarkerPrefix;
    private MessageCodesResolver messageCodesResolver;

    public AbstractMvcViewFactory(Expression viewId, FlowViewResolver viewResolver, ExpressionParser expressionParser, ConversionService conversionService, BinderConfiguration binderConfiguration, MessageCodesResolver messageCodesResolver) {
        this.viewId = viewId;
        this.viewResolver = viewResolver;
        this.expressionParser = expressionParser;
        this.conversionService = conversionService;
        this.binderConfiguration = binderConfiguration;
        this.messageCodesResolver = messageCodesResolver;
    }

    public void setEventIdParameterName(String eventIdParameterName) {
        this.eventIdParameterName = eventIdParameterName;
    }

    public void setFieldMarkerPrefix(String fieldMarkerPrefix) {
        this.fieldMarkerPrefix = fieldMarkerPrefix;
    }

    public View getView(RequestContext context) {
        ViewActionStateHolder stateHolder;
        String viewId = (String)this.viewId.getValue((Object)context);
        org.springframework.web.servlet.View view = this.viewResolver.resolveView(viewId, context);
        AbstractMvcView mvcView = this.createMvcView(view, context);
        mvcView.setExpressionParser(this.expressionParser);
        mvcView.setConversionService(this.conversionService);
        mvcView.setBinderConfiguration(this.binderConfiguration);
        mvcView.setMessageCodesResolver(this.messageCodesResolver);
        if (StringUtils.hasText((String)this.eventIdParameterName)) {
            mvcView.setEventIdParameterName(this.eventIdParameterName);
        }
        if (StringUtils.hasText((String)this.fieldMarkerPrefix)) {
            mvcView.setFieldMarkerPrefix(this.fieldMarkerPrefix);
        }
        if ((stateHolder = (ViewActionStateHolder)context.getFlashScope().get("viewUserEventState")) != null) {
            mvcView.restoreState(stateHolder);
        }
        return mvcView;
    }

    protected abstract AbstractMvcView createMvcView(org.springframework.web.servlet.View var1, RequestContext var2);
}

