/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor;

import org.springframework.webflow.execution.FlowExecutionOutcome;

public class FlowExecutionResult {
    private String flowId;
    private String flowExecutionKey;
    private FlowExecutionOutcome outcome;

    private FlowExecutionResult(String flowId, String flowExecutionKey, FlowExecutionOutcome outcome) {
        this.flowId = flowId;
        this.flowExecutionKey = flowExecutionKey;
        this.outcome = outcome;
    }

    public static FlowExecutionResult createPausedResult(String flowId, String flowExecutionKey) {
        return new FlowExecutionResult(flowId, flowExecutionKey, null);
    }

    public static FlowExecutionResult createEndedResult(String flowId, FlowExecutionOutcome outcome) {
        return new FlowExecutionResult(flowId, null, outcome);
    }

    public String getFlowId() {
        return this.flowId;
    }

    public boolean isPaused() {
        return this.flowExecutionKey != null;
    }

    public String getPausedKey() {
        return this.flowExecutionKey;
    }

    public boolean isEnded() {
        return this.flowExecutionKey == null;
    }

    public FlowExecutionOutcome getOutcome() {
        return this.outcome;
    }
}

