/*
 * Decompiled with CFR 0.152.
 */
package geo.google.utils;

import geo.google.utils.NodeProcessor;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    private static final XPathFactory XPATH_FACTORY = XPathFactory.newInstance();

    public static XPath newXPath() {
        return XPATH_FACTORY.newXPath();
    }

    public static Document parse(String xml) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(XmlUtils.stringToInputSource(xml));
    }

    public static InputSource stringToInputSource(String xml) {
        return new InputSource(new StringReader(xml));
    }

    public static String selectValue(Node context, String xpath) throws XPathExpressionException {
        return XmlUtils.newXPath().evaluate(xpath, context);
    }

    public static Node selectNode(Node context, String xpath) throws XPathExpressionException {
        return (Node)XmlUtils.newXPath().evaluate(xpath, context, XPathConstants.NODE);
    }

    public static void traverseTreeDepthFirst(Node node, NodeProcessor processor) {
        processor.preProcess(node);
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            XmlUtils.traverseTreeDepthFirst(child, processor);
        }
        processor.postProcess(node);
    }
}

