/*
 * Decompiled with CFR 0.152.
 */
package geo.google.mapping;

import geo.google.GeoException;
import geo.google.datamodel.GeoAddress;
import geo.google.datamodel.GeoUsAddress;
import geo.google.mapping.Functor;
import java.util.List;
import oasis.names.tc.ciq.xsdschema.xal._2.AddressDetails;
import oasis.names.tc.ciq.xsdschema.xal._2.AdministrativeArea;
import oasis.names.tc.ciq.xsdschema.xal._2.Locality;
import oasis.names.tc.ciq.xsdschema.xal._2.PostalCode;
import oasis.names.tc.ciq.xsdschema.xal._2.ThoroughfareNameType;
import org.apache.commons.collections.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AddressToUsAddressFunctor
implements Functor<GeoUsAddress, GeoAddress, GeoException> {
    private static final AddressToUsAddressFunctor _instance = new AddressToUsAddressFunctor();

    public static AddressToUsAddressFunctor getInstance() {
        return _instance;
    }

    @Override
    public GeoUsAddress execute(GeoAddress addr) {
        GeoUsAddress ret = new GeoUsAddress();
        AddressDetails.Country country = addr.getAddressDetails().getCountry();
        if (country != null) {
            AdministrativeArea adminArea;
            List<AddressDetails.Country.CountryNameCode> countryNames = country.getCountryNameCode();
            if (CollectionUtils.isNotEmpty(countryNames)) {
                ret.setCountry(countryNames.get(0).getContent());
            }
            if ((adminArea = country.getAdministrativeArea()) != null) {
                List<AdministrativeArea.SubAdministrativeArea.SubAdministrativeAreaName> subNames;
                AdministrativeArea.SubAdministrativeArea subAdminArea;
                Locality locality;
                List<AdministrativeArea.AdministrativeAreaName> names = adminArea.getAdministrativeAreaName();
                if (CollectionUtils.isNotEmpty(names)) {
                    ret.setState(names.get(0).getContent());
                }
                Locality locality2 = locality = (subAdminArea = adminArea.getSubAdministrativeArea()) == null ? adminArea.getLocality() : subAdminArea.getLocality();
                if (subAdminArea != null && CollectionUtils.isNotEmpty(subNames = subAdminArea.getSubAdministrativeAreaName())) {
                    ret.setCounty(subNames.get(0).getContent());
                }
                if (locality != null) {
                    List<ThoroughfareNameType> thoroughfares;
                    PostalCode postalCode;
                    List<PostalCode.PostalCodeNumber> numbers;
                    List<Locality.LocalityName> localNames = locality.getLocalityName();
                    if (CollectionUtils.isNotEmpty(localNames)) {
                        ret.setCity(localNames.get(0).getContent());
                    }
                    if (CollectionUtils.isNotEmpty(numbers = (postalCode = locality.getPostalCode()).getPostalCodeNumber())) {
                        ret.setPostalCode(numbers.get(0).getContent());
                    }
                    if (locality.getThoroughfare() != null && CollectionUtils.isNotEmpty(thoroughfares = locality.getThoroughfare().getThoroughfareName())) {
                        ret.setAddressLine1(thoroughfares.get(0).getContent());
                        if (thoroughfares.size() > 1) {
                            ret.setAddressLine2(thoroughfares.get(1).getContent());
                        }
                    }
                }
            }
        }
        if (addr.getCoordinate() != null) {
            ret.setCoordinate(addr.getCoordinate().clone());
        }
        ret.setAccuracy(addr.getAccuracy());
        return ret;
    }
}

